/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.stdimpl.aliases;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.aliases.type$iterator;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.type$ref;

public abstract class StdMapUIntType<ValueT>
implements Native.assignable<std.mapUIntType<ValueT>>,
NativeCloneable<std.mapUIntType<ValueT>>,
Destructors.ClassWithDestructor {
    protected ValueT defaultValue;
    protected TreeMap<Long, std.pairUIntType<ValueT>> treeMap;

    protected StdMapUIntType(ValueT defaultValue) {
        this(null, defaultValue);
    }

    protected StdMapUIntType(Comparator<Long> comparator, ValueT defaultValue) {
        this.treeMap = new TreeMap(comparator != null ? comparator : new DefaultComparator());
        this.defaultValue = defaultValue;
    }

    protected StdMapUIntType(std.mapUIntType<ValueT> other) {
        this(other.treeMap.comparator(), other.defaultValue);
        this.$assign(other);
    }

    @Override
    public std.mapUIntType<ValueT> $assign(std.mapUIntType<ValueT> other) {
        this.clear();
        for (Map.Entry entry : other.treeMap.entrySet()) {
            this.treeMap.put((Long)entry.getKey(), std.make_pair_uint_T((Long)entry.getKey(), this.isDataPointerLike() ? ((std.pairUIntType)entry.getValue()).second : Native.$tryClone(((std.pairUIntType)entry.getValue()).second)));
        }
        return (std.mapUIntType)this;
    }

    public void swap(std.mapUIntType<ValueT> other) {
        TreeMap<Long, std.pairUIntType<ValueT>> tmpMap = this.treeMap;
        this.treeMap = other.treeMap;
        other.treeMap = tmpMap;
        ValueT tmpDefVal = this.defaultValue;
        this.defaultValue = other.defaultValue;
        other.defaultValue = tmpDefVal;
    }

    public ValueT $at(Long key) {
        std.pairUIntType<ValueT> out = this.treeMap.get(key);
        if (out == null) {
            out = std.make_pair_uint_T(key, Native.$tryClone(this.defaultValue));
            this.treeMap.put(key, out);
        }
        return (ValueT)out.second;
    }

    public type$ref<ValueT> ref$at(final Long key) {
        if (!this.treeMap.containsKey(key)) {
            this.treeMap.put(key, std.make_pair_uint_T(key, Native.$tryClone(this.defaultValue)));
        }
        return new type$ref<ValueT>(){

            @Override
            public ValueT $deref() {
                return StdMapUIntType.this.treeMap.get((Object)key).second;
            }

            @Override
            public ValueT $set(ValueT value) {
                StdMapUIntType.this.treeMap.get((Object)key).second = StdMapUIntType.this.isDataPointerLike() ? value : Native.$tryClone(value);
                return value;
            }

            @Override
            public type$ptr<ValueT> deref$ptr() {
                throw new UnsupportedOperationException("Not supported.");
            }
        };
    }

    public int size() {
        return this.treeMap.size();
    }

    public boolean empty() {
        return this.treeMap.isEmpty();
    }

    public void clear() {
        if (!this.isDataPointerLike()) {
            for (Map.Entry<Long, std.pairUIntType<ValueT>> entry : this.treeMap.entrySet()) {
                Native.destroy(entry.getValue().second);
            }
        }
        this.treeMap.clear();
    }

    public std.pairTypeBool<iterator<ValueT>> insert(std.pairUIntType<ValueT> val) {
        boolean newElement = !this.treeMap.containsKey(val.first);
        this.treeMap.put(val.first, std.make_pair_uint_T(val.first, this.isDataPointerLike() ? val.second : Native.$tryClone(val.second)));
        return std.make_pair(this.find(val.first), newElement);
    }

    public void insert(type$iterator<?, std.pairUIntType<ValueT>> I, type$iterator<?, std.pairUIntType<ValueT>> E) {
        while (Native.$noteq(I, E)) {
            std.pairUIntType<ValueT> val = I.$star();
            this.treeMap.put(val.first, std.make_pair_uint_T(val.first, this.isDataPointerLike() ? val.second : Native.$tryClone(val.second)));
            I.$preInc();
        }
    }

    public void erase(iterator<ValueT> position) {
        if (!this.isDataPointerLike()) {
            Native.destroy(((std.pairUIntType)position.$star()).second);
        }
        ((iterator)position).erase();
    }

    public boolean erase(Long key) {
        if (!this.treeMap.containsKey(key)) {
            return false;
        }
        if (!this.isDataPointerLike()) {
            Native.destroy(this.treeMap.get((Object)key).second);
        }
        this.treeMap.remove(key);
        return true;
    }

    public iterator<ValueT> lower_bound(Long key) {
        Long lowerBoundKey = this.treeMap.ceilingKey(key);
        return lowerBoundKey != null ? this.find(lowerBoundKey) : this.end();
    }

    public iterator<ValueT> upper_bound(Long key) {
        iterator<ValueT> upperBound = this.lower_bound(key);
        while (upperBound.$noteq(this.end()) && this.treeMap.comparator().compare(key, ((iterator)upperBound).getKey()) >= 0) {
            upperBound.$preInc();
        }
        return upperBound;
    }

    public iterator<ValueT> begin() {
        return new iterator(this.treeMap, this.treeMap.firstEntry(), this.defaultValue, false);
    }

    public iterator<ValueT> end() {
        return new iterator(this.treeMap, null, this.defaultValue, false);
    }

    public boolean count(Long key) {
        return this.treeMap.containsKey(key);
    }

    public boolean replaceValueReference(Long key, ValueT val) {
        std.pairUIntType<ValueT> entry = this.treeMap.get(key);
        assert (entry != null) : "must be called only for existing entry " + key + " => " + val;
        entry.second = val;
        return true;
    }

    public iterator<ValueT> find(Long key) {
        if (!this.treeMap.containsKey(key)) {
            return this.end();
        }
        Comparator<Long> comparator = this.treeMap.comparator();
        iterator<ValueT> I = this.begin();
        iterator<ValueT> E = this.end();
        while (I.$noteq(E)) {
            if (comparator.compare(((iterator)I).getKey(), key) == 0) {
                return I;
            }
            I.$preInc();
        }
        throw new AssertionError((Object)"Why not found???");
    }

    @Override
    public std.mapUIntType<ValueT> clone() {
        return new std.mapUIntType((std.mapUIntType)this);
    }

    @Override
    public void $destroy() {
        this.clear();
    }

    private boolean isDataPointerLike() {
        return this.defaultValue == null;
    }

    public String toString() {
        return "StdMapUIntType{" + this.treeMap + "}";
    }

    public static class iterator<ValueT>
    implements type$iterator<iterator<ValueT>, std.pairUIntType<ValueT>> {
        private final ValueT defaultValue;
        private final TreeMap<Long, std.pairUIntType<ValueT>> map;
        private final boolean _const;
        private Map.Entry<Long, std.pairUIntType<ValueT>> currentEntry;

        private iterator(TreeMap<Long, std.pairUIntType<ValueT>> map2, Map.Entry<Long, std.pairUIntType<ValueT>> curr, ValueT defaultValue, boolean asConst) {
            this.defaultValue = defaultValue;
            this.map = map2;
            this.currentEntry = curr;
            this._const = asConst;
        }

        private Long getKey() {
            return this.currentEntry.getKey();
        }

        private void erase() {
            this.map.remove(this.currentEntry.getKey());
        }

        public std.pairUIntType<ValueT> $arrow() {
            return this.currentEntry.getValue();
        }

        @Override
        public std.pairUIntType<ValueT> $star() {
            return this.currentEntry.getValue();
        }

        @Override
        public type$ref<std.pairUIntType<ValueT>> star$ref() {
            return new type$ref<std.pairUIntType<ValueT>>(){
                private final Map.Entry<Long, std.pairUIntType<ValueT>> localEntry;
                {
                    this.localEntry = iterator.this.currentEntry;
                }

                @Override
                public std.pairUIntType<ValueT> $deref() {
                    return this.localEntry.getValue();
                }

                @Override
                public std.pairUIntType<ValueT> $set(std.pairUIntType<ValueT> value) {
                    assert (iterator.this.map.comparator().compare(value.first, this.localEntry.getKey()) == 0) : "Trying to change key of entry via iterator!";
                    this.localEntry.getValue().second = Native.$tryAssign(this.localEntry.getValue().second, value.second, iterator.this.isDataPointerLike());
                    return value;
                }

                @Override
                public type$ptr<std.pairUIntType<ValueT>> deref$ptr() {
                    throw new UnsupportedOperationException("Not supported.");
                }
            };
        }

        @Override
        public iterator<ValueT> $preInc() {
            this.currentEntry = this.map.higherEntry(this.currentEntry.getKey());
            return this;
        }

        @Override
        public iterator<ValueT> $postInc() {
            Object cloned = this.clone();
            this.$preInc();
            return cloned;
        }

        @Override
        public iterator<ValueT> clone() {
            return new iterator<ValueT>(this.map, this.currentEntry, this.defaultValue, false);
        }

        @Override
        public iterator<ValueT> const_clone() {
            return new iterator<ValueT>(this.map, this.currentEntry, this.defaultValue, true);
        }

        public boolean $eq(Object other) {
            if (other instanceof iterator) {
                iterator otherIter = (iterator)other;
                if (otherIter.map == this.map) {
                    if (otherIter.currentEntry == null) {
                        return this.currentEntry == null;
                    }
                    if (this.currentEntry == null) {
                        return otherIter.currentEntry == null;
                    }
                    return Native.$eq(otherIter.currentEntry.getKey(), this.currentEntry.getKey());
                }
            }
            return false;
        }

        public boolean $noteq(Object other) {
            return !this.$eq(other);
        }

        @Override
        public int $sub(iterator<ValueT> iter) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<ValueT> $preDec() {
            this.currentEntry = this.currentEntry == null ? this.map.lastEntry() : this.map.lowerEntry(this.currentEntry.getKey());
            return this;
        }

        @Override
        public iterator<ValueT> $postDec() {
            Object cloned = this.clone();
            this.$preDec();
            return cloned;
        }

        @Override
        public iterator<ValueT> $inc(int amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<ValueT> $inc(long amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<ValueT> $dec(int amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<ValueT> $dec(long amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<ValueT> $add(int amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<ValueT> $add(long amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<ValueT> $sub(int amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<ValueT> $sub(long amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        private boolean isDataPointerLike() {
            return this.defaultValue == null;
        }
    }

    private static class DefaultComparator<Long>
    implements Comparator<Long> {
        private DefaultComparator() {
        }

        @Override
        public int compare(Long o1, Long o2) {
            if (o1 instanceof Native.ComparableLower) {
                if (((Native.ComparableLower)o1).$less(o2)) {
                    return -1;
                }
                return ((Native.ComparableLower)o2).$less(o1) ? 1 : 0;
            }
            if (o1 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            throw new UnsupportedOperationException("NO ComparableLower: " + o1.getClass() + " vs. " + o2.getClass());
        }
    }
}

