/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.java.classpath.SPIAccessor;
import org.netbeans.spi.java.classpath.GlobalPathRegistryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public final class GlobalPathRegistry {
    private static final Logger LOG = Logger.getLogger(GlobalPathRegistry.class.getName());
    private static final Map<GlobalPathRegistryImplementation, Reference<GlobalPathRegistry>> instances = new WeakHashMap<GlobalPathRegistryImplementation, Reference<GlobalPathRegistry>>();
    private final GlobalPathRegistryImplementation spi;
    private int resetCount;
    private final List<GlobalPathRegistryListener> listeners = new ArrayList<GlobalPathRegistryListener>();
    private Set<FileObject> sourceRoots = null;
    private Set<SourceForBinaryQuery.Result> results = new HashSet<SourceForBinaryQuery.Result>();
    private final ChangeListener resultListener = new SFBQListener();
    private PropertyChangeListener classpathListener = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            GlobalPathRegistry globalPathRegistry = GlobalPathRegistry.this;
            synchronized (globalPathRegistry) {
                GlobalPathRegistry.this.resetSourceRootsCache();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static GlobalPathRegistry getDefault() {
        GlobalPathRegistryImplementation spi = (GlobalPathRegistryImplementation)Lookup.getDefault().lookup(GlobalPathRegistryImplementation.class);
        if (spi == null) {
            throw new IllegalStateException("No GlobalPathRegistryImplementation found in the lookup");
        }
        Map<GlobalPathRegistryImplementation, Reference<GlobalPathRegistry>> map = instances;
        synchronized (map) {
            GlobalPathRegistry api;
            Reference<GlobalPathRegistry> apiRef = instances.get(spi);
            if (apiRef == null || (api = apiRef.get()) == null) {
                api = new GlobalPathRegistry(spi);
                SPIAccessor.getInstance().attachAPI(spi, api);
                instances.put(spi, new WeakReference<GlobalPathRegistry>(api));
            }
            return api;
        }
    }

    private GlobalPathRegistry(@NonNull GlobalPathRegistryImplementation spi) {
        Parameters.notNull((CharSequence)"spi", (Object)spi);
        this.spi = spi;
    }

    void clear() {
        SPIAccessor.getInstance().clear(this.spi);
        this.listeners.clear();
        this.sourceRoots = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Set<ClassPath> getPaths(@NonNull String id) {
        Parameters.notNull((CharSequence)"id", (Object)id);
        GlobalPathRegistry globalPathRegistry = this;
        synchronized (globalPathRegistry) {
            return SPIAccessor.getInstance().getPaths(this.spi, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(@NonNull String id, @NonNull ClassPath[] paths) {
        Set<ClassPath> added;
        Parameters.notNull((CharSequence)"id", (Object)id);
        Parameters.notNull((CharSequence)"paths", (Object)paths);
        LOG.log(Level.FINE, "registering paths {0} of type {1}", new Object[]{Arrays.asList(paths), id});
        GlobalPathRegistryListener[] _listeners = null;
        GlobalPathRegistry globalPathRegistry = this;
        synchronized (globalPathRegistry) {
            added = SPIAccessor.getInstance().register(this.spi, id, paths);
            for (ClassPath path : added) {
                path.addPropertyChangeListener(this.classpathListener);
            }
            this.resetSourceRootsCache();
            if (LOG.isLoggable(Level.FINER)) {
                Set<ClassPath> l = SPIAccessor.getInstance().getPaths(this.spi, id);
                LOG.log(Level.FINER, "now have {0} paths of type {1}", new Object[]{l.size(), id});
            }
            if (!this.listeners.isEmpty() && !added.isEmpty()) {
                _listeners = this.listeners.toArray(new GlobalPathRegistryListener[this.listeners.size()]);
            }
        }
        if (_listeners != null) {
            for (GlobalPathRegistryListener listener : _listeners) {
                listener.pathsAdded(new GlobalPathRegistryEvent(this, id, Collections.unmodifiableSet(added)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(@NonNull String id, @NonNull ClassPath[] paths) throws IllegalArgumentException {
        Set<ClassPath> removed;
        Parameters.notNull((CharSequence)"id", (Object)id);
        Parameters.notNull((CharSequence)"paths", (Object)paths);
        LOG.log(Level.FINE, "unregistering paths {0} of type {1}", new Object[]{Arrays.asList(paths), id});
        GlobalPathRegistryListener[] _listeners = null;
        GlobalPathRegistry globalPathRegistry = this;
        synchronized (globalPathRegistry) {
            removed = SPIAccessor.getInstance().unregister(this.spi, id, paths);
            for (ClassPath path : removed) {
                path.removePropertyChangeListener(this.classpathListener);
            }
            this.resetSourceRootsCache();
            if (LOG.isLoggable(Level.FINER)) {
                Set<ClassPath> l = SPIAccessor.getInstance().getPaths(this.spi, id);
                LOG.log(Level.FINER, "now have {0} paths of type {1}", new Object[]{l.size(), id});
            }
            if (!this.listeners.isEmpty() && !removed.isEmpty()) {
                _listeners = this.listeners.toArray(new GlobalPathRegistryListener[this.listeners.size()]);
            }
        }
        if (_listeners != null) {
            for (GlobalPathRegistryListener listener : _listeners) {
                listener.pathsRemoved(new GlobalPathRegistryEvent(this, id, Collections.unmodifiableSet(removed)));
            }
        }
    }

    public synchronized void addGlobalPathRegistryListener(GlobalPathRegistryListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this.listeners.add(l);
    }

    public synchronized void removeGlobalPathRegistryListener(GlobalPathRegistryListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<FileObject> getSourceRoots() {
        LinkedHashSet<ClassPath> compileAndBootPaths;
        Set<ClassPath> sourcePaths;
        int currentResetCount;
        GlobalPathRegistry globalPathRegistry = this;
        synchronized (globalPathRegistry) {
            if (this.sourceRoots != null) {
                return this.sourceRoots;
            }
            currentResetCount = this.resetCount;
            sourcePaths = this.getPaths("classpath/source");
            compileAndBootPaths = new LinkedHashSet<ClassPath>(this.getPaths("classpath/compile"));
            compileAndBootPaths.addAll(this.getPaths("classpath/boot"));
        }
        LinkedHashSet<FileObject> newSourceRoots = new LinkedHashSet<FileObject>();
        for (ClassPath sp : sourcePaths) {
            newSourceRoots.addAll(Arrays.asList(sp.getRoots()));
        }
        LinkedList<SourceForBinaryQuery.Result> newResults = new LinkedList<SourceForBinaryQuery.Result>();
        SFBQListener tmpResultListener = new SFBQListener();
        for (ClassPath cp : compileAndBootPaths) {
            for (ClassPath.Entry entry : cp.entries()) {
                SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots(entry.getURL());
                result.addChangeListener(tmpResultListener);
                newResults.add(result);
                FileObject[] someRoots = result.getRoots();
                newSourceRoots.addAll(Arrays.asList(someRoots));
            }
        }
        newSourceRoots = Collections.unmodifiableSet(newSourceRoots);
        GlobalPathRegistry globalPathRegistry2 = this;
        synchronized (globalPathRegistry2) {
            if (this.resetCount == currentResetCount) {
                this.sourceRoots = newSourceRoots;
                this.removeTmpSFBQListeners(newResults, tmpResultListener, true);
                this.results.addAll(newResults);
            } else {
                this.removeTmpSFBQListeners(newResults, tmpResultListener, false);
            }
            return newSourceRoots;
        }
    }

    private void removeTmpSFBQListeners(List<? extends SourceForBinaryQuery.Result> results, ChangeListener listener, boolean addListener) {
        for (SourceForBinaryQuery.Result result : results) {
            if (addListener) {
                result.addChangeListener(this.resultListener);
            }
            result.removeChangeListener(listener);
        }
    }

    public FileObject findResource(String resource) {
        FileObject f;
        for (ClassPath cp : this.getPaths("classpath/source")) {
            f = cp.findResource(resource);
            if (f == null) continue;
            return f;
        }
        for (FileObject root : this.getSourceRoots()) {
            f = root.getFileObject(resource);
            if (f == null) continue;
            for (ClassPath cp : this.getPaths("classpath/source")) {
                if (cp.findOwnerRoot(f) == null) continue;
                return null;
            }
            return f;
        }
        return null;
    }

    private synchronized void resetSourceRootsCache() {
        this.sourceRoots = null;
        Iterator<SourceForBinaryQuery.Result> it = this.results.iterator();
        while (it.hasNext()) {
            SourceForBinaryQuery.Result result = it.next();
            it.remove();
            result.removeChangeListener(this.resultListener);
        }
        ++this.resetCount;
    }

    Set<? extends SourceForBinaryQuery.Result> getResults() {
        return Collections.unmodifiableSet(this.results);
    }

    private class SFBQListener
    implements ChangeListener {
        private SFBQListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent event) {
            GlobalPathRegistry globalPathRegistry = GlobalPathRegistry.this;
            synchronized (globalPathRegistry) {
                GlobalPathRegistry.this.resetSourceRootsCache();
            }
        }
    }
}

