/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.NativeArray;
import jdk.nashorn.internal.objects.annotations.Constructor;
import jdk.nashorn.internal.objects.annotations.Function;
import jdk.nashorn.internal.objects.annotations.Property;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.objects.annotations.Where;
import jdk.nashorn.internal.runtime.ECMAException;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.linker.Lookup;

@ScriptClass(value="Error")
public class NativeError
extends ScriptObject {
    static final MethodHandle GET_COLUMNNUMBER = NativeError.findOwnMH("getColumnNumber", Object.class, Object.class);
    static final MethodHandle SET_COLUMNNUMBER = NativeError.findOwnMH("setColumnNumber", Object.class, Object.class, Object.class);
    static final MethodHandle GET_LINENUMBER = NativeError.findOwnMH("getLineNumber", Object.class, Object.class);
    static final MethodHandle SET_LINENUMBER = NativeError.findOwnMH("setLineNumber", Object.class, Object.class, Object.class);
    static final MethodHandle GET_FILENAME = NativeError.findOwnMH("getFileName", Object.class, Object.class);
    static final MethodHandle SET_FILENAME = NativeError.findOwnMH("setFileName", Object.class, Object.class, Object.class);
    static final MethodHandle GET_STACK = NativeError.findOwnMH("getStack", Object.class, Object.class);
    static final MethodHandle SET_STACK = NativeError.findOwnMH("setStack", Object.class, Object.class, Object.class);
    static final String MESSAGE = "message";
    static final String NAME = "name";
    static final String STACK = "__stack__";
    static final String LINENUMBER = "__lineNumber__";
    static final String COLUMNNUMBER = "__columnNumber__";
    static final String FILENAME = "__fileName__";
    @Property(name="message")
    public Object instMessage;
    @Property(attributes=2, where=Where.PROTOTYPE)
    public Object name;
    @Property(attributes=2, where=Where.PROTOTYPE)
    public Object message;

    NativeError(Object msg) {
        this.setProto(Global.instance().getErrorPrototype());
        if (msg != ScriptRuntime.UNDEFINED) {
            this.instMessage = JSType.toString(msg);
        } else {
            this.delete(MESSAGE, Global.isStrict());
        }
    }

    @Override
    public String getClassName() {
        return "Error";
    }

    @Constructor
    public static Object constructor(boolean newObj, Object self, Object msg) {
        return new NativeError(msg);
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object dumpStack(Object self) {
        Thread.dumpStack();
        return ScriptRuntime.UNDEFINED;
    }

    @Function(attributes=2)
    public static Object printStackTrace(Object self) {
        Global.checkObject(self);
        return ECMAException.printStackTrace((ScriptObject)self);
    }

    public static Object getLineNumber(Object self) {
        Global.checkObject(self);
        ScriptObject sobj = (ScriptObject)self;
        return sobj.has(LINENUMBER) ? sobj.get(LINENUMBER) : ECMAException.getLineNumber(sobj);
    }

    public static Object setLineNumber(Object self, Object value) {
        Global.checkObject(self);
        ScriptObject sobj = (ScriptObject)self;
        sobj.set((Object)LINENUMBER, value, Global.isStrict());
        return value;
    }

    public static Object getColumnNumber(Object self) {
        Global.checkObject(self);
        ScriptObject sobj = (ScriptObject)self;
        return sobj.has(COLUMNNUMBER) ? sobj.get(COLUMNNUMBER) : ECMAException.getColumnNumber((ScriptObject)self);
    }

    public static Object setColumnNumber(Object self, Object value) {
        Global.checkObject(self);
        ScriptObject sobj = (ScriptObject)self;
        sobj.set((Object)COLUMNNUMBER, value, Global.isStrict());
        return value;
    }

    public static Object getFileName(Object self) {
        Global.checkObject(self);
        ScriptObject sobj = (ScriptObject)self;
        return sobj.has(FILENAME) ? sobj.get(FILENAME) : ECMAException.getFileName((ScriptObject)self);
    }

    public static Object setFileName(Object self, Object value) {
        Global.checkObject(self);
        ScriptObject sobj = (ScriptObject)self;
        sobj.set((Object)FILENAME, value, Global.isStrict());
        return value;
    }

    public static Object getStack(Object self) {
        Object[] res;
        Global.checkObject(self);
        ScriptObject sobj = (ScriptObject)self;
        if (sobj.has(STACK)) {
            return sobj.get(STACK);
        }
        Object exception = ECMAException.getException(sobj);
        if (exception instanceof Throwable) {
            StackTraceElement[] frames = ((Throwable)exception).getStackTrace();
            ArrayList<StackTraceElement> filtered = new ArrayList<StackTraceElement>();
            for (StackTraceElement st : frames) {
                if (!ECMAException.isScriptFrame(st)) continue;
                filtered.add(st);
            }
            res = filtered.toArray();
        } else {
            res = ScriptRuntime.EMPTY_ARRAY;
        }
        return new NativeArray(res);
    }

    public static Object setStack(Object self, Object value) {
        Global.checkObject(self);
        ScriptObject sobj = (ScriptObject)self;
        sobj.set((Object)STACK, value, Global.isStrict());
        return value;
    }

    @Function(attributes=2)
    public static Object toString(Object self) {
        Global.checkObject(self);
        ScriptObject sobj = (ScriptObject)self;
        Object name = sobj.get(NAME);
        name = name == ScriptRuntime.UNDEFINED ? "Error" : JSType.toString(name);
        Object msg = sobj.get(MESSAGE);
        msg = msg == ScriptRuntime.UNDEFINED ? "" : JSType.toString(msg);
        if (((String)name).isEmpty()) {
            return msg;
        }
        if (((String)msg).isEmpty()) {
            return name;
        }
        return (String)name + ": " + (String)msg;
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(MethodHandles.publicLookup(), NativeError.class, name, Lookup.MH.type(rtype, types));
    }
}

