/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.lang.reflect.Array;
import java.util.Collection;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.NativeArray;
import jdk.nashorn.internal.objects.annotations.Function;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.objects.annotations.Where;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.linker.JavaAdapterFactory;
import org.dynalang.dynalink.beans.StaticClass;
import org.dynalang.dynalink.support.TypeUtilities;

@ScriptClass(value="Java")
public class NativeJava {
    private NativeJava() {
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object isType(Object self, Object type) {
        return type instanceof StaticClass;
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object type(Object self, Object objTypeName) throws ClassNotFoundException {
        return NativeJava.type(objTypeName);
    }

    private static StaticClass type(Object objTypeName) throws ClassNotFoundException {
        return StaticClass.forClass(NativeJava.type(JSType.toString(objTypeName)));
    }

    private static Class<?> type(String typeName) throws ClassNotFoundException {
        if (typeName.endsWith("[]")) {
            return NativeJava.arrayType(typeName);
        }
        return NativeJava.simpleType(typeName);
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object toJavaArray(Object self, Object objArray, Object objType) throws ClassNotFoundException {
        StaticClass componentType;
        StaticClass staticClass = objType instanceof StaticClass ? (StaticClass)objType : (componentType = objType == ScriptRuntime.UNDEFINED ? StaticClass.forClass(Object.class) : NativeJava.type(objType));
        if (objArray == null) {
            return null;
        }
        Global.checkObject(objArray);
        return ((ScriptObject)objArray).getArray().asArrayOfType(componentType.getRepresentedClass());
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object toJavaScriptArray(Object self, Object objArray) {
        if (objArray == null) {
            return null;
        }
        if (objArray instanceof Collection) {
            return new NativeArray(((Collection)objArray).toArray());
        }
        if (objArray instanceof Object[]) {
            return new NativeArray((Object[])((Object[])objArray).clone());
        }
        if (objArray instanceof int[]) {
            return new NativeArray((int[])((int[])objArray).clone());
        }
        if (objArray instanceof double[]) {
            return new NativeArray((double[])((double[])objArray).clone());
        }
        if (objArray instanceof long[]) {
            return new NativeArray((long[])((long[])objArray).clone());
        }
        if (objArray instanceof byte[]) {
            return new NativeArray(NativeJava.copyArray((byte[])objArray));
        }
        if (objArray instanceof short[]) {
            return new NativeArray(NativeJava.copyArray((short[])objArray));
        }
        if (objArray instanceof char[]) {
            return new NativeArray(NativeJava.copyArray((char[])objArray));
        }
        if (objArray instanceof float[]) {
            return new NativeArray(NativeJava.copyArray((float[])objArray));
        }
        if (objArray instanceof boolean[]) {
            return new NativeArray(NativeJava.copyArray((boolean[])objArray));
        }
        ECMAErrors.typeError("cant.convert.to.javascript.array", objArray.getClass().getName());
        throw new AssertionError();
    }

    private static int[] copyArray(byte[] in) {
        int[] out = new int[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    private static int[] copyArray(short[] in) {
        int[] out = new int[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    private static int[] copyArray(char[] in) {
        int[] out = new int[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    private static double[] copyArray(float[] in) {
        double[] out = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    private static Object[] copyArray(boolean[] in) {
        Object[] out = new Object[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    private static Class<?> simpleType(String typeName) throws ClassNotFoundException {
        Class<?> primClass = TypeUtilities.getPrimitiveTypeByName((String)typeName);
        return primClass != null ? primClass : Global.getThisContext().findClass(typeName);
    }

    private static Class<?> arrayType(String typeName) throws ClassNotFoundException {
        return Array.newInstance(NativeJava.type(typeName.substring(0, typeName.length() - 2)), 0).getClass();
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object extend(Object self, Object ... types) {
        if (types == null || types.length == 0) {
            ECMAErrors.typeError("extend.expects.at.least.one.argument", new String[0]);
        }
        Class[] stypes = new Class[types.length];
        try {
            for (int i = 0; i < types.length; ++i) {
                stypes[i] = ((StaticClass)types[i]).getRepresentedClass();
            }
        }
        catch (ClassCastException e) {
            ECMAErrors.typeError("extend.expects.java.types", new String[0]);
        }
        return JavaAdapterFactory.getAdapterClassFor(stypes);
    }
}

