/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.TypeDescriptor;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Pattern;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.NativeArray;
import jdk.nashorn.internal.objects.NativeRegExp;
import jdk.nashorn.internal.objects.annotations.Constructor;
import jdk.nashorn.internal.objects.annotations.Function;
import jdk.nashorn.internal.objects.annotations.Getter;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.objects.annotations.SpecializedConstructor;
import jdk.nashorn.internal.objects.annotations.SpecializedFunction;
import jdk.nashorn.internal.objects.annotations.Where;
import jdk.nashorn.internal.parser.Lexer;
import jdk.nashorn.internal.runtime.ConsString;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.arrays.ArrayIndex;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.linker.MethodHandleFactory;
import jdk.nashorn.internal.runtime.linker.NashornGuards;
import jdk.nashorn.internal.runtime.linker.PrimitiveLookup;
import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.linker.GuardedInvocation;
import org.dynalang.dynalink.linker.LinkRequest;

@ScriptClass(value="String")
public final class NativeString
extends ScriptObject {
    private final CharSequence value;
    static final MethodHandle WRAPFILTER = NativeString.findWrapFilter();

    NativeString(CharSequence value) {
        this(value, Global.instance().getStringPrototype());
    }

    private NativeString(CharSequence value, ScriptObject proto) {
        assert (value instanceof String || value instanceof ConsString);
        this.value = value;
        this.setProto(proto);
    }

    @Override
    public String safeToString() {
        return "[String " + this.toString() + "]";
    }

    public String toString() {
        return this.getStringValue();
    }

    public boolean equals(Object other) {
        if (other instanceof NativeString) {
            return this.getStringValue().equals(((NativeString)other).getStringValue());
        }
        return false;
    }

    public int hashCode() {
        return this.getStringValue().hashCode();
    }

    private String getStringValue() {
        return this.value instanceof String ? (String)this.value : this.value.toString();
    }

    private CharSequence getValue() {
        return this.value;
    }

    @Override
    public String getClassName() {
        return "String";
    }

    @Override
    public Object getLength() {
        return this.value.length();
    }

    @Override
    protected GuardedInvocation findGetIndexMethod(CallSiteDescriptor desc, LinkRequest request) {
        Object self = request.getReceiver();
        TypeDescriptor.OfField returnType = desc.getMethodType().returnType();
        if (returnType == Object.class && (self instanceof String || self instanceof ConsString)) {
            try {
                MethodHandle mh = MethodHandles.lookup().findStatic(NativeString.class, "get", desc.getMethodType());
                return new GuardedInvocation(mh, NashornGuards.getInstanceOf2Guard(String.class, ConsString.class));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                // empty catch block
            }
        }
        return super.findGetIndexMethod(desc, request);
    }

    private static Object get(Object self, Object key) {
        CharSequence cs = JSType.toCharSequence(self);
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (index >= 0 && index < cs.length()) {
            return String.valueOf(cs.charAt(index));
        }
        return ((ScriptObject)Global.toObject(self)).get(key);
    }

    private static Object get(Object self, double key) {
        if (JSType.isRepresentableAsInt(key)) {
            return NativeString.get(self, (int)key);
        }
        return ((ScriptObject)Global.toObject(self)).get(key);
    }

    private static Object get(Object self, long key) {
        CharSequence cs = JSType.toCharSequence(self);
        if (key >= 0L && key < (long)cs.length()) {
            return String.valueOf(cs.charAt((int)key));
        }
        return ((ScriptObject)Global.toObject(self)).get(key);
    }

    private static Object get(Object self, int key) {
        CharSequence cs = JSType.toCharSequence(self);
        if (key >= 0 && key < cs.length()) {
            return String.valueOf(cs.charAt(key));
        }
        return ((ScriptObject)Global.toObject(self)).get(key);
    }

    @Override
    public Object get(Object key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (index >= 0 && index < this.value.length()) {
            return String.valueOf(this.value.charAt(index));
        }
        return super.get(key);
    }

    @Override
    public Object get(double key) {
        if (JSType.isRepresentableAsInt(key)) {
            return this.get((int)key);
        }
        return super.get(key);
    }

    @Override
    public Object get(long key) {
        if (key >= 0L && key < (long)this.value.length()) {
            return String.valueOf(this.value.charAt((int)key));
        }
        return super.get(key);
    }

    @Override
    public Object get(int key) {
        if (key >= 0 && key < this.value.length()) {
            return String.valueOf(this.value.charAt(key));
        }
        return super.get(key);
    }

    @Override
    public int getInt(Object key) {
        return JSType.toInt32(this.get(key));
    }

    @Override
    public int getInt(double key) {
        return JSType.toInt32(this.get(key));
    }

    @Override
    public int getInt(long key) {
        return JSType.toInt32(this.get(key));
    }

    @Override
    public int getInt(int key) {
        return JSType.toInt32(this.get(key));
    }

    @Override
    public long getLong(Object key) {
        return JSType.toUint32(this.get(key));
    }

    @Override
    public long getLong(double key) {
        return JSType.toUint32(this.get(key));
    }

    @Override
    public long getLong(long key) {
        return JSType.toUint32(this.get(key));
    }

    @Override
    public long getLong(int key) {
        return JSType.toUint32(this.get(key));
    }

    @Override
    public double getDouble(Object key) {
        return JSType.toNumber(this.get(key));
    }

    @Override
    public double getDouble(double key) {
        return JSType.toNumber(this.get(key));
    }

    @Override
    public double getDouble(long key) {
        return JSType.toNumber(this.get(key));
    }

    @Override
    public double getDouble(int key) {
        return JSType.toNumber(this.get(key));
    }

    @Override
    public boolean has(Object key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        return this.isValid(index) || super.has(key);
    }

    @Override
    public boolean has(int key) {
        return this.isValid(key) || super.has(key);
    }

    @Override
    public boolean has(long key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        return this.isValid(index) || super.has(key);
    }

    @Override
    public boolean has(double key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        return this.isValid(index) || super.has(key);
    }

    @Override
    public boolean hasOwnProperty(Object key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        return this.isValid(index) || super.hasOwnProperty(key);
    }

    @Override
    public boolean hasOwnProperty(int key) {
        return this.isValid(key) || super.hasOwnProperty(key);
    }

    @Override
    public boolean hasOwnProperty(long key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        return this.isValid(index) || super.hasOwnProperty(key);
    }

    @Override
    public boolean hasOwnProperty(double key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        return this.isValid(index) || super.hasOwnProperty(key);
    }

    @Override
    public boolean delete(int key, boolean strict) {
        return this.checkDeleteIndex(key, strict) ? false : super.delete(key, strict);
    }

    @Override
    public boolean delete(long key, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        return this.checkDeleteIndex(index, strict) ? false : super.delete(key, strict);
    }

    @Override
    public boolean delete(double key, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        return this.checkDeleteIndex(index, strict) ? false : super.delete(key, strict);
    }

    @Override
    public boolean delete(Object key, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        return this.checkDeleteIndex(index, strict) ? false : super.delete(key, strict);
    }

    private boolean checkDeleteIndex(int index, boolean strict) {
        if (this.isValid(index)) {
            if (strict) {
                ECMAErrors.typeError("cant.delete.property", Integer.toString(index), ScriptRuntime.safeToString(this));
            }
            return true;
        }
        return false;
    }

    @Override
    public Object getOwnPropertyDescriptor(String key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (index >= 0 && index < this.value.length()) {
            Global global = Global.instance();
            return global.newDataDescriptor(String.valueOf(this.value.charAt(index)), false, true, false);
        }
        return super.getOwnPropertyDescriptor(key);
    }

    @Override
    public String[] getOwnKeys(boolean all) {
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < this.value.length(); ++i) {
            keys.add(JSType.toString(i));
        }
        keys.addAll(Arrays.asList(super.getOwnKeys(all)));
        return keys.toArray(new String[keys.size()]);
    }

    @Getter(attributes=7)
    public static Object length(Object self) {
        return NativeString.getCharSequence(self).length();
    }

    @Function(attributes=2, arity=1, where=Where.CONSTRUCTOR)
    public static Object fromCharCode(Object self, Object ... args) {
        char[] buf = new char[args.length];
        int index = 0;
        for (Object arg : args) {
            buf[index++] = (char)JSType.toUint16(arg);
        }
        return new String(buf);
    }

    @SpecializedFunction
    public static Object fromCharCode(Object self, Object value) {
        try {
            return "" + (char)JSType.toUint16(((Number)value).doubleValue());
        }
        catch (ClassCastException e) {
            return NativeString.fromCharCode(self, new Object[]{value});
        }
    }

    @SpecializedFunction
    public static Object fromCharCode(Object self, int value) {
        return "" + (char)(value & 0xFFFF);
    }

    @SpecializedFunction
    public static Object fromCharCode(Object self, long value) {
        return "" + (char)((int)value & 0xFFFF);
    }

    @SpecializedFunction
    public static Object fromCharCode(Object self, double value) {
        return "" + (char)JSType.toUint16(value);
    }

    @Function(attributes=2)
    public static Object toString(Object self) {
        return NativeString.getString(self);
    }

    @Function(attributes=2)
    public static Object valueOf(Object self) {
        return NativeString.getString(self);
    }

    @Function(attributes=2)
    public static Object charAt(Object self, Object pos) {
        return NativeString.charAt(self, JSType.toInteger(pos));
    }

    @SpecializedFunction
    public static String charAt(Object self, double pos) {
        return NativeString.charAt(self, (int)pos);
    }

    @SpecializedFunction
    public static String charAt(Object self, int pos) {
        String str = NativeString.checkObjectToString(self);
        return pos < 0 || pos >= str.length() ? "" : String.valueOf(str.charAt(pos));
    }

    @Function(attributes=2)
    public static Object charCodeAt(Object self, Object pos) {
        return NativeString.charCodeAt(self, JSType.toInteger(pos));
    }

    @SpecializedFunction
    public static double charCodeAt(Object self, double pos) {
        return NativeString.charCodeAt(self, (int)pos);
    }

    @SpecializedFunction
    public static double charCodeAt(Object self, int pos) {
        String str = NativeString.checkObjectToString(self);
        return pos < 0 || pos >= str.length() ? Double.NaN : (double)str.charAt(pos);
    }

    @Function(attributes=2, arity=1)
    public static Object concat(Object self, Object ... args) {
        CharSequence cs = NativeString.checkObjectToString(self);
        if (args != null) {
            for (Object obj : args) {
                cs = new ConsString(cs, JSType.toCharSequence(obj));
            }
        }
        return cs;
    }

    @Function(attributes=2, arity=1)
    public static Object indexOf(Object self, Object search, Object pos) {
        String str = NativeString.checkObjectToString(self);
        return str.indexOf(JSType.toString(search), JSType.toInteger(pos));
    }

    @SpecializedFunction
    public static int indexOf(Object self, Object search) {
        return NativeString.indexOf(self, search, 0);
    }

    @SpecializedFunction
    public static int indexOf(Object self, Object search, double pos) {
        return NativeString.indexOf(self, search, (int)pos);
    }

    @SpecializedFunction
    public static int indexOf(Object self, Object search, int pos) {
        return NativeString.checkObjectToString(self).indexOf(JSType.toString(search), pos);
    }

    @Function(attributes=2, arity=1)
    public static Object lastIndexOf(Object self, Object search, Object pos) {
        double numPos;
        String str = NativeString.checkObjectToString(self);
        String searchStr = JSType.toString(search);
        int from = pos == ScriptRuntime.UNDEFINED ? str.length() : (!Double.isNaN(numPos = JSType.toNumber(pos)) ? (int)numPos : Integer.MAX_VALUE);
        return str.lastIndexOf(searchStr, from);
    }

    @Function(attributes=2)
    public static Object localeCompare(Object self, Object that) {
        String str = NativeString.checkObjectToString(self);
        Collator collator = Collator.getInstance(Global.getThisContext().getLocale());
        collator.setStrength(3);
        collator.setDecomposition(1);
        return (double)collator.compare(str, JSType.toString(that));
    }

    @Function(attributes=2)
    public static Object match(Object self, Object regexp) {
        Object result;
        String str = NativeString.checkObjectToString(self);
        NativeRegExp nativeRegExp = regexp == ScriptRuntime.UNDEFINED ? new NativeRegExp("") : Global.toRegExp(regexp);
        if (!nativeRegExp.getGlobal()) {
            return nativeRegExp.exec(str);
        }
        nativeRegExp.setLastIndex(0);
        int previousLastIndex = 0;
        ArrayList<Object> matches = new ArrayList<Object>();
        while ((result = nativeRegExp.exec(str)) != null) {
            int thisIndex = nativeRegExp.getLastIndex();
            if (thisIndex == previousLastIndex) {
                nativeRegExp.setLastIndex(thisIndex + 1);
                previousLastIndex = thisIndex + 1;
            } else {
                previousLastIndex = thisIndex;
            }
            matches.add(((ScriptObject)result).get(0));
        }
        if (matches.isEmpty()) {
            return null;
        }
        return new NativeArray(matches.toArray());
    }

    @Function(attributes=2)
    public static Object replace(Object self, Object string, Object replacement) {
        String str = NativeString.checkObjectToString(self);
        NativeRegExp nativeRegExp = string instanceof NativeRegExp ? (NativeRegExp)string : new NativeRegExp(Pattern.compile(JSType.toString(string), 16));
        if (replacement instanceof ScriptFunction) {
            return nativeRegExp.replace(str, "", (ScriptFunction)replacement);
        }
        return nativeRegExp.replace(str, JSType.toString(replacement), null);
    }

    @Function(attributes=2)
    public static Object search(Object self, Object string) {
        String str = NativeString.checkObjectToString(self);
        NativeRegExp nativeRegExp = Global.toRegExp(string == ScriptRuntime.UNDEFINED ? "" : string);
        return nativeRegExp.search(str);
    }

    @Function(attributes=2)
    public static Object slice(Object self, Object start, Object end) {
        String str = NativeString.checkObjectToString(self);
        if (end == ScriptRuntime.UNDEFINED) {
            return NativeString.slice((Object)str, JSType.toInteger(start));
        }
        return NativeString.slice((Object)str, JSType.toInteger(start), JSType.toInteger(end));
    }

    @SpecializedFunction
    public static Object slice(Object self, int start) {
        String str = NativeString.checkObjectToString(self);
        int from = start < 0 ? Math.max(str.length() + start, 0) : Math.min(start, str.length());
        return str.substring(from);
    }

    @SpecializedFunction
    public static Object slice(Object self, double start) {
        return NativeString.slice(self, (int)start);
    }

    @SpecializedFunction
    public static Object slice(Object self, int start, int end) {
        String str = NativeString.checkObjectToString(self);
        int len = str.length();
        int from = start < 0 ? Math.max(len + start, 0) : Math.min(start, len);
        int to = end < 0 ? Math.max(len + end, 0) : Math.min(end, len);
        return str.substring(Math.min(from, to), to);
    }

    @SpecializedFunction
    public static Object slice(Object self, double start, double end) {
        return NativeString.slice(self, (int)start, (int)end);
    }

    @Function(attributes=2)
    public static Object split(Object self, Object separator, Object limit) {
        long lim;
        String str = NativeString.checkObjectToString(self);
        if (separator == ScriptRuntime.UNDEFINED) {
            return new NativeArray(new Object[]{str});
        }
        long l = lim = limit == ScriptRuntime.UNDEFINED ? 0xFFFFFFFFL : JSType.toUint32(limit);
        if (separator instanceof NativeRegExp) {
            return ((NativeRegExp)separator).split(str, lim);
        }
        return NativeString.splitString(str, JSType.toString(separator), lim);
    }

    private static Object splitString(String str, String separator, long limit) {
        int found;
        if (separator.isEmpty()) {
            Object[] array = new Object[str.length()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = String.valueOf(str.charAt(i));
            }
            return new NativeArray(array);
        }
        LinkedList<String> elements = new LinkedList<String>();
        int strLength = str.length();
        int sepLength = separator.length();
        int pos = 0;
        int n = 0;
        while (pos < strLength && (long)n < limit && (found = str.indexOf(separator, pos)) != -1) {
            elements.add(str.substring(pos, found));
            ++n;
            pos = found + sepLength;
        }
        if (pos <= strLength && (long)n < limit) {
            elements.add(str.substring(pos));
        }
        return new NativeArray(elements.toArray());
    }

    @Function(attributes=2)
    public static Object substr(Object self, Object start, Object length) {
        String str = JSType.toString(self);
        int strLength = str.length();
        int intStart = JSType.toInteger(start);
        if (intStart < 0) {
            intStart = Math.max(intStart + strLength, 0);
        }
        int intLen = Math.min(Math.max(length == ScriptRuntime.UNDEFINED ? Integer.MAX_VALUE : JSType.toInteger(length), 0), strLength - intStart);
        return intLen <= 0 ? "" : str.substring(intStart, intStart + intLen);
    }

    @Function(attributes=2)
    public static Object substring(Object self, Object start, Object end) {
        String str = NativeString.checkObjectToString(self);
        if (end == ScriptRuntime.UNDEFINED) {
            return NativeString.substring((Object)str, JSType.toInteger(start));
        }
        return NativeString.substring((Object)str, JSType.toInteger(start), JSType.toInteger(end));
    }

    @SpecializedFunction
    public static String substring(Object self, int start) {
        String str = NativeString.checkObjectToString(self);
        if (start < 0) {
            return str;
        }
        if (start >= str.length()) {
            return "";
        }
        return str.substring(start);
    }

    @SpecializedFunction
    public static String substring(Object self, double start) {
        return NativeString.substring(self, (int)start);
    }

    @SpecializedFunction
    public static String substring(Object self, int start, int end) {
        int validEnd;
        int validStart;
        String str = NativeString.checkObjectToString(self);
        int len = str.length();
        int n = start < 0 ? 0 : (validStart = start > len ? len : start);
        int n2 = end < 0 ? 0 : (validEnd = end > len ? len : end);
        if (validStart < validEnd) {
            return str.substring(validStart, validEnd);
        }
        return str.substring(validEnd, validStart);
    }

    @SpecializedFunction
    public static String substring(Object self, double start, double end) {
        return NativeString.substring(self, (int)start, (int)end);
    }

    @Function(attributes=2)
    public static Object toLowerCase(Object self) {
        return NativeString.checkObjectToString(self).toLowerCase();
    }

    @Function(attributes=2)
    public static Object toLocaleLowerCase(Object self) {
        return NativeString.checkObjectToString(self).toLowerCase(Global.getThisContext().getLocale());
    }

    @Function(attributes=2)
    public static Object toUpperCase(Object self) {
        return NativeString.checkObjectToString(self).toUpperCase();
    }

    @Function(attributes=2)
    public static Object toLocaleUpperCase(Object self) {
        return NativeString.checkObjectToString(self).toUpperCase(Global.getThisContext().getLocale());
    }

    @Function(attributes=2)
    public static Object trim(Object self) {
        int start;
        String str = NativeString.checkObjectToString(self);
        int len = str.length();
        int end = len - 1;
        for (start = 0; start <= end && Lexer.isJSWhitespace(str.charAt(start)); ++start) {
        }
        while (end > start && Lexer.isJSWhitespace(str.charAt(end))) {
            --end;
        }
        return start == 0 && end + 1 == len ? str : str.substring(start, end + 1);
    }

    private static Object newObj(Object self, CharSequence str) {
        if (self instanceof ScriptObject) {
            return new NativeString(str, ((ScriptObject)self).getProto());
        }
        return new NativeString(str, Global.instance().getStringPrototype());
    }

    @Constructor(arity=1)
    public static Object constructor(boolean newObj, Object self, Object ... args) {
        String str = args.length > 0 ? JSType.toCharSequence(args[0]) : "";
        return newObj ? NativeString.newObj(self, str) : str.toString();
    }

    @SpecializedConstructor
    public static Object constructor(boolean newObj, Object self) {
        return newObj ? NativeString.newObj(self, "") : "";
    }

    @SpecializedConstructor
    public static Object constructor(boolean newObj, Object self, Object arg) {
        CharSequence str = JSType.toCharSequence(arg);
        return newObj ? NativeString.newObj(self, str) : str.toString();
    }

    @SpecializedConstructor
    public static Object constructor(boolean newObj, Object self, int arg) {
        String str = JSType.toString(arg);
        return newObj ? NativeString.newObj(self, str) : str;
    }

    public static GuardedInvocation lookupPrimitive(LinkRequest request, Object receiver) {
        MethodHandle guard = NashornGuards.getInstanceOf2Guard(String.class, ConsString.class);
        return PrimitiveLookup.lookupPrimitive(request, guard, (ScriptObject)new NativeString((CharSequence)receiver), WRAPFILTER);
    }

    private static NativeString wrapFilter(Object receiver) {
        return new NativeString((CharSequence)receiver);
    }

    private static CharSequence getCharSequence(Object self) {
        if (self instanceof String || self instanceof ConsString) {
            return (CharSequence)self;
        }
        if (self instanceof NativeString) {
            return ((NativeString)self).getValue();
        }
        if (self != null && self == Global.instance().getStringPrototype()) {
            return "";
        }
        ECMAErrors.typeError("not.a.string", ScriptRuntime.safeToString(self));
        return null;
    }

    private static String getString(Object self) {
        if (self instanceof String) {
            return (String)self;
        }
        if (self instanceof ConsString) {
            return self.toString();
        }
        if (self instanceof NativeString) {
            return ((NativeString)self).getStringValue();
        }
        if (self != null && self == Global.instance().getStringPrototype()) {
            return "";
        }
        ECMAErrors.typeError("not.a.string", ScriptRuntime.safeToString(self));
        return null;
    }

    private static String checkObjectToString(Object self) {
        if (self instanceof String) {
            return (String)self;
        }
        if (self instanceof ConsString) {
            return self.toString();
        }
        Global.checkObjectCoercible(self);
        return JSType.toString(self);
    }

    private boolean isValid(int key) {
        return key >= 0 && key < this.value.length();
    }

    private static MethodHandle findWrapFilter() {
        try {
            return MethodHandles.lookup().findStatic(NativeString.class, "wrapFilter", Lookup.MH.type(NativeString.class, Object.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new MethodHandleFactory.LookupException(e);
        }
    }
}

