/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import jdk.nashorn.internal.objects.ArrayBufferView;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.NativeArrayBuffer;
import jdk.nashorn.internal.objects.annotations.Constructor;
import jdk.nashorn.internal.objects.annotations.Function;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.arrays.ArrayData;

@ScriptClass(value="Uint8Array")
public class NativeUint8Array
extends ArrayBufferView {
    private static final int BYTES_PER_ELEMENT = 1;
    private static final ArrayBufferView.Factory FACTORY = new ArrayBufferView.Factory(1){

        @Override
        public ArrayBufferView construct(NativeArrayBuffer buffer, int byteOffset, int length) {
            return new NativeUint8Array(buffer, byteOffset, length);
        }

        @Override
        public ArrayData createArrayData(NativeArrayBuffer buffer, int byteOffset, int length) {
            return new Uint8ArrayData(buffer, byteOffset, length);
        }
    };

    @Constructor(arity=1)
    public static Object constructor(boolean newObj, Object self, Object ... args) {
        return NativeUint8Array.constructorImpl(args, FACTORY);
    }

    NativeUint8Array(NativeArrayBuffer buffer, int byteOffset, int length) {
        super(buffer, byteOffset, length);
    }

    @Override
    protected ArrayBufferView.Factory factory() {
        return FACTORY;
    }

    @Function(attributes=2)
    protected static Object set(Object self, Object array, Object offset) {
        return ArrayBufferView.setImpl(self, array, offset);
    }

    @Function(attributes=2)
    protected static Object subarray(Object self, Object begin, Object end) {
        return ArrayBufferView.subarrayImpl(self, begin, end);
    }

    @Override
    protected ScriptObject getPrototype() {
        return Global.instance().getUint8ArrayPrototype();
    }

    private static final class Uint8ArrayData
    extends ArrayBufferView.ArrayDataImpl {
        private Uint8ArrayData(NativeArrayBuffer buffer, int byteOffset, int elementLength) {
            super(buffer, byteOffset, elementLength);
        }

        @Override
        protected int byteIndex(int index) {
            return index * 1 + this.byteOffset;
        }

        @Override
        protected int getIntImpl(int index) {
            return this.buffer.getByteArray()[this.byteIndex(index)] & 0xFF;
        }

        @Override
        protected void setImpl(int index, int value) {
            this.buffer.getByteArray()[this.byteIndex((int)index)] = (byte)value;
        }
    }
}

