/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.runtime.ConsString;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.GlobalObject;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunctionData;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.linker.MethodHandleFactory;
import jdk.nashorn.internal.runtime.linker.NashornCallSiteDescriptor;
import jdk.nashorn.internal.runtime.linker.NashornGuards;
import jdk.nashorn.internal.runtime.options.Options;
import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.linker.GuardedInvocation;
import org.dynalang.dynalink.linker.LinkRequest;

public abstract class ScriptFunction
extends ScriptObject {
    public static final MethodHandle G$PROTOTYPE = ScriptFunction.findOwnMH("G$prototype", Object.class, Object.class);
    public static final MethodHandle S$PROTOTYPE = ScriptFunction.findOwnMH("S$prototype", Void.TYPE, Object.class, Object.class);
    public static final MethodHandle G$LENGTH = ScriptFunction.findOwnMH("G$length", Integer.TYPE, Object.class);
    public static final MethodHandle G$NAME = ScriptFunction.findOwnMH("G$name", Object.class, Object.class);
    public static final MethodHandle ALLOCATE = ScriptFunction.findOwnMH("allocate", Object.class, new Class[0]);
    private static final MethodHandle NEWFILTER = ScriptFunction.findOwnMH("newFilter", Object.class, Object.class, Object.class);
    private static final MethodHandle WRAPFILTER = ScriptFunction.findOwnMH("wrapFilter", Object.class, Object.class);
    public static final CompilerConstants.Call GET_SCOPE = CompilerConstants.virtualCallNoLookup(ScriptFunction.class, "getScope", ScriptObject.class, new Class[0]);
    private static final boolean DISABLE_SPECIALIZATION = Options.getBooleanProperty("nashorn.scriptfunction.specialization.disable");
    private final ScriptFunctionData data;
    protected Object prototype;
    private final ScriptObject scope;
    private static int constructorCount;
    private static int invokes;
    private static int allocations;

    protected ScriptFunction(String name, MethodHandle methodHandle, PropertyMap map, ScriptObject scope, MethodHandle[] specs, boolean strict, boolean builtin) {
        this(new ScriptFunctionData(name, methodHandle, specs, strict, builtin), map, scope);
    }

    protected ScriptFunction(ScriptFunctionData data, PropertyMap map, ScriptObject scope) {
        super(map);
        if (Context.DEBUG) {
            ++constructorCount;
        }
        this.data = data;
        this.scope = scope;
    }

    @Override
    public String getClassName() {
        return "Function";
    }

    @Override
    public boolean isInstance(ScriptObject instance) {
        if (!(this.prototype instanceof ScriptObject)) {
            ECMAErrors.typeError("prototype.not.an.object", ScriptRuntime.safeToString(this), ScriptRuntime.safeToString(this.prototype));
        }
        for (ScriptObject proto = instance.getProto(); proto != null; proto = proto.getProto()) {
            if (proto != this.prototype) continue;
            return true;
        }
        return false;
    }

    public final int getArity() {
        return this.data.getArity();
    }

    public final void setArity(int arity) {
        this.data.setArity(arity);
    }

    public boolean isStrict() {
        return this.data.isStrict();
    }

    public boolean isBuiltin() {
        return this.data.isBuiltin();
    }

    public boolean needsWrappedThis() {
        return this.data.needsWrappedThis();
    }

    public Object invoke(Object self, Object ... arguments) throws Throwable {
        Object[] args;
        if (Context.DEBUG) {
            ++invokes;
        }
        MethodHandle invoker = this.data.getGenericInvoker();
        Object selfObj = this.convertThisObject(self);
        Object[] objectArray = args = arguments == null ? ScriptRuntime.EMPTY_ARRAY : arguments;
        if (this.data.isVarArg()) {
            if (this.data.needsCallee()) {
                return invoker.invokeExact(selfObj, this, args);
            }
            return invoker.invokeExact(selfObj, args);
        }
        int paramCount = invoker.type().parameterCount();
        if (this.data.needsCallee()) {
            switch (paramCount) {
                case 2: {
                    return invoker.invokeExact(selfObj, this);
                }
                case 3: {
                    return invoker.invokeExact(selfObj, this, ScriptFunction.getArg(args, 0));
                }
                case 4: {
                    return invoker.invokeExact(selfObj, this, ScriptFunction.getArg(args, 0), ScriptFunction.getArg(args, 1));
                }
                case 5: {
                    return invoker.invokeExact(selfObj, this, ScriptFunction.getArg(args, 0), ScriptFunction.getArg(args, 1), ScriptFunction.getArg(args, 2));
                }
            }
            return invoker.invokeWithArguments(ScriptFunction.withArguments(selfObj, this, paramCount, args));
        }
        switch (paramCount) {
            case 1: {
                return invoker.invokeExact(selfObj);
            }
            case 2: {
                return invoker.invokeExact(selfObj, ScriptFunction.getArg(args, 0));
            }
            case 3: {
                return invoker.invokeExact(selfObj, ScriptFunction.getArg(args, 0), ScriptFunction.getArg(args, 1));
            }
            case 4: {
                return invoker.invokeExact(selfObj, ScriptFunction.getArg(args, 0), ScriptFunction.getArg(args, 1), ScriptFunction.getArg(args, 2));
            }
        }
        return invoker.invokeWithArguments(ScriptFunction.withArguments(selfObj, null, paramCount, args));
    }

    private static Object getArg(Object[] args, int i) {
        return i < args.length ? args[i] : ScriptRuntime.UNDEFINED;
    }

    public Object construct(Object self, Object ... args) throws Throwable {
        if (this.data.getConstructor() == null) {
            ECMAErrors.typeError("not.a.constructor", ScriptRuntime.safeToString(this));
        }
        MethodHandle constructor = this.data.getGenericConstructor();
        if (this.data.isVarArg()) {
            if (this.data.needsCallee()) {
                return constructor.invokeExact(self, this, args);
            }
            return constructor.invokeExact(self, args);
        }
        int paramCount = constructor.type().parameterCount();
        if (this.data.needsCallee()) {
            switch (paramCount) {
                case 2: {
                    return constructor.invokeExact(self, this);
                }
                case 3: {
                    return constructor.invokeExact(self, this, ScriptFunction.getArg(args, 0));
                }
                case 4: {
                    return constructor.invokeExact(self, this, ScriptFunction.getArg(args, 0), ScriptFunction.getArg(args, 1));
                }
                case 5: {
                    return constructor.invokeExact(self, this, ScriptFunction.getArg(args, 0), ScriptFunction.getArg(args, 1), ScriptFunction.getArg(args, 2));
                }
            }
            return constructor.invokeWithArguments(ScriptFunction.withArguments(self, this, args));
        }
        switch (paramCount) {
            case 1: {
                return constructor.invokeExact(self);
            }
            case 2: {
                return constructor.invokeExact(self, ScriptFunction.getArg(args, 0));
            }
            case 3: {
                return constructor.invokeExact(self, ScriptFunction.getArg(args, 0), ScriptFunction.getArg(args, 1));
            }
            case 4: {
                return constructor.invokeExact(self, ScriptFunction.getArg(args, 0), ScriptFunction.getArg(args, 1), ScriptFunction.getArg(args, 2));
            }
        }
        return constructor.invokeWithArguments(ScriptFunction.withArguments(self, null, args));
    }

    private static Object[] withArguments(Object self, ScriptFunction function, Object ... args) {
        return ScriptFunction.withArguments(self, function, args.length + (function == null ? 1 : 2), args);
    }

    private static Object[] withArguments(Object self, ScriptFunction function, int paramCount, Object ... args) {
        Object[] finalArgs = new Object[paramCount];
        finalArgs[0] = self;
        int nextArg = 1;
        if (function != null) {
            finalArgs[nextArg++] = function;
        }
        int maxArgs = Math.min(args.length, paramCount - (function == null ? 1 : 2));
        int i = 0;
        while (i < maxArgs) {
            finalArgs[nextArg++] = args[i++];
        }
        while (nextArg < paramCount) {
            finalArgs[nextArg++] = ScriptRuntime.UNDEFINED;
        }
        return finalArgs;
    }

    public Object allocate() {
        if (Context.DEBUG) {
            ++allocations;
        }
        if (this.getConstructHandle() == null) {
            ECMAErrors.typeError("not.a.constructor", ScriptRuntime.safeToString(this));
        }
        ScriptObject object = null;
        if (this.data.getAllocator() != null) {
            try {
                object = this.data.getAllocator().invokeExact(this.data.getAllocatorMap());
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        if (object != null) {
            if (this.prototype instanceof ScriptObject) {
                object.setProto((ScriptObject)this.prototype);
            }
            if (object.getProto() == null) {
                object.setProto(this.getObjectPrototype());
            }
        }
        return object;
    }

    protected abstract ScriptObject getObjectPrototype();

    public abstract ScriptFunction makeBoundFunction(Object var1, Object[] var2);

    @Override
    public final String safeToString() {
        return this.toSource();
    }

    public String toString() {
        return this.data.toString();
    }

    public final String toSource() {
        return this.data.toSource();
    }

    public final Object getPrototype() {
        return this.prototype;
    }

    public final Object setPrototype(Object prototype) {
        this.prototype = prototype;
        return prototype;
    }

    private static int weigh(MethodType t) {
        int weight = Type.typeFor(t.returnType()).getWeight();
        for (Class<?> paramType : t.parameterArray()) {
            int pweight = Type.typeFor(paramType).getWeight();
            weight += pweight;
        }
        return weight;
    }

    private static boolean typeCompatible(MethodType desc, MethodType spec) {
        Class<?>[] sparray;
        Class<?>[] dparray = desc.parameterArray();
        if (dparray.length != (sparray = spec.parameterArray()).length) {
            return false;
        }
        for (int i = 0; i < dparray.length; ++i) {
            Type dp = Type.typeFor(dparray[i]);
            Type sp = Type.typeFor(sparray[i]);
            if (dp.isBoolean()) {
                return false;
            }
            if (Type.widest(dp, sp) == sp) continue;
            return false;
        }
        return true;
    }

    private MethodHandle candidateWithLowestWeight(MethodType descType, MethodHandle initialCandidate, MethodHandle[] specs) {
        if (DISABLE_SPECIALIZATION || specs == null) {
            return initialCandidate;
        }
        int minimumWeight = Integer.MAX_VALUE;
        MethodHandle candidate = initialCandidate;
        for (MethodHandle spec : specs) {
            int specWeight;
            MethodType specType = spec.type();
            if (!ScriptFunction.typeCompatible(descType, specType) || (specWeight = ScriptFunction.weigh(specType)) >= minimumWeight) continue;
            candidate = spec;
            minimumWeight = specWeight;
        }
        if (DISABLE_SPECIALIZATION && candidate != initialCandidate) {
            Context.err("### Specializing builtin " + this.getName() + " -> " + candidate + "?");
        }
        return candidate;
    }

    public final MethodHandle getBestSpecializedInvokeHandle(MethodType type) {
        return this.candidateWithLowestWeight(type, this.getInvokeHandle(), this.data.getInvokeSpecializations());
    }

    public final MethodHandle getInvokeHandle() {
        return this.data.getInvoker();
    }

    public final MethodHandle getBoundInvokeHandle(ScriptObject self) {
        MethodHandle bound = Lookup.MH.bindTo(this.getInvokeHandle(), self);
        return this.data.needsCallee() ? Lookup.MH.bindTo(bound, this) : bound;
    }

    public final MethodHandle getConstructHandle(MethodType type) {
        return this.candidateWithLowestWeight(type, this.getConstructHandle(), this.data.getConstructSpecializations());
    }

    public final MethodHandle getConstructHandle() {
        return this.data.getConstructor();
    }

    public final void setConstructHandle(MethodHandle constructHandle) {
        this.data.setConstructor(constructHandle);
    }

    public final String getName() {
        return this.data.getName();
    }

    public final boolean needsCompilation() {
        return this.data.getInvoker() == null;
    }

    public final long getToken() {
        return this.data.getToken();
    }

    public final ScriptObject getScope() {
        return this.scope;
    }

    public static Object G$prototype(Object self) {
        return self instanceof ScriptFunction ? ((ScriptFunction)self).getPrototype() : ScriptRuntime.UNDEFINED;
    }

    public static void S$prototype(Object self, Object prototype) {
        if (self instanceof ScriptFunction) {
            ((ScriptFunction)self).setPrototype(prototype);
        }
    }

    public static int G$length(Object self) {
        if (self instanceof ScriptFunction) {
            return ((ScriptFunction)self).getArity();
        }
        return 0;
    }

    public static Object G$name(Object self) {
        if (self instanceof ScriptFunction) {
            return ((ScriptFunction)self).getName();
        }
        return ScriptRuntime.UNDEFINED;
    }

    public static ScriptObject getPrototype(Object constructor) {
        Object proto;
        if (constructor instanceof ScriptFunction && (proto = ((ScriptFunction)constructor).getPrototype()) instanceof ScriptObject) {
            return (ScriptObject)proto;
        }
        return null;
    }

    public static int getConstructorCount() {
        return constructorCount;
    }

    public static int getInvokes() {
        return invokes;
    }

    public static int getAllocations() {
        return allocations;
    }

    @Override
    protected GuardedInvocation findNewMethod(CallSiteDescriptor desc) {
        MethodType type = desc.getMethodType();
        MethodHandle constructor = this.getConstructHandle(type);
        if (constructor == null) {
            ECMAErrors.typeError("not.a.constructor", ScriptRuntime.safeToString(this));
            return null;
        }
        MethodType ctorType = constructor.type();
        constructor = Lookup.MH.asType(constructor, constructor.type().changeReturnType(Object.class));
        Class<?>[] ctorArgs = ctorType.dropParameterTypes(0, 1).parameterArray();
        MethodHandle handle = Lookup.MH.foldArguments(Lookup.MH.dropArguments(NEWFILTER, 2, ctorArgs), constructor);
        handle = this.data.needsCallee() ? Lookup.MH.foldArguments(handle, ALLOCATE) : Lookup.MH.filterArguments(handle, 0, ALLOCATE);
        MethodHandle filterIn = Lookup.MH.asType(ScriptFunction.pairArguments(handle, type), type);
        return new GuardedInvocation(filterIn, null, NashornGuards.getFunctionGuard(this));
    }

    private static Object newFilter(Object result, Object allocation) {
        return result instanceof ScriptObject || !JSType.isPrimitive(result) ? result : allocation;
    }

    private static Object wrapFilter(Object obj) {
        if (obj instanceof ScriptObject || !ScriptFunction.isPrimitiveThis(obj)) {
            return obj;
        }
        return ((GlobalObject)((Object)Context.getGlobalTrusted())).wrapAsObject(obj);
    }

    @Override
    protected GuardedInvocation findCallMethod(CallSiteDescriptor desc, LinkRequest request) {
        MethodHandle boundHandle;
        MethodType type = desc.getMethodType();
        if (request.isCallSiteUnstable()) {
            MethodHandle collector = Lookup.MH.asCollector(ScriptRuntime.APPLY.methodHandle(), Object[].class, type.parameterCount() - 2);
            return new GuardedInvocation(collector, desc.getMethodType().parameterType(0) == ScriptFunction.class ? null : NashornGuards.getScriptFunctionGuard());
        }
        MethodHandle guard = null;
        if (this.data.needsCallee()) {
            MethodHandle callHandle = this.getBestSpecializedInvokeHandle(type);
            if (NashornCallSiteDescriptor.isScope(desc)) {
                boundHandle = Lookup.MH.bindTo(callHandle, this.needsWrappedThis() ? Context.getGlobalTrusted() : ScriptRuntime.UNDEFINED);
                boundHandle = Lookup.MH.dropArguments(boundHandle, 1, Object.class);
            } else {
                MethodType oldType = callHandle.type();
                int[] reorder = new int[oldType.parameterCount()];
                for (int i = 2; i < reorder.length; ++i) {
                    reorder[i] = i;
                }
                reorder[0] = 1;
                assert (reorder[1] == 0);
                MethodType newType = oldType.changeParameterType(0, (Class<?>)oldType.parameterType(1)).changeParameterType(1, (Class<?>)oldType.parameterType(0));
                boundHandle = MethodHandles.permuteArguments(callHandle, newType, reorder);
                if (this.needsWrappedThis()) {
                    if (ScriptFunction.isPrimitiveThis(request.getArguments()[1])) {
                        boundHandle = Lookup.MH.filterArguments(boundHandle, 1, WRAPFILTER);
                    } else {
                        guard = NashornGuards.getNonStrictFunctionGuard(this);
                    }
                }
            }
        } else {
            MethodHandle callHandle = this.getBestSpecializedInvokeHandle(type.dropParameterTypes(0, 1));
            if (NashornCallSiteDescriptor.isScope(desc)) {
                boundHandle = Lookup.MH.bindTo(callHandle, this.needsWrappedThis() ? Context.getGlobalTrusted() : ScriptRuntime.UNDEFINED);
                boundHandle = Lookup.MH.dropArguments(boundHandle, 0, Object.class, Object.class);
            } else {
                boundHandle = Lookup.MH.dropArguments(callHandle, 0, Object.class);
            }
        }
        boundHandle = ScriptFunction.pairArguments(boundHandle, type);
        return new GuardedInvocation(boundHandle, guard == null ? NashornGuards.getFunctionGuard(this) : guard);
    }

    MethodHandle getCallMethodHandle(MethodType type, String bindName) {
        MethodHandle methodHandle = this.getBestSpecializedInvokeHandle(type);
        if (bindName != null) {
            methodHandle = this.data.needsCallee() ? Lookup.MH.insertArguments(methodHandle, 1, this, bindName) : Lookup.MH.insertArguments(methodHandle, 1, bindName);
        } else if (this.data.needsCallee()) {
            methodHandle = Lookup.MH.insertArguments(methodHandle, 1, this);
        }
        return ScriptFunction.pairArguments(methodHandle, type);
    }

    protected Object convertThisObject(Object thiz) {
        if (!(thiz instanceof ScriptObject) && this.needsWrappedThis()) {
            if (JSType.nullOrUndefined(thiz)) {
                return Context.getGlobalTrusted();
            }
            if (ScriptFunction.isPrimitiveThis(thiz)) {
                return ((GlobalObject)((Object)Context.getGlobalTrusted())).wrapAsObject(thiz);
            }
        }
        return thiz;
    }

    private static boolean isPrimitiveThis(Object obj) {
        return obj instanceof String || obj instanceof ConsString || obj instanceof Number || obj instanceof Boolean;
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        Class<ScriptFunction> own = ScriptFunction.class;
        MethodType mt = Lookup.MH.type(rtype, types);
        try {
            return Lookup.MH.findStatic(MethodHandles.lookup(), own, name, mt);
        }
        catch (MethodHandleFactory.LookupException e) {
            return Lookup.MH.findVirtual(MethodHandles.lookup(), own, name, mt);
        }
    }
}

