/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.lang.invoke.MethodType;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.support.AbstractCallSiteDescriptor;
import org.dynalang.dynalink.support.CallSiteDescriptorFactory;

public class NashornCallSiteDescriptor
extends AbstractCallSiteDescriptor {
    public static final int CALLSITE_SCOPE = 1;
    public static final int CALLSITE_STRICT = 2;
    public static final int CALLSITE_FUNCTION_DECLARATION = 4;
    public static final int CALLSITE_FAST_SCOPE = 1024;
    public static final int CALLSITE_PROFILE = 16;
    public static final int CALLSITE_TRACE = 32;
    public static final int CALLSITE_TRACE_MISSES = 64;
    public static final int CALLSITE_TRACE_ENTEREXIT = 128;
    public static final int CALLSITE_TRACE_VALUES = 256;
    public static final int CALLSITE_TRACE_SCOPE = 512;
    private static final WeakHashMap<NashornCallSiteDescriptor, WeakReference<NashornCallSiteDescriptor>> canonicals = new WeakHashMap();
    private final String operator;
    private final String operand;
    private final MethodType methodType;
    private final int flags;

    public static NashornCallSiteDescriptor get(String name, MethodType methodType, int flags) {
        String[] tokenizedName = CallSiteDescriptorFactory.tokenizeName((String)name);
        assert (tokenizedName.length == 2 || tokenizedName.length == 3);
        assert ("dyn".equals(tokenizedName[0]));
        assert (tokenizedName[1] != null);
        return NashornCallSiteDescriptor.get(tokenizedName[1], tokenizedName.length == 3 ? tokenizedName[2].intern() : null, methodType, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NashornCallSiteDescriptor get(String operator, String operand, MethodType methodType, int flags) {
        NashornCallSiteDescriptor csd = new NashornCallSiteDescriptor(operator, operand, methodType, flags);
        WeakHashMap<NashornCallSiteDescriptor, WeakReference<NashornCallSiteDescriptor>> weakHashMap = canonicals;
        synchronized (weakHashMap) {
            NashornCallSiteDescriptor canonical;
            WeakReference<NashornCallSiteDescriptor> ref = canonicals.get((Object)csd);
            if (ref != null && (canonical = (NashornCallSiteDescriptor)((Object)ref.get())) != null) {
                return canonical;
            }
            canonicals.put(csd, new WeakReference<NashornCallSiteDescriptor>(csd));
        }
        return csd;
    }

    private NashornCallSiteDescriptor(String operator, String operand, MethodType methodType, int flags) {
        this.operator = operator;
        this.operand = operand;
        this.methodType = methodType;
        this.flags = flags;
    }

    public int getNameTokenCount() {
        return this.operand == null ? 2 : 3;
    }

    public String getNameToken(int i) {
        switch (i) {
            case 0: {
                return "dyn";
            }
            case 1: {
                return this.operator;
            }
            case 2: {
                if (this.operand == null) break;
                return this.operand;
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(i));
    }

    public boolean equals(CallSiteDescriptor csd) {
        return super.equals(csd) && this.flags == NashornCallSiteDescriptor.getFlags(csd);
    }

    public MethodType getMethodType() {
        return this.methodType;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getFirstOperator() {
        int delim = this.operator.indexOf("|");
        return delim == -1 ? this.operator : this.operator.substring(0, delim);
    }

    public String getOperand() {
        return this.operand;
    }

    private static int getFlags(CallSiteDescriptor desc) {
        return desc instanceof NashornCallSiteDescriptor ? ((NashornCallSiteDescriptor)desc).flags : 0;
    }

    private boolean isFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    private static boolean isFlag(CallSiteDescriptor desc, int flag) {
        return (NashornCallSiteDescriptor.getFlags(desc) & flag) != 0;
    }

    public static boolean isScope(CallSiteDescriptor desc) {
        return NashornCallSiteDescriptor.isFlag(desc, 1);
    }

    public static boolean isFastScope(CallSiteDescriptor desc) {
        return NashornCallSiteDescriptor.isFlag(desc, 1024);
    }

    public static boolean isStrict(CallSiteDescriptor desc) {
        return NashornCallSiteDescriptor.isFlag(desc, 2);
    }

    boolean isProfile() {
        return this.isFlag(16);
    }

    boolean isTrace() {
        return this.isFlag(32);
    }

    boolean isTraceMisses() {
        return this.isFlag(64);
    }

    boolean isTraceEnterExit() {
        return this.isFlag(128);
    }

    boolean isTraceObjects() {
        return this.isFlag(256);
    }

    boolean isTraceScope() {
        return this.isFlag(512);
    }

    public CallSiteDescriptor changeMethodType(MethodType newMethodType) {
        return NashornCallSiteDescriptor.get(this.operator, this.operand, newMethodType, this.flags);
    }
}

