/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.completion.cplusplus.CsmFinderImpl;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmFinder;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.filesystems.FileObject;

public final class CsmFinderFactory {
    private static CsmFinderFactory DEFAULT;
    private Map<FileObject, Reference<CsmFinder>> cache = new HashMap<FileObject, Reference<CsmFinder>>();
    private SoftReference<CsmFinder> globalFinder;
    private final Object CACHE_LOCK = new Object();

    private CsmFinderFactory() {
    }

    public static synchronized CsmFinderFactory getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new CsmFinderFactory();
        }
        return DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCache() {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            this.cache = new HashMap<FileObject, Reference<CsmFinder>>();
            this.invalidateGlobalFinderCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CsmFinder getFinder(FileObject fo) {
        FileObject owner = null;
        FileObject cacheKey = owner != null ? owner : fo;
        CsmFinder finder = this.retrieveFromCache(cacheKey);
        if (finder != null) {
            return finder;
        }
        CsmFile cf = CsmUtilities.getCsmFile((FileObject)fo, (boolean)true, (boolean)false);
        ArrayList<CsmFinder> finders = new ArrayList<CsmFinder>();
        if (cf != null) {
            finder = new CsmFinderImpl(cf, this.getMimeType());
            return finder;
        }
        finders.add(this.getGlobalFinder());
        finder = this.getGlobalFinder();
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            this.cache.put(cacheKey, new SoftReference<CsmFinder>(finder));
        }
        return finder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CsmFinder getGlobalFinder() {
        CsmFinder finder;
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            finder = this.globalFinder != null ? this.globalFinder.get() : null;
        }
        if (finder != null) {
            return finder;
        }
        finder = new CsmFinderImpl((FileObject)null, this.getMimeType());
        object = this.CACHE_LOCK;
        synchronized (object) {
            this.globalFinder = new SoftReference<CsmFinder>(finder);
        }
        return finder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateGlobalFinderCache() {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            this.globalFinder = null;
        }
    }

    private String getMimeType() {
        return "text/x-cnd+sourcefile";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsmFinder retrieveFromCache(FileObject fo) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            SoftReference ref = (SoftReference)this.cache.get(fo);
            return ref != null ? (CsmFinder)ref.get() : null;
        }
    }
}

