/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.syntaxerr;

import org.netbeans.modules.cnd.api.model.syntaxerr.AuditPreferences;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAudit;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;

public abstract class AbstractCodeAudit
implements CodeAudit {
    private final String id;
    private final String name;
    private final String description;
    private final String defaultSeverity;
    private final boolean defaultEnabled;
    private final AuditPreferences myPreferences;

    protected AbstractCodeAudit(String id, String name, String description, String defaultSeverity, boolean defaultEnabled, AuditPreferences myPreferences) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.defaultSeverity = defaultSeverity;
        this.defaultEnabled = defaultEnabled;
        this.myPreferences = myPreferences;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public final boolean isEnabled() {
        String defValue = this.getDefaultEnabled() ? "true" : "false";
        return !"false".equals(this.getPreferences().get(this.getID(), "enabled", defValue));
    }

    @Override
    public boolean getDefaultEnabled() {
        return this.defaultEnabled;
    }

    @Override
    public final String minimalSeverity() {
        String defValue = this.getDefaultSeverity();
        return this.getPreferences().get(this.getID(), "severity", defValue);
    }

    @Override
    public String getDefaultSeverity() {
        return this.defaultSeverity;
    }

    @Override
    public String getKind() {
        return "inspection";
    }

    public static CsmErrorInfo.Severity toSeverity(String severity) {
        if ("error".equals(severity)) {
            return CsmErrorInfo.Severity.ERROR;
        }
        if ("warning".equals(severity)) {
            return CsmErrorInfo.Severity.WARNING;
        }
        return CsmErrorInfo.Severity.HINT;
    }

    @Override
    public AuditPreferences getPreferences() {
        return this.myPreferences;
    }

    public abstract boolean isSupportedEvent(CsmErrorProvider.EditorEvent var1);

    public abstract void doGetErrors(CsmErrorProvider.Request var1, CsmErrorProvider.Response var2);
}

