/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.openide.util.BaseUtilities;
import org.openide.util.Mutex;
import org.openide.util.TopologicalSortException;
import org.openide.util.Union2;
import org.openide.util.WeakListeners;

final class SequentialPropertyEvaluator
implements PropertyEvaluator,
ChangeListener {
    private final PropertyProvider preprovider;
    private final PropertyProvider[] providers;
    private Map<String, String> predefs;
    private List<Map<String, String>> orderedDefs;
    private Map<String, String> defs;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final float COMPACT_LOAD_FACTOR = 0.95f;

    public SequentialPropertyEvaluator(final PropertyProvider preprovider, final PropertyProvider ... providers) {
        this.preprovider = preprovider;
        this.providers = providers;
        ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                if (preprovider != null) {
                    SequentialPropertyEvaluator.this.predefs = SequentialPropertyEvaluator.copyAndCompact(preprovider.getProperties());
                    preprovider.addChangeListener(WeakListeners.change((ChangeListener)SequentialPropertyEvaluator.this, (Object)preprovider));
                } else {
                    SequentialPropertyEvaluator.this.predefs = Collections.emptyMap();
                }
                SequentialPropertyEvaluator.this.orderedDefs = new ArrayList(providers.length);
                for (PropertyProvider pp : providers) {
                    SequentialPropertyEvaluator.this.orderedDefs.add(SequentialPropertyEvaluator.copyAndCompact(pp.getProperties()));
                    pp.addChangeListener(WeakListeners.change((ChangeListener)SequentialPropertyEvaluator.this, (Object)pp));
                }
                return null;
            }
        });
        this.defs = SequentialPropertyEvaluator.evaluateAll(this.predefs, this.orderedDefs);
    }

    @Override
    public String getProperty(final String prop) {
        return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                if (SequentialPropertyEvaluator.this.defs == null) {
                    return null;
                }
                return (String)SequentialPropertyEvaluator.this.defs.get(prop);
            }
        });
    }

    @Override
    public String evaluate(final String text) {
        if (text == null) {
            throw new NullPointerException("Attempted to pass null to PropertyEvaluator.evaluate");
        }
        return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                if (SequentialPropertyEvaluator.this.defs == null) {
                    return null;
                }
                Union2 result = SequentialPropertyEvaluator.substitute(text, SequentialPropertyEvaluator.this.defs, Collections.emptySet());
                assert (result.hasFirst()) : "Unexpected result " + result + " from " + text + " on " + SequentialPropertyEvaluator.access$300(SequentialPropertyEvaluator.this);
                return (String)result.first();
            }
        });
    }

    @Override
    public Map<String, String> getProperties() {
        return (Map)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Map<String, String>>(){

            public Map<String, String> run() {
                return SequentialPropertyEvaluator.this.defs;
            }
        });
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Map<String, String> _newdefs;
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        PropertyProvider pp = (PropertyProvider)e.getSource();
        Map<String, String> nue = SequentialPropertyEvaluator.copyAndCompact(pp.getProperties());
        if (pp == this.preprovider) {
            if (this.predefs.equals(nue)) {
                return;
            }
            this.predefs = nue;
        } else {
            int i = Arrays.asList(this.providers).indexOf(pp);
            if (i == -1) {
                assert (false) : "got change from unexpected source: " + pp;
                return;
            }
            if (this.orderedDefs.get(i).equals(nue)) {
                return;
            }
            this.orderedDefs.set(i, nue);
        }
        Map<String, String> newdefs = SequentialPropertyEvaluator.evaluateAll(this.predefs, this.orderedDefs);
        Map<Object, Object> _defs = this.defs != null ? this.defs : Collections.emptyMap();
        Map<String, String> map = _newdefs = newdefs != null ? newdefs : Collections.emptyMap();
        if (!_defs.equals(_newdefs)) {
            HashSet<Object> props = new HashSet<Object>(_defs.keySet());
            props.addAll(_newdefs.keySet());
            LinkedList<PropertyChangeEvent> events = new LinkedList<PropertyChangeEvent>();
            for (String string : props) {
                assert (string != null);
                String oldval = (String)_defs.get(string);
                String newval = _newdefs.get(string);
                if (newval != null) {
                    if (newval.equals(oldval)) {
                        continue;
                    }
                } else assert (oldval != null) : "should not have had " + string;
                events.add(new PropertyChangeEvent(this, string, oldval, newval));
            }
            assert (!events.isEmpty());
            this.defs = newdefs;
            for (PropertyChangeEvent propertyChangeEvent : events) {
                this.pcs.firePropertyChange(propertyChangeEvent);
            }
        }
    }

    private static Union2<String, Set<String>> substitute(String rawval, Map<String, String> predefs, Set<String> siblingProperties) {
        assert (rawval != null) : "null rawval passed in";
        if (rawval.indexOf(36) == -1) {
            return Union2.createFirst((Object)rawval);
        }
        int idx = 0;
        StringBuilder val = new StringBuilder();
        HashSet<String> needed = new HashSet<String>();
        while (true) {
            int shell;
            if ((shell = rawval.indexOf(36, idx)) == -1 || shell == rawval.length() - 1) {
                if (needed.isEmpty()) {
                    val.append(rawval.substring(idx));
                    return Union2.createFirst((Object)val.toString());
                }
                return Union2.createSecond(needed);
            }
            char c = rawval.charAt(shell + 1);
            if (c == '$') {
                if (needed.isEmpty()) {
                    val.append('$');
                }
                idx += 2;
                continue;
            }
            if (c == '{') {
                int end = rawval.indexOf(125, shell + 2);
                if (end != -1) {
                    String otherprop = rawval.substring(shell + 2, end);
                    if (predefs.containsKey(otherprop)) {
                        if (needed.isEmpty()) {
                            val.append(rawval.substring(idx, shell));
                            val.append(predefs.get(otherprop));
                        }
                        idx = end + 1;
                        continue;
                    }
                    if (siblingProperties.contains(otherprop)) {
                        needed.add(otherprop);
                        idx = end + 1;
                        continue;
                    }
                    if (needed.isEmpty()) {
                        val.append(rawval.substring(idx, end + 1));
                    }
                    idx = end + 1;
                    continue;
                }
                if (needed.isEmpty()) {
                    val.append(rawval.substring(idx));
                    return Union2.createFirst((Object)val.toString());
                }
                return Union2.createSecond(needed);
            }
            if (needed.isEmpty()) {
                val.append(rawval.substring(idx, idx + 2));
            }
            idx += 2;
        }
    }

    private static Map<String, String> evaluateAll(Map<String, String> predefs, List<Map<String, String>> defs) {
        HashMap<String, String> m = new HashMap<String, String>(predefs);
        for (Map<String, String> curr : defs) {
            List sorted;
            HashMap<String, Object> dependOnSiblings = new HashMap<String, Object>();
            for (Map.Entry<String, String> entry : curr.entrySet()) {
                String prop = entry.getKey();
                if (m.containsKey(prop)) continue;
                String rawval = entry.getValue();
                Union2<String, Set<String>> o = SequentialPropertyEvaluator.substitute(rawval, m, curr.keySet());
                if (o.hasFirst()) {
                    m.put(prop, (String)o.first());
                    continue;
                }
                dependOnSiblings.put(prop, o.second());
            }
            HashSet toSort = new HashSet(dependOnSiblings.keySet());
            for (Set s : dependOnSiblings.values()) {
                toSort.addAll(s);
            }
            try {
                sorted = BaseUtilities.topologicalSort(toSort, dependOnSiblings);
            }
            catch (TopologicalSortException e) {
                return null;
            }
            Collections.reverse(sorted);
            for (String prop : sorted) {
                if (m.containsKey(prop)) continue;
                String rawval = curr.get(prop);
                m.put(prop, (String)SequentialPropertyEvaluator.substitute(rawval, m, curr.keySet()).first());
            }
        }
        return SequentialPropertyEvaluator.copyAndCompact(m);
    }

    private static <K, V> Map<K, V> copyAndCompact(Map<K, V> m) {
        HashMap<K, V> m2 = new HashMap<K, V>((int)((float)m.size() / 0.95f) + 1, 0.95f);
        m2.putAll(m);
        return m2;
    }
}

