/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.MenuComponent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.modules.form.CreationDescriptor;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.MultiClassLoader;
import org.netbeans.modules.form.fakepeer.FakePeerSupport;
import org.openide.ErrorManager;
import org.openide.util.Lookup;

public class CreationFactory {
    private static Map<String, CreationDescriptor> registry;
    private static boolean defaultDescriptorsCreated;

    private CreationFactory() {
    }

    public static CreationDescriptor getDescriptor(Class cls) {
        CreationDescriptor cd = CreationFactory.getRegistry().get(cls.getName());
        if (cd == null && !defaultDescriptorsCreated && (cls.getName().startsWith("javax.swing.") || cls.getName().startsWith("java.awt."))) {
            CreationFactory.createDefaultDescriptors();
            cd = CreationFactory.getRegistry().get(cls.getName());
        }
        if (cd != null) {
            cd.setDescribedClass(cls);
        }
        return cd;
    }

    public static void registerDescriptor(CreationDescriptor desc) {
        CreationFactory.getRegistry().put(desc.getDescribedClassName(), desc);
    }

    public static void unregisterDescriptor(CreationDescriptor desc) {
        if (registry != null) {
            registry.remove(desc.getDescribedClassName());
        }
    }

    public static Object createDefaultInstance(Class cls) throws Exception {
        Object instance;
        CreationDescriptor cd = CreationFactory.getDescriptor(cls);
        Object cl = UIManager.get("ClassLoader");
        Object cl2 = UIManager.getLookAndFeelDefaults().get("ClassLoader");
        ClassLoader uiCl = cl instanceof ClassLoader ? (ClassLoader)cl : null;
        ClassLoader systemCl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        ClassLoader beanCl = cls.getClassLoader();
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        if (beanCl != null) {
            loaders.add(beanCl);
        }
        loaders.add(systemCl);
        if (uiCl != null) {
            loaders.add(uiCl);
        }
        MultiClassLoader newCl = new MultiClassLoader(loaders.toArray(new ClassLoader[loaders.size()]));
        UIManager.put("ClassLoader", newCl);
        Object object = instance = cd != null ? cd.createDefaultInstance() : cls.newInstance();
        if (cl == cl2) {
            UIManager.getDefaults().remove("ClassLoader");
        } else {
            UIManager.put("ClassLoader", cl);
        }
        CreationFactory.initAfterCreation(instance);
        return instance;
    }

    public static Object createInstance(Class cls) throws Exception {
        CreationDescriptor cd = CreationFactory.getDescriptor(cls);
        Object instance = cd != null ? cd.createDefaultInstance() : cls.newInstance();
        CreationFactory.initAfterCreation(instance);
        return instance;
    }

    public static Object createInstance(Class cls, FormProperty[] props, int style) throws Exception {
        CreationDescriptor cd = CreationFactory.getDescriptor(cls);
        if (cd == null) {
            return null;
        }
        CreationDescriptor.Creator creator = cd.findBestCreator(props, style);
        if (creator == null) {
            return null;
        }
        Object instance = creator.createInstance(props);
        CreationFactory.initAfterCreation(instance);
        return instance;
    }

    public static FormProperty[] getPropertiesForCreator(CreationDescriptor.Creator creator, FormProperty[] properties) {
        String[] propNames = creator.getPropertyNames();
        FormProperty[] crProps = new FormProperty[propNames.length];
        for (int i = 0; i < propNames.length; ++i) {
            String propName = propNames[i];
            for (int j = 0; j < properties.length; ++j) {
                if (!propName.equals(properties[j].getName())) continue;
                crProps[i] = properties[j];
                break;
            }
            if (crProps[i] != null) continue;
            return null;
        }
        return crProps;
    }

    public static FormProperty[] getRemainingProperties(CreationDescriptor.Creator creator, FormProperty[] properties) {
        String[] propNames = creator.getPropertyNames();
        FormProperty[] remProps = new FormProperty[properties.length - propNames.length];
        if (remProps.length == 0) {
            return remProps;
        }
        int ii = 0;
        for (int i = 0; i < properties.length; ++i) {
            String propName = properties[i].getName();
            for (int j = 0; j < propNames.length && !propName.equals(propNames[j]); ++j) {
                if (j + 1 != propNames.length) continue;
                if (ii > remProps.length) {
                    return null;
                }
                remProps[ii++] = properties[i];
            }
        }
        return remProps;
    }

    public static boolean containsProperty(CreationDescriptor desc, String propName) {
        CreationDescriptor.Creator[] creators = desc.getCreators();
        if (creators == null) {
            return false;
        }
        for (int i = 0; i < creators.length; ++i) {
            String[] propNames = creators[i].getPropertyNames();
            for (int j = 0; j < propNames.length; ++j) {
                if (!propNames[j].equals(propName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsProperty(CreationDescriptor.Creator creator, String propName) {
        String[] propNames = creator.getPropertyNames();
        for (int j = 0; j < propNames.length; ++j) {
            if (!propNames[j].equals(propName)) continue;
            return true;
        }
        return false;
    }

    public static FormProperty findProperty(String propName, FormProperty[] properties) {
        for (int i = 0; i < properties.length; ++i) {
            if (!properties[i].getName().equals(propName)) continue;
            return properties[i];
        }
        return null;
    }

    public static CreationDescriptor.Creator findCreator(CreationDescriptor desc, Class[] paramTypes) {
        CreationDescriptor.Creator[] creators = desc.getCreators();
        for (int i = 0; i < creators.length; ++i) {
            CreationDescriptor.Creator cr = creators[i];
            if (cr.getParameterCount() != paramTypes.length) continue;
            Class[] types = cr.getParameterTypes();
            boolean match = true;
            for (int j = 0; j < types.length; ++j) {
                if (types[j].isAssignableFrom(paramTypes[j])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return cr;
        }
        return null;
    }

    public static int[] evaluateCreators(CreationDescriptor.Creator[] creators, FormProperty[] properties, boolean changedOnly) {
        if (creators == null || creators.length == 0) {
            return null;
        }
        int[] placed = new int[creators.length];
        for (int i = 0; i < properties.length; ++i) {
            if (changedOnly && !properties[i].isChanged()) continue;
            String name = properties[i].getName();
            for (int j = 0; j < creators.length; ++j) {
                String[] crNames = creators[j].getPropertyNames();
                for (int k = 0; k < crNames.length; ++k) {
                    if (!name.equals(crNames[k])) continue;
                    int n = j;
                    placed[n] = placed[n] + 1;
                }
            }
        }
        return placed;
    }

    public static int getBestCreator(CreationDescriptor.Creator[] creators, FormProperty[] properties, int[] placed, boolean placeAllProps) {
        if (creators == null || creators.length == 0) {
            return -1;
        }
        int best = 0;
        int[] sizes = new int[creators.length];
        sizes[0] = creators[0].getParameterCount();
        if (placeAllProps) {
            for (int i = 1; i < placed.length; ++i) {
                sizes[i] = creators[i].getParameterCount();
                if (placed[i] <= placed[best] && (placed[i] != placed[best] || sizes[i] >= sizes[best] && (sizes[i] != sizes[best] || CreationFactory.compareCreatorsAmbiguity(creators[i], creators[best], properties) != 1))) continue;
                best = i;
            }
        } else {
            for (int i = 1; i < placed.length; ++i) {
                sizes[i] = creators[i].getParameterCount();
                int iDiff = sizes[i] - placed[i];
                int bestDiff = sizes[best] - placed[best];
                if (iDiff >= bestDiff && (iDiff != bestDiff || sizes[i] <= sizes[best] && (sizes[i] != sizes[best] || CreationFactory.compareCreatorsAmbiguity(creators[i], creators[best], properties) != 1))) continue;
                best = i;
            }
        }
        return best;
    }

    static int compareCreatorsAmbiguity(CreationDescriptor.Creator cr1, CreationDescriptor.Creator cr2, FormProperty[] properties) {
        int nullValues1 = 0;
        int nullValues2 = 0;
        int n = cr1.getParameterCount();
        for (int i = 0; i < n; ++i) {
            String name2;
            String name1 = cr1.getPropertyNames()[i];
            if (name1.equals(name2 = cr2.getPropertyNames()[i])) continue;
            FormProperty prop1 = null;
            FormProperty prop2 = null;
            for (int j = 0; j < properties.length; ++j) {
                if (prop1 == null && name1.equals(properties[j].getName())) {
                    prop1 = properties[j];
                    if (prop2 == null) continue;
                    break;
                }
                if (prop2 != null || !name2.equals(properties[j].getName())) continue;
                prop2 = properties[j];
                if (prop1 != null) break;
            }
            if (prop1 != null && !prop1.getValueType().isPrimitive()) {
                try {
                    if (prop1.getRealValue() == null) {
                        ++nullValues1;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (prop2 == null || prop2.getValueType().isPrimitive()) continue;
            try {
                if (prop2.getRealValue() != null) continue;
                ++nullValues2;
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (nullValues1 == nullValues2) {
            return 0;
        }
        return nullValues1 < nullValues2 ? 1 : 2;
    }

    static Map<String, CreationDescriptor> getRegistry() {
        if (registry == null) {
            registry = new HashMap<String, CreationDescriptor>(40);
        }
        return registry;
    }

    private static void initAfterCreation(Object instance) {
        if (instance instanceof TitledBorder) {
            ((TitledBorder)instance).setTitleFont(UIManager.getFont("TitledBorder.createDefaultInstancefont"));
        } else if (instance instanceof Component && !(instance instanceof JComponent) && !(instance instanceof RootPaneContainer)) {
            ((Component)instance).setName(null);
            ((Component)instance).setFont(FakePeerSupport.getDefaultAWTFont());
        } else if (instance instanceof MenuComponent) {
            ((MenuComponent)instance).setName(null);
            ((MenuComponent)instance).setFont(FakePeerSupport.getDefaultAWTFont());
        }
    }

    private static void createDefaultDescriptors() {
        PropertyParameters[] insetsPropertyParameters = new InsetsPropertyParameters[]{new InsetsPropertyParameters("borderInsets")};
        try {
            Class[][] constrParamTypes = new Class[][]{{Color.class, Integer.TYPE, Boolean.TYPE}};
            String[][] constrPropertyNames = new String[][]{{"lineColor", "thickness", "roundedCorners"}};
            Object[] defaultConstrParams = new Object[]{Color.black};
            CreationDescriptor cd = new CreationDescriptor();
            cd.addConstructorCreators(LineBorder.class, constrParamTypes, constrPropertyNames, defaultConstrParams);
            constrParamTypes = new Class[][]{{Color.class}, {Color.class, Integer.TYPE}};
            constrPropertyNames = new String[][]{{"lineColor"}, {"lineColor", "thickness"}};
            String methodName = "createLineBorder";
            cd.addMethodCreators(BorderFactory.class, LineBorder.class, methodName, constrParamTypes, constrPropertyNames, null, defaultConstrParams);
            CreationFactory.registerDescriptor(cd);
            defaultConstrParams = new Object[]{};
            constrParamTypes = new Class[][]{new Class[0], {Color.class, Color.class}, {Integer.TYPE}, {Integer.TYPE, Color.class, Color.class}};
            constrPropertyNames = new String[][]{new String[0], {"highlightColor", "shadowColor"}, {"etchType"}, {"etchType", "highlightColor", "shadowColor"}};
            methodName = "createEtchedBorder";
            CreationFactory.registerDescriptor(new CreationDescriptor(BorderFactory.class, EtchedBorder.class, methodName, constrParamTypes, constrPropertyNames, null, defaultConstrParams));
            constrParamTypes = new Class[][]{{Insets.class}};
            constrPropertyNames = new String[][]{{"borderInsets"}};
            Integer one = 1;
            defaultConstrParams = new Object[]{one, one, one, one};
            methodName = "createEmptyBorder";
            CreationFactory.registerDescriptor(new CreationDescriptor(BorderFactory.class, EmptyBorder.class, methodName, constrParamTypes, constrPropertyNames, insetsPropertyParameters, defaultConstrParams));
            constrParamTypes = new Class[][]{{String.class}, {Border.class, String.class}, {Border.class, String.class, Integer.TYPE, Integer.TYPE}, {Border.class, String.class, Integer.TYPE, Integer.TYPE, Font.class}, {Border.class, String.class, Integer.TYPE, Integer.TYPE, Font.class, Color.class}, {Border.class}};
            constrPropertyNames = new String[][]{{"title"}, {"border", "title"}, {"border", "title", "titleJustification", "titlePosition"}, {"border", "title", "titleJustification", "titlePosition", "titleFont"}, {"border", "title", "titleJustification", "titlePosition", "titleFont", "titleColor"}, {"border"}};
            defaultConstrParams = new Object[]{null, "", 0, 0};
            methodName = "createTitledBorder";
            CreationFactory.registerDescriptor(new CreationDescriptor(BorderFactory.class, TitledBorder.class, methodName, constrParamTypes, constrPropertyNames, null, defaultConstrParams));
            constrParamTypes = new Class[][]{new Class[0], {Border.class, Border.class}};
            constrPropertyNames = new String[][]{new String[0], {"outsideBorder", "insideBorder"}};
            defaultConstrParams = new Object[]{};
            methodName = "createCompoundBorder";
            CreationFactory.registerDescriptor(new CreationDescriptor(BorderFactory.class, CompoundBorder.class, methodName, constrParamTypes, constrPropertyNames, null, defaultConstrParams));
            constrParamTypes = new Class[][]{{Integer.TYPE}, {Integer.TYPE, Color.class, Color.class}, {Integer.TYPE, Color.class, Color.class, Color.class, Color.class}};
            constrPropertyNames = new String[][]{{"bevelType"}, {"bevelType", "highlightOuterColor", "shadowOuterColor"}, {"bevelType", "highlightOuterColor", "highlightInnerColor", "shadowOuterColor", "shadowInnerColor"}};
            defaultConstrParams = new Object[]{0};
            methodName = "createBevelBorder";
            CreationFactory.registerDescriptor(new CreationDescriptor(BorderFactory.class, BevelBorder.class, methodName, constrParamTypes, constrPropertyNames, null, defaultConstrParams));
            constrParamTypes = new Class[][]{{Integer.TYPE}, {Integer.TYPE, Color.class, Color.class}, {Integer.TYPE, Color.class, Color.class, Color.class, Color.class}};
            constrPropertyNames = new String[][]{{"bevelType"}, {"bevelType", "highlightOuterColor", "shadowOuterColor"}, {"bevelType", "highlightOuterColor", "highlightInnerColor", "shadowOuterColor", "shadowInnerColor"}};
            CreationFactory.registerDescriptor(new CreationDescriptor(SoftBevelBorder.class, constrParamTypes, constrPropertyNames, defaultConstrParams));
            cd = new CreationDescriptor();
            constrParamTypes = new Class[][]{{Icon.class}};
            constrPropertyNames = new String[][]{{"tileIcon"}};
            cd.addConstructorCreators(MatteBorder.class, constrParamTypes, constrPropertyNames, defaultConstrParams);
            constrParamTypes = new Class[][]{{Insets.class, Icon.class}, {Insets.class, Color.class}};
            constrPropertyNames = new String[][]{{"borderInsets", "tileIcon"}, {"borderInsets", "matteColor"}};
            defaultConstrParams = new Object[]{one, one, one, one, Color.black};
            methodName = "createMatteBorder";
            cd.addMethodCreators(BorderFactory.class, MatteBorder.class, methodName, constrParamTypes, constrPropertyNames, insetsPropertyParameters, defaultConstrParams);
            CreationFactory.registerDescriptor(cd);
            constrParamTypes = new Class[][]{new Class[0], {Integer.TYPE, Integer.TYPE}};
            constrPropertyNames = new String[][]{new String[0], {"hgap", "vgap"}};
            defaultConstrParams = new Object[]{};
            CreationFactory.registerDescriptor(new CreationDescriptor(BorderLayout.class, constrParamTypes, constrPropertyNames, defaultConstrParams));
            constrParamTypes = new Class[][]{new Class[0], {Integer.TYPE}, {Integer.TYPE, Integer.TYPE, Integer.TYPE}};
            constrPropertyNames = new String[][]{new String[0], {"alignment"}, {"alignment", "hgap", "vgap"}};
            CreationFactory.registerDescriptor(new CreationDescriptor(FlowLayout.class, constrParamTypes, constrPropertyNames, defaultConstrParams));
            constrParamTypes = new Class[][]{new Class[0]};
            constrPropertyNames = new String[][]{new String[0]};
            CreationFactory.registerDescriptor(new CreationDescriptor(GridBagLayout.class, constrParamTypes, constrPropertyNames, defaultConstrParams));
            constrParamTypes = new Class[][]{new Class[0], {Integer.TYPE, Integer.TYPE}, {Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}};
            constrPropertyNames = new String[][]{new String[0], {"rows", "columns"}, {"rows", "columns", "hgap", "vgap"}};
            CreationFactory.registerDescriptor(new CreationDescriptor(GridLayout.class, constrParamTypes, constrPropertyNames, defaultConstrParams));
            constrParamTypes = new Class[][]{new Class[0], {Integer.TYPE, Integer.TYPE}};
            constrPropertyNames = new String[][]{new String[0], {"hgap", "vgap"}};
            CreationFactory.registerDescriptor(new CreationDescriptor(CardLayout.class, constrParamTypes, constrPropertyNames, defaultConstrParams));
            constrParamTypes = new Class[][]{{Frame.class}};
            constrPropertyNames = new String[][]{{"owner"}};
            defaultConstrParams = new Object[]{new Frame()};
            CreationFactory.registerDescriptor(new CreationDescriptor(Dialog.class, constrParamTypes, constrPropertyNames, defaultConstrParams));
            CreationFactory.registerDescriptor(new CreationDescriptor(JPanel.class){

                @Override
                public Object createDefaultInstance() {
                    return new JPanel(new FlowLayout());
                }
            });
            constrParamTypes = new Class[][]{{Dimension.class, Dimension.class, Dimension.class}};
            constrPropertyNames = new String[][]{{"minimumSize", "preferredSize", "maximumSize"}};
            defaultConstrParams = new Object[]{new Dimension(), new Dimension(), new Dimension()};
            CreationFactory.registerDescriptor(new CreationDescriptor(Box.Filler.class, constrParamTypes, constrPropertyNames, defaultConstrParams));
            defaultDescriptorsCreated = true;
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
    }

    static {
        defaultDescriptorsCreated = false;
    }

    static class InsetsPropertyParameters
    implements PropertyParameters {
        private static Class[] parameterTypes = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
        private final String propertyName;

        public InsetsPropertyParameters(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public String getJavaParametersString(FormProperty prop) {
            Insets insets = (Insets)InsetsPropertyParameters.getRealValue(prop);
            if (insets != null) {
                return insets.top + ", " + insets.left + ", " + insets.bottom + ", " + insets.right;
            }
            return "";
        }

        @Override
        public Object[] getPropertyParametersValues(FormProperty prop) {
            Insets insets = (Insets)InsetsPropertyParameters.getRealValue(prop);
            if (insets != null) {
                return new Object[]{insets.top, insets.left, insets.bottom, insets.right};
            }
            return new Object[0];
        }

        @Override
        public Class[] getPropertyParametersTypes() {
            return parameterTypes;
        }

        private static Object getRealValue(FormProperty prop) {
            try {
                return prop.getRealValue();
            }
            catch (InvocationTargetException ite) {
                ErrorManager.getDefault().notify((Throwable)ite);
            }
            catch (IllegalAccessException iae) {
                ErrorManager.getDefault().notify((Throwable)iae);
            }
            return null;
        }
    }

    static class Property2ParametersMapper {
        private final String propertyName;
        private final Class[] propertyType = new Class[1];
        private PropertyParameters parameters;

        Property2ParametersMapper(Class propertyClass, String propertyName) {
            this.propertyType[0] = propertyClass;
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Class[] getPropertyTypes() {
            if (this.parameters != null) {
                return this.parameters.getPropertyParametersTypes();
            }
            return this.propertyType;
        }

        public String getJavaParametersString(FormProperty prop) {
            if (this.parameters != null) {
                return this.parameters.getJavaParametersString(prop);
            }
            return prop.getJavaInitializationString();
        }

        public Object[] getPropertyParametersValues(FormProperty prop) {
            if (this.parameters != null) {
                return this.parameters.getPropertyParametersValues(prop);
            }
            try {
                return new Object[]{prop.getRealValue()};
            }
            catch (InvocationTargetException ite) {
                ErrorManager.getDefault().notify((Throwable)ite);
            }
            catch (IllegalAccessException iae) {
                ErrorManager.getDefault().notify((Throwable)iae);
            }
            return new Object[0];
        }

        public void setPropertyParameters(PropertyParameters parameters) {
            this.parameters = parameters;
        }
    }

    static interface PropertyParameters {
        public String getPropertyName();

        public String getJavaParametersString(FormProperty var1);

        public Object[] getPropertyParametersValues(FormProperty var1);

        public Class[] getPropertyParametersTypes();
    }
}

