/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.form.editors.ClassPathFileChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class ImportImageWizard
extends WizardDescriptor {
    private WizardDescriptor.Iterator wizardIterator;
    private File[] selectedFiles;
    private FileObject targetFolder;
    private FileObject fileInProject;
    static String lastDirectoryUsed;

    ImportImageWizard(File[] files, FileObject targetFolder, FileObject fileInProject) {
        this((WizardDescriptor.Iterator)new WizardDescriptor.ArrayIterator(new WizardDescriptor.Panel[]{new SourceWizardPanel(), new TargetWizardPanel()}));
        if (targetFolder != null) assert (FileOwnerQuery.getOwner((FileObject)targetFolder) == FileOwnerQuery.getOwner((FileObject)fileInProject));
        this.selectedFiles = files;
        this.targetFolder = targetFolder;
        this.fileInProject = fileInProject;
    }

    private ImportImageWizard(WizardDescriptor.Iterator iterator) {
        super(iterator);
        this.wizardIterator = iterator;
        this.putProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        this.putProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        this.putProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        this.setTitle(NbBundle.getMessage(ImportImageWizard.class, (String)"ImportImageWizard.Title"));
        this.setTitleFormat(new MessageFormat("{0}"));
        this.putProperty("WizardPanel_contentData", new String[]{NbBundle.getMessage(ImportImageWizard.class, (String)"ImportImageWizard.Step1"), NbBundle.getMessage(ImportImageWizard.class, (String)"ImportImageWizard.Step2")});
    }

    FileObject[] show() {
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this);
        dialog.setVisible(true);
        dialog.dispose();
        return this.getValue() == FINISH_OPTION ? this.copyFiles() : null;
    }

    void stepToNext() {
        if (this.wizardIterator.hasNext()) {
            this.wizardIterator.nextPanel();
            this.updateState();
        }
    }

    private FileObject[] copyFiles() {
        if (this.selectedFiles == null || this.selectedFiles.length == 0 || this.targetFolder == null) {
            return null;
        }
        final FileObject[] copied = new FileObject[this.selectedFiles.length];
        try {
            FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    for (int i = 0; i < ImportImageWizard.this.selectedFiles.length; ++i) {
                        File f = ImportImageWizard.this.selectedFiles[i];
                        String fileName = f.getName();
                        FileObject targetFile = ImportImageWizard.this.targetFolder.getFileObject(fileName);
                        if (targetFile != null && targetFile.isFolder()) {
                            targetFile = null;
                        }
                        if (targetFile == null || ImportImageWizard.this.canRewriteTarget(f, targetFile)) {
                            if (targetFile != null) {
                                targetFile.delete();
                            }
                            FileInputStream is = new FileInputStream(f);
                            targetFile = ImportImageWizard.this.targetFolder.createData(fileName);
                            FileLock lock = targetFile.lock();
                            OutputStream os = targetFile.getOutputStream(lock);
                            byte[] buf = new byte[4096];
                            try {
                                int count;
                                while ((count = is.read(buf)) != -1) {
                                    os.write(buf, 0, count);
                                }
                            }
                            finally {
                                os.close();
                                lock.releaseLock();
                            }
                        }
                        copied[i] = targetFile;
                    }
                }
            });
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return copied;
    }

    private boolean canRewriteTarget(File source, FileObject targetFO) {
        FileObject sourceFO = FileUtil.toFileObject((File)source);
        if (sourceFO != null && sourceFO.equals(targetFO)) {
            return false;
        }
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(NbBundle.getMessage(ImportImageWizard.class, (String)"FMT_ReplaceExistingFileQuestion"), source.getName()), NbBundle.getMessage(ImportImageWizard.class, (String)"TITLE_FileAlreadyExists"), 0);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION;
    }

    static /* synthetic */ File[] access$202(ImportImageWizard x0, File[] x1) {
        x0.selectedFiles = x1;
        return x1;
    }

    private static class TargetWizardPanel
    implements WizardDescriptor.Panel {
        private ImportImageWizard wizard;
        private ClassPathFileChooser cpfChooser;
        private EventListenerList listenerList;
        private boolean setTargetFolder;

        private TargetWizardPanel() {
        }

        public Component getComponent() {
            if (this.cpfChooser == null) {
                this.cpfChooser = new ClassPathFileChooser(this.wizard.fileInProject, new ClassPathFileChooser.Filter(){

                    @Override
                    public boolean accept(FileObject fo) {
                        return fo.isFolder();
                    }
                }, true, false);
                this.cpfChooser.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent ev) {
                        if (!TargetWizardPanel.this.setTargetFolder && "selectedFile".equals(ev.getPropertyName())) {
                            TargetWizardPanel.this.fireStateChanged();
                        }
                    }
                });
                this.cpfChooser.setPreferredSize(new Dimension(200, 200));
                this.cpfChooser.setName(NbBundle.getMessage(ImportImageWizard.class, (String)"ImportImageWizard.Step2"));
                this.cpfChooser.putClientProperty("WizardPanel_contentSelectedIndex", 1);
            }
            if (this.setTargetFolder) {
                try {
                    this.cpfChooser.setSelectedFile(this.wizard.targetFolder);
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(ImportImageWizard.class.getName()).log(Level.INFO, "Folder " + this.wizard.targetFolder + " not found on classpath of " + this.wizard.fileInProject, ex);
                }
                this.setTargetFolder = false;
            }
            return this.cpfChooser;
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void readSettings(Object settings) {
            this.wizard = (ImportImageWizard)((Object)settings);
            this.setTargetFolder = true;
        }

        public void storeSettings(Object settings) {
            if (this.cpfChooser != null) {
                this.wizard.targetFolder = this.cpfChooser.getSelectedFile();
            }
        }

        public boolean isValid() {
            if (this.cpfChooser != null) {
                FileObject fo = this.cpfChooser.getSelectedFile();
                return fo != null && fo.isFolder();
            }
            if (this.wizard != null) {
                return this.wizard.targetFolder != null;
            }
            return false;
        }

        public void addChangeListener(ChangeListener l) {
            if (this.listenerList == null) {
                this.listenerList = new EventListenerList();
            }
            this.listenerList.add(ChangeListener.class, l);
        }

        public void removeChangeListener(ChangeListener l) {
            if (this.listenerList != null) {
                this.listenerList.remove(ChangeListener.class, l);
            }
        }

        void fireStateChanged() {
            if (this.listenerList == null) {
                return;
            }
            ChangeEvent e = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ChangeListener.class) continue;
                if (e == null) {
                    e = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(e);
            }
        }
    }

    private static class SourceWizardPanel
    implements WizardDescriptor.Panel,
    WizardDescriptor.FinishablePanel {
        private ImportImageWizard wizard;
        private JFileChooser fileChooser;
        private EventListenerList listenerList;
        private boolean setSelectedFiles;

        private SourceWizardPanel() {
        }

        public Component getComponent() {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser(lastDirectoryUsed);
                this.fileChooser.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.fileChooser.setFileSelectionMode(0);
                this.fileChooser.setAcceptAllFileFilterUsed(true);
                this.fileChooser.setControlButtonsAreShown(false);
                this.fileChooser.setMultiSelectionEnabled(true);
                this.fileChooser.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        if ("ApproveSelection".equals(ev.getActionCommand())) {
                            SourceWizardPanel.this.wizard.stepToNext();
                        } else if ("CancelSelection".equals(ev.getActionCommand())) {
                            SourceWizardPanel.this.fileChooser.getTopLevelAncestor().setVisible(false);
                        }
                    }
                });
                this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent ev) {
                        if (!SourceWizardPanel.this.setSelectedFiles && "SelectedFilesChangedProperty".equals(ev.getPropertyName())) {
                            SourceWizardPanel.this.fireStateChanged();
                        }
                    }
                });
                this.fileChooser.setName(NbBundle.getMessage(ImportImageWizard.class, (String)"ImportImageWizard.Step1"));
                this.fileChooser.putClientProperty("WizardPanel_contentSelectedIndex", 0);
            }
            if (this.setSelectedFiles) {
                this.fileChooser.setSelectedFiles(this.wizard.selectedFiles);
                this.setSelectedFiles = false;
            }
            return this.fileChooser;
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void readSettings(Object settings) {
            this.wizard = (ImportImageWizard)((Object)settings);
            this.setSelectedFiles = true;
        }

        public void storeSettings(Object settings) {
            if (this.fileChooser != null) {
                File[] files = this.fileChooser.getSelectedFiles();
                ImportImageWizard.access$202((ImportImageWizard)((Object)settings), files);
                if (files != null && files.length > 0) {
                    lastDirectoryUsed = files[0].getParent();
                }
            }
        }

        public boolean isValid() {
            return this.fileChooser != null && this.fileChooser.getSelectedFiles().length > 0;
        }

        public boolean isFinishPanel() {
            return this.wizard != null && this.wizard.targetFolder != null;
        }

        public void addChangeListener(ChangeListener l) {
            if (this.listenerList == null) {
                this.listenerList = new EventListenerList();
            }
            this.listenerList.add(ChangeListener.class, l);
        }

        public void removeChangeListener(ChangeListener l) {
            if (this.listenerList != null) {
                this.listenerList.remove(ChangeListener.class, l);
            }
        }

        void fireStateChanged() {
            if (this.listenerList == null) {
                return;
            }
            ChangeEvent e = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ChangeListener.class) continue;
                if (e == null) {
                    e = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(e);
            }
        }
    }
}

