/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.ri.platform.installer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.javacard.common.Utils;
import org.netbeans.modules.javacard.ri.platform.MergeProperties;
import org.netbeans.modules.javacard.ri.platform.RIPlatform;
import org.netbeans.modules.javacard.ri.platform.installer.JavacardPlatformWizardIterator;
import org.netbeans.modules.javacard.ri.platform.installer.PlatformInfo;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.netbeans.modules.javacard.spi.JavacardPlatformKeyNames;
import org.netbeans.modules.propdos.AntStyleResolvingProperties;
import org.netbeans.modules.propdos.ObservableProperties;
import org.netbeans.modules.propdos.PropertiesAdapter;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class RIPlatformFactory
implements Mutex.ExceptionAction<FileObject> {
    private final EditableProperties platformProps;
    private final EditableProperties deviceSettings;
    private final FileObject baseDir;
    private final ProgressHandle h;
    private final String displayName;
    private FileObject platformFile;
    private final FileObject platformsFolder = FileUtil.getConfigFile((String)"Services/Platforms/org-netbeans-api-java-Platform");
    private final EditableProperties globalProps = PropertyUtils.getGlobalProperties();
    public static final SpecificationVersion MINIMUM_SUPPORTED_VERSION = new SpecificationVersion("3.0.2");
    private int step;
    private static final String JC_302_DEBUG_PROXY_CP = "lib/api_connected.jar:lib/api.jar:lib/romizer.jar:lib/tools.jar:lib/asm-all-3.1.jar:lib/bcel-5.2.jar:lib/commons-logging-1.1.jar:lib/commons-httpclient-3.0.jar:lib/commons-codec-1.3.jar:lib/commons-cli-1.0.jar:lib/ant-contrib-1.0b3.jar";
    public static final String ANT_TASKS_302_JAR_PATH = "javacard302/anttasks.jar";
    public boolean antTasksUpdated;

    RIPlatformFactory(PlatformInfo info, EditableProperties deviceSettings, FileObject baseDir, ProgressHandle h, String displayName) {
        this(info.writeTo(new EditableProperties(true)), deviceSettings, baseDir, h, displayName);
    }

    public RIPlatformFactory(EditableProperties platformProps, EditableProperties deviceSettings, FileObject baseDir, ProgressHandle h, String displayName) {
        Parameters.notNull((CharSequence)"platformProps", (Object)platformProps);
        Parameters.notNull((CharSequence)"baseDir", (Object)baseDir);
        Parameters.notNull((CharSequence)"displayName", (Object)displayName);
        this.platformProps = platformProps;
        this.baseDir = baseDir;
        this.h = h;
        this.displayName = displayName;
        assert (this.platformsFolder != null);
        this.deviceSettings = deviceSettings;
        platformProps.put("javacard.displayName", displayName);
    }

    RIPlatformFactory(FileObject baseDir, String displayName) throws IOException {
        this(RIPlatformFactory.readPlatformProperties(baseDir), null, baseDir, null, displayName);
    }

    public static boolean canInstall(String javacardVersion) {
        SpecificationVersion v = new SpecificationVersion(javacardVersion);
        return v.compareTo((Object)MINIMUM_SUPPORTED_VERSION) >= 0;
    }

    public static boolean canInstall(Map<? extends Object, ? extends Object> m) {
        Object o = m.get("javacard.version");
        return o == null ? false : RIPlatformFactory.canInstall(o.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileObject createPlatform() throws IOException {
        try {
            try {
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)this);
                FileObject fileObject = this.platformFile;
                return fileObject;
            }
            catch (MutexException ex) {
                IOException ioe = new IOException("Exception creating platform in " + this.baseDir.getPath());
                ioe.initCause(ex);
                throw ioe;
            }
            finally {
                if (this.h != null) {
                    this.h.finish();
                }
            }
        }
        catch (IOException ioe) {
            if (this.platformFile == null) throw ioe;
            if (!this.platformFile.isValid()) throw ioe;
            this.platformFile.delete();
            throw ioe;
        }
    }

    public FileObject run() throws Exception {
        FileUtil.getConfigRoot().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                RIPlatformFactory.this.platformFile = RIPlatformFactory.this.create();
            }
        });
        return this.platformFile;
    }

    private FileObject create() throws IOException {
        this.progress();
        if (!RIPlatformFactory.canInstall((Map<? extends Object, ? extends Object>)this.platformProps)) {
            throw new IOException(NbBundle.getMessage(RIPlatformFactory.class, (String)"ERR_TOO_OLD", (Object)this.platformProps.get((Object)"javacard.version"), (Object)MINIMUM_SUPPORTED_VERSION));
        }
        this.addMissingPropertiesJC302();
        SpecificationVersion platformVersion = new SpecificationVersion(this.platformProps.getProperty("javacard.version"));
        if (Utils.canUseCompilationPreprocessor((SpecificationVersion)platformVersion)) {
            String hackedClassicBootClasspath = this.platformProps.get((Object)"javacard.classic.bootclasspath") + ':' + "lib/api_classic_annotations.jar";
            this.platformProps.put("javacard.classic.bootclasspath", hackedClassicBootClasspath);
        }
        this.translatePaths(FileUtil.toFile((FileObject)this.baseDir), this.platformProps);
        this.hackAntTasksJarFor302();
        String filename = this.getPlatformFileName();
        this.progress();
        this.platformProps.setProperty("javacard.instance.id", filename);
        this.progress();
        FileObject fo = this.platformFile = this.platformsFolder.createData(filename, "jcplatform");
        this.progress();
        this.createAndStoreEepromFolder(filename);
        this.progress();
        if (!this.platformProps.containsKey((Object)"javacard.ri.home") && "RI".equals(this.platformProps.get((Object)"javacard.platform.kind"))) {
            File f = FileUtil.toFile((FileObject)this.baseDir);
            String path = f == null ? this.baseDir.getPath() : f.getAbsolutePath();
            this.platformProps.put("javacard.ri.home", path);
        }
        ObservableProperties workingProps = this.maybeLoadDefaultPlatformProps();
        RIPlatformFactory.save(workingProps, fo);
        this.progress();
        if ("RI".equals(this.platformProps.getProperty("javacard.platform.kind"))) {
            this.storeGlobalJavacardRIPath(fo);
        }
        FileObject cardsFolder = Utils.sfsFolderForDeviceConfigsForPlatformNamed((String)filename, (boolean)true);
        this.progress();
        String ext = this.platformProps.getProperty("javacard.device.file.extension");
        String deviceFileName = this.findDeviceFileName(cardsFolder, ext);
        this.progress();
        EditableProperties deviceProps = this.loadDeviceProperties(deviceFileName);
        this.progress();
        FileObject deviceFile = cardsFolder.createData(deviceFileName, ext);
        RIPlatformFactory.save(deviceProps, deviceFile);
        this.progress();
        File f = FileUtil.toFile((FileObject)fo);
        String path = f == null ? "NONE" : f.getAbsolutePath();
        this.globalProps.setProperty("jcplatform." + filename, path);
        String globalPlatformPointerProperty = "jcplatform." + filename + ".devicespath";
        f = FileUtil.toFile((FileObject)cardsFolder);
        path = f == null ? "NONE" : f.getAbsolutePath();
        this.globalProps.setProperty(globalPlatformPointerProperty, path);
        PropertyUtils.putGlobalProperties((EditableProperties)this.globalProps);
        this.progress();
        return fo;
    }

    private final void addMissingPropertiesJC302() {
        if (!this.platformProps.containsKey((Object)"javacard.debug.proxy")) {
            FileObject fo = this.baseDir.getFileObject("bin/debugproxy.bat");
            if (fo == null) {
                fo = this.baseDir.getFileObject("bin/debugproxy");
            }
            if (fo == null) {
                fo = this.baseDir.getFileObject("bin/debugproxy.sh");
            }
            if (fo != null) {
                File file = FileUtil.toFile((FileObject)fo);
                String path = file == null ? fo.getPath() : file.getAbsolutePath();
                this.platformProps.put("javacard.debug.proxy", path);
            }
        }
        if (!this.platformProps.containsKey((Object)"javacard.debug.proxy.classpath")) {
            this.platformProps.put("javacard.debug.proxy.classpath", JC_302_DEBUG_PROXY_CP);
        }
    }

    private final void hackAntTasksJarFor302() {
        String ver = this.platformProps.getProperty("javacard.referenceimplementation.version");
        boolean upgrade = ver != null && "3.0.2".equals(ver.trim()) && !this.platformProps.containsKey((Object)"javacard.platform.302.ant.tasks.updated");
        Logger log = Logger.getLogger(RIPlatformFactory.class.getName());
        if (upgrade) {
            File antTasksJar = InstalledFileLocator.getDefault().locate(ANT_TASKS_302_JAR_PATH, "org.netbeans.modules.javacard.ri.platform", false);
            if (antTasksJar != null) {
                this.antTasksUpdated = true;
                this.platformProps.setProperty("javacard.platform.302.ant.tasks.updated", "" + Boolean.TRUE);
                for (String key : JavacardPlatformKeyNames.getPathPropertyNames((Map)this.platformProps)) {
                    String nue;
                    String path = this.platformProps.getProperty(key);
                    if (path == null || (nue = this.upgradePath(path, antTasksJar, log)) == null || nue.equals(path)) continue;
                    log.log(Level.INFO, "Upgrade {0} from {1} to {2}", new Object[]{key, path, nue});
                    this.platformProps.setProperty(key, nue);
                }
            } else {
                log.log(Level.WARNING, "Could not upgrade Ant tasks for {0} because Ant tasks JAR is missing", new Object[]{this.baseDir.getPath()});
            }
        }
    }

    final String upgradePath(String path, File antTasksJar, Logger log) {
        if (path != null && path.length() > 0) {
            FileObject origTasksJar = this.baseDir.getFileObject("lib/nbtasks.jar");
            if (origTasksJar != null) {
                File f = FileUtil.toFile((FileObject)origTasksJar);
                if (f != null) {
                    String abs = f.getAbsolutePath();
                    if (path.indexOf(abs) < 0) {
                        return path;
                    }
                    String antTasksPath = antTasksJar.getAbsolutePath();
                    Pattern p = Pattern.compile(File.pathSeparator, 16);
                    String[] components = p.split(path);
                    StringBuilder nue = new StringBuilder();
                    for (String pth : components) {
                        boolean match = abs.equals(pth);
                        if (match) {
                            pth = antTasksPath;
                        }
                        if (nue.length() > 0) {
                            nue.append(File.pathSeparator);
                        }
                        nue.append(pth);
                    }
                    return nue.toString();
                }
                log.log(Level.WARNING, "lib/nbtasks.jar exists but not a regular file: {0}", origTasksJar.getPath());
            } else {
                log.log(Level.WARNING, "lib/nbtasks.jar missing under {0}", new Object[]{this.baseDir.getPath()});
            }
        }
        return path;
    }

    private void progress() {
        if (this.h != null) {
            if (this.step == 0) {
                this.h.setInitialDelay(20);
                this.h.setDisplayName(NbBundle.getMessage(JavacardPlatformWizardIterator.class, (String)"PROGRESS_CREATING_PLATFORM"));
                this.h.start(14);
            }
            ++this.step;
            this.h.progress(this.step);
        }
    }

    private String getPlatformFileName() {
        FileObject fo;
        boolean hasOtherPlatforms = false;
        FileObject[] arr$ = this.platformsFolder.getChildren();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(hasOtherPlatforms = "jcplatform".equals((fo = arr$[i$]).getExt())); ++i$) {
        }
        String fname = !hasOtherPlatforms ? "javacard_default" : this.displayName.replace(' ', '_');
        String filename = FileUtil.findFreeFileName((FileObject)this.platformsFolder, (String)fname, (String)"jcplatform");
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void save(EditableProperties p, FileObject to) throws IOException {
        FileLock lock = to.lock();
        OutputStream out = to.getOutputStream(lock);
        try {
            p.store(out);
        }
        finally {
            lock.releaseLock();
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void save(ObservableProperties p, FileObject to) throws IOException {
        FileLock lock = to.lock();
        OutputStream out = to.getOutputStream(lock);
        try {
            p.store(out, null);
        }
        finally {
            lock.releaseLock();
            out.close();
        }
    }

    private void storeGlobalJavacardRIPath(FileObject fo) {
        File f;
        String val = this.globalProps.getProperty("javacard.ri.properties.path");
        if (!(val == null || (f = new File(val)).exists() && f.isDirectory())) {
            val = null;
        }
        if (val != null) {
            File file = FileUtil.toFile((FileObject)fo);
            this.globalProps.setProperty("javacard.ri.properties.path", file.getAbsolutePath());
        }
    }

    private boolean addPrototypeValues(EditableProperties deviceProps) {
        return RIPlatformFactory.addPrototypeValues(deviceProps, this.platformProps);
    }

    static boolean addPrototypeValues(EditableProperties deviceProps, EditableProperties platformProps) {
        boolean result = false;
        for (Map.Entry e : platformProps.entrySet()) {
            String key = (String)e.getKey();
            if (!key.startsWith("prototype.")) continue;
            result = true;
            key = key.substring("prototype.".length());
            deviceProps.put(key, (String)e.getValue());
        }
        return result;
    }

    private void translatePaths(File dir, EditableProperties props) {
        Set translatablePaths = JavacardPlatformKeyNames.getPathPropertyNames((Map)props);
        HashSet copy = new HashSet(translatablePaths);
        for (String s : copy) {
            translatablePaths.add("append." + s);
            translatablePaths.add("prepend." + s);
        }
        for (String key : new ArrayList(props.keySet())) {
            String val = props.getProperty(key);
            if (!translatablePaths.contains(key)) continue;
            String xlated = RIPlatformFactory.translatePath(dir, val);
            props.put(key, xlated);
        }
    }

    static String translatePath(File dir, String val) {
        if (val.startsWith("${")) {
            val = val.replace(':', File.pathSeparatorChar);
            val = val.replace('/', File.separatorChar);
            return val;
        }
        if ("".equals(val) || val == null) {
            return "";
        }
        if (".".equals(val) || "./".equals(val)) {
            return dir.getAbsolutePath();
        }
        if (val.startsWith("./")) {
            val = val.substring(2);
        }
        if (File.separatorChar != '/' && val.indexOf("/") >= 0) {
            val = val.replace('/', File.separatorChar);
        }
        if (val.indexOf(58) >= 0) {
            String[] paths = val.split(":");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                if (sb.length() > 0) {
                    sb.append(File.pathSeparatorChar);
                }
                sb.append(RIPlatformFactory.translatePath(dir, path));
            }
            return sb.toString();
        }
        File nue = new File(dir, val);
        String result = nue.getAbsolutePath();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EditableProperties loadDeviceProperties(String deviceFileName) throws IOException {
        EditableProperties deviceProps = new EditableProperties(true);
        if (!this.addPrototypeValues(deviceProps)) {
            FileObject deviceTemplate = FileUtil.getConfigFile((String)"org-netbeans-modules-javacard/templates/ServerTemplate.jcard");
            if (deviceTemplate != null) {
                BufferedInputStream in = new BufferedInputStream(deviceTemplate.getInputStream());
                try {
                    deviceProps.load((InputStream)in);
                }
                finally {
                    ((InputStream)in).close();
                }
            } else {
                Logger.getLogger(RIPlatformFactory.class.getName()).log(Level.WARNING, "Could not find device template " + deviceFileName + " in SFS");
            }
        }
        this.progress();
        deviceProps.put("javacard.device.name", deviceFileName);
        if (this.deviceSettings != null) {
            deviceProps.putAll((Map)this.deviceSettings);
        }
        return deviceProps;
    }

    private String findDeviceFileName(FileObject cardsFolder, String ext) {
        String deviceFileName = "Default Device";
        this.progress();
        deviceFileName = FileUtil.findFreeFileName((FileObject)cardsFolder, (String)deviceFileName, (String)ext);
        return deviceFileName;
    }

    private void createAndStoreEepromFolder(String filename) {
        FileObject eepromFolder = Utils.sfsFolderForDeviceEepromsForPlatformNamed((String)filename, (boolean)true);
        File f = FileUtil.toFile((FileObject)eepromFolder);
        if (f != null) {
            this.platformProps.setProperty("javacard.device.eeprom.folder", FileUtil.toFile((FileObject)eepromFolder).getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void read(EditableProperties to, FileObject from) throws IOException {
        BufferedInputStream in = new BufferedInputStream(from.getInputStream());
        try {
            to.load((InputStream)in);
        }
        finally {
            in.close();
        }
    }

    private static EditableProperties readPlatformProperties(FileObject baseDir) throws IOException {
        EditableProperties result = new EditableProperties(true);
        FileObject platformDefinition = baseDir.getFileObject("platform.properties");
        if (platformDefinition == null) {
            throw new IOException("No platform definition at path platform.properties in " + baseDir.getPath());
        }
        RIPlatformFactory.read(result, platformDefinition);
        return result;
    }

    private ObservableProperties maybeLoadDefaultPlatformProps() throws IOException {
        AntStyleResolvingProperties p = new AntStyleResolvingProperties(true);
        p.putAll((Map)this.platformProps);
        String riWrapperProp = this.platformProps.getProperty("javacard.wrap.ri");
        if (riWrapperProp != null && "true".equals(riWrapperProp) || "yes".equals(riWrapperProp)) {
            Iterable i;
            DataObject defPlatform = RIPlatform.findDefaultPlatform(null);
            if (defPlatform == null) {
                throw new IOException("No copy of the Java Card RI installed");
            }
            File defPlatformFile = FileUtil.toFile((FileObject)defPlatform.getPrimaryFile());
            JavacardPlatform defPform = (JavacardPlatform)defPlatform.getLookup().lookup(RIPlatform.class);
            if (defPform == null && !Boolean.getBoolean("PlatformDataObjectTest")) {
                throw new IOException("Default Platform is not an instance of RIPlatform");
            }
            if (Boolean.getBoolean("PlatformDataObjectTest") && (i = Utils.findAllRegisteredJavacardPlatformDataObjects()).iterator().hasNext()) {
                for (DataObject d : i) {
                    if (d.getLookup().lookup(JavacardPlatform.class) == null) continue;
                    defPform = (JavacardPlatform)d.getLookup().lookup(JavacardPlatform.class);
                }
            }
            p.put((Object)"javacard.ri.properties.path", (Object)defPlatformFile.getAbsolutePath());
            if (defPform instanceof RIPlatform) {
                p.put((Object)"javacard.ri.home", (Object)((RIPlatform)defPform).getHome().getAbsolutePath());
            }
            PropertiesAdapter adap = (PropertiesAdapter)defPlatform.getLookup().lookup(PropertiesAdapter.class);
            assert (adap != null) : "No properties adapter from default javacard platform";
            p = new MergeProperties(adap.asProperties(), (ObservableProperties)p);
        }
        return p;
    }

    public static RIPlatform createPlatform(ObservableProperties p, DataObject caller) throws IOException {
        return new RIPlatform((Properties)p);
    }
}

