/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentManager;
import org.netbeans.modules.javaee.wildfly.util.WildFlyProperties;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class WildflyTabVisualPanel
extends JPanel {
    private final transient WildFlyProperties targetData;
    private final transient WildflyDeploymentManager dm;
    private final Set listeners = new HashSet(1);
    private JTextField configFile;
    private JLabel description;
    private JButton openInstanceDirectorySelector;
    private JLabel parentDirectoryLabel;
    private JLabel spaceHack;

    public WildflyTabVisualPanel(DeploymentManager dm) {
        this.dm = (WildflyDeploymentManager)dm;
        this.targetData = new WildFlyProperties(this.dm);
        this.initComponents();
        this.configFile.setText(this.targetData.getServerProfile());
        this.configFile.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                WildflyTabVisualPanel.this.locationChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                WildflyTabVisualPanel.this.locationChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                WildflyTabVisualPanel.this.locationChanged();
            }
        });
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(WildflyTabVisualPanel.class, (String)"StepName_EnterDomainDirectory");
    }

    String getParentDirectory() {
        return this.configFile.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    void locationChanged() {
        this.fireChangeEvent();
    }

    private String browseDomainLocation() {
        String insLocation = null;
        JFileChooser chooser = new JFileChooser();
        this.decorateChooser(chooser, this.configFile.getText(), NbBundle.getMessage(WildflyTabVisualPanel.class, (String)"LBL_Choose_Domain"));
        int returnValue = chooser.showDialog(this, NbBundle.getMessage(WildflyTabVisualPanel.class, (String)"LBL_Choose_Button"));
        if (returnValue == 0) {
            insLocation = chooser.getSelectedFile().getAbsolutePath();
        }
        return insLocation;
    }

    void decorateChooser(JFileChooser chooser, String fname, String title) {
        chooser.setDialogTitle(title);
        chooser.setDialogType(2);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "";
            }
        });
        chooser.setApproveButtonMnemonic(NbBundle.getMessage(WildflyTabVisualPanel.class, (String)"Choose_Button_Mnemonic").charAt(0));
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setApproveButtonToolTipText(NbBundle.getMessage(WildflyTabVisualPanel.class, (String)"LBL_Chooser_Name"));
        chooser.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WildflyTabVisualPanel.class, (String)"LBL_Chooser_Name"));
        chooser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WildflyTabVisualPanel.class, (String)"LBL_Chooser_Name"));
        if (null != fname && fname.length() > 0) {
            File sel = new File(fname);
            if (sel.isDirectory()) {
                chooser.setCurrentDirectory(sel);
            } else {
                chooser.setSelectedFile(sel);
            }
        }
    }

    private void initComponents() {
        this.description = new JLabel();
        this.parentDirectoryLabel = new JLabel();
        this.configFile = new JTextField();
        this.openInstanceDirectorySelector = new JButton();
        this.spaceHack = new JLabel();
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/javaee/wildfly/customizer/Bundle");
        this.description.setText(bundle.getString("TXT_instanceDirectoryDescription2"));
        this.description.setEnabled(false);
        this.description.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.description, gridBagConstraints);
        this.parentDirectoryLabel.setLabelFor(this.configFile);
        Mnemonics.setLocalizedText((JLabel)this.parentDirectoryLabel, (String)NbBundle.getMessage(WildflyTabVisualPanel.class, (String)"LBL_ParentFolder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 6, 6);
        this.add((Component)this.parentDirectoryLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 6, 6);
        this.add((Component)this.configFile, gridBagConstraints);
        this.configFile.getAccessibleContext().setAccessibleDescription(bundle.getString("DSC_instanceDirectory"));
        Mnemonics.setLocalizedText((AbstractButton)this.openInstanceDirectorySelector, (String)NbBundle.getMessage(WildflyTabVisualPanel.class, (String)"LBL_openInstanceDirectorySelector"));
        this.openInstanceDirectorySelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WildflyTabVisualPanel.this.openInstanceDirectorySelectorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 6, 0);
        this.add((Component)this.openInstanceDirectorySelector, gridBagConstraints);
        this.openInstanceDirectorySelector.getAccessibleContext().setAccessibleDescription(bundle.getString("DSC_openInstanceDirectorySelector"));
        this.spaceHack.setEnabled(false);
        this.spaceHack.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.spaceHack, gridBagConstraints);
    }

    private void openInstanceDirectorySelectorActionPerformed(ActionEvent evt) {
        String val = this.browseDomainLocation();
        this.dm.getInstanceProperties().setProperty("config_file", val);
        if (null != val && val.length() >= 1) {
            this.configFile.setText(val);
        }
    }
}

