/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.ide;

import java.io.File;
import java.io.IOException;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.api.AppChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.api.DeploymentChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DeploymentContext;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment2;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentManager;
import org.netbeans.modules.javaee.wildfly.ide.WildflyDeploymentStatus;
import org.netbeans.modules.javaee.wildfly.ide.WildflyProgressObject;
import org.netbeans.modules.javaee.wildfly.ide.commands.WildflyExplodedDeployer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class WildflyIncrementalDeployment
extends IncrementalDeployment
implements IncrementalDeployment2 {
    private final WildflyDeploymentManager dm;
    private final File deploymentDir;
    private final WildflyExplodedDeployer deployer;

    public WildflyIncrementalDeployment(WildflyDeploymentManager dm) {
        String dir;
        this.dm = dm;
        this.deployer = new WildflyExplodedDeployer(dm);
        try {
            dir = dm.getClient().getDeploymentDirectory();
        }
        catch (IOException ex) {
            dir = null;
        }
        this.deploymentDir = dir != null && !dir.isEmpty() ? new File(dir) : null;
    }

    public ProgressObject initialDeploy(Target target, J2eeModule app, ModuleConfiguration configuration, File dir) {
        return this.deployer.deploy(target, app.getType(), dir);
    }

    public boolean canFileDeploy(Target target, J2eeModule deployable) {
        return deployable != null && !J2eeModule.Type.CAR.equals(deployable.getType()) && !J2eeModule.Type.RAR.equals(deployable.getType()) && this.deploymentDir != null && this.deploymentDir.exists() && this.deploymentDir.isDirectory();
    }

    public File getDirectoryForNewApplication(Target target, J2eeModule app, ModuleConfiguration configuration) {
        String baseName = app.getUrl();
        if (baseName.indexOf(File.separatorChar) >= 0) {
            baseName = baseName.substring(baseName.lastIndexOf(File.separatorChar) + 1, baseName.length());
        }
        String extension = this.getExtension(app.getType());
        try {
            if (app.getArchive() != null) {
                if (baseName.isEmpty()) {
                    baseName = app.getArchive().getNameExt();
                }
                extension = '.' + app.getArchive().getExt();
            }
            baseName = this.addExtension(baseName, extension);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return new File(this.deploymentDir, baseName);
    }

    private String addExtension(String baseName, String extension) {
        if (!baseName.endsWith(extension)) {
            return baseName + extension;
        }
        return baseName;
    }

    private String getExtension(J2eeModule.Type type) {
        if (J2eeModule.Type.WAR == type) {
            return ".war";
        }
        if (J2eeModule.Type.RAR == type) {
            return ".rar";
        }
        if (J2eeModule.Type.EJB == type) {
            return ".jar";
        }
        if (J2eeModule.Type.EAR == type) {
            return ".ear";
        }
        return ".jar";
    }

    public File getDirectoryForNewModule(File appDir, String uri, J2eeModule module, ModuleConfiguration configuration) {
        try {
            if (appDir != null && appDir.exists() && appDir.isDirectory()) {
                return new File(appDir, module.getArchive().getNameExt());
            }
            return new File(this.deploymentDir, module.getArchive().getNameExt());
        }
        catch (IOException ex) {
            return null;
        }
    }

    public File getDirectoryForModule(TargetModuleID module) {
        return new File(this.deploymentDir, this.appendModuleToPath("", module));
    }

    private String appendModuleToPath(String path, TargetModuleID module) {
        String relPath = module.getModuleID() + File.separatorChar + path;
        if (module.getParentTargetModuleID() == null) {
            return relPath;
        }
        return this.appendModuleToPath(path, module.getParentTargetModuleID());
    }

    public ProgressObject initialDeploy(Target target, DeploymentContext context) {
        return this.initialDeploy(target, context.getModule(), null, context.getModuleFile());
    }

    public ProgressObject deployOnSave(TargetModuleID module, DeploymentChangeDescriptor desc) {
        try {
            File moduleFile = new File(this.dm.getClient().getDeploymentDirectory(), module.getModuleID());
            return this.deployer.redeploy(module, moduleFile);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public ProgressObject incrementalDeploy(TargetModuleID module, AppChangeDescriptor changes) {
        boolean redeploy;
        boolean bl = redeploy = changes.classesChanged() || changes.descriptorChanged() || changes.ejbsChanged() || changes.manifestChanged() || changes.serverDescriptorChanged();
        if (changes instanceof DeploymentChangeDescriptor) {
            DeploymentChangeDescriptor deploymentChanges = (DeploymentChangeDescriptor)changes;
            boolean bl2 = redeploy = redeploy || deploymentChanges.serverResourcesChanged();
        }
        if (!redeploy) {
            WildflyProgressObject progress = new WildflyProgressObject(module);
            progress.fireProgressEvent(module, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, NbBundle.getMessage(WildflyIncrementalDeployment.class, (String)"MSG_Deployment_Completed")));
            return progress;
        }
        return null;
    }

    public boolean isDeployOnSaveSupported() {
        return true;
    }

    public ProgressObject incrementalDeploy(TargetModuleID module, DeploymentContext context) {
        return this.dm.redeploy(new TargetModuleID[]{module}, context);
    }
}

