/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.ide.ui;

import java.awt.Component;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.javaee.wildfly.ide.ui.AddServerPropertiesVisualPanel;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyInstantiatingIterator;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyPluginProperties;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyPluginUtils;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AddServerPropertiesPanel
implements WizardDescriptor.Panel,
ChangeListener {
    private WizardDescriptor wizard;
    private AddServerPropertiesVisualPanel component;
    private WildflyInstantiatingIterator instantiatingIterator;
    private final transient Set listeners = new HashSet(1);

    public AddServerPropertiesPanel(WildflyInstantiatingIterator instantiatingIterator) {
        this.instantiatingIterator = instantiatingIterator;
    }

    public boolean isValid() {
        AddServerPropertiesVisualPanel panel = (AddServerPropertiesVisualPanel)this.getComponent();
        String host = panel.getHost();
        String port = panel.getPort();
        String adminPort = panel.getManagementPort();
        if (panel.isLocalServer()) {
            String path = panel.getDomainPath();
            File serverDirectory = new File(WildflyPluginProperties.getInstance().getInstallLocation());
            if (path.length() < 1) {
                this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(AddServerPropertiesPanel.class, (String)"MSG_SpecifyDomainPath"));
                return false;
            }
            if (!WildflyPluginUtils.isGoodJBInstanceLocation(serverDirectory, new File(path))) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerPropertiesPanel.class, (String)"MSG_WrongDomainPath"));
                return false;
            }
            if (host.length() < 1) {
                this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(AddServerPropertiesPanel.class, (String)"MSG_EnterHost"));
                return false;
            }
            for (String url : InstanceProperties.getInstanceList()) {
                InstanceProperties props = InstanceProperties.getInstanceProperties((String)url);
                if (props == null) continue;
                String property = null;
                try {
                    property = props.getProperty("server-dir");
                }
                catch (IllegalStateException ex) {
                    // empty catch block
                }
                if (property != null) continue;
            }
            try {
                Integer.parseInt(port);
            }
            catch (Exception e) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerPropertiesPanel.class, (String)"MSG_InvalidPort"));
                return false;
            }
            try {
                Integer.parseInt(adminPort);
            }
            catch (Exception e) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerPropertiesPanel.class, (String)"MSG_InvalidPort"));
                return false;
            }
        }
        if (host.length() < 1) {
            this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(AddServerPropertiesPanel.class, (String)"MSG_EnterHost"));
            return false;
        }
        if (port.length() < 1) {
            this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(AddServerPropertiesPanel.class, (String)"MSG_EnterPort"));
            return false;
        }
        this.wizard.putProperty("WizardPanel_errorMessage", null);
        this.wizard.putProperty("WizardPanel_infoMessage", null);
        this.instantiatingIterator.setHost(host);
        this.instantiatingIterator.setPort(port);
        this.instantiatingIterator.setAdminPort(adminPort);
        this.instantiatingIterator.setServer(panel.getDomain());
        this.instantiatingIterator.setServerPath(panel.getDomainPath());
        this.instantiatingIterator.setDeployDir(WildflyPluginUtils.getDeployDir(panel.getDomainPath()));
        return true;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new AddServerPropertiesVisualPanel();
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    @Override
    public void stateChanged(ChangeEvent ev) {
        this.fireChangeEvent(ev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent(ChangeEvent ev) {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    public void readSettings(Object settings) {
        if (this.wizard == null) {
            this.wizard = (WizardDescriptor)settings;
        }
    }

    public void storeSettings(Object settings) {
    }

    public HelpCtx getHelp() {
        return new HelpCtx("j2eeplugins_registering_app_server_jboss_properties");
    }

    void installLocationChanged() {
        if (this.component != null) {
            this.component.installLocationChanged();
        }
    }
}

