/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.ide.ui;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.filesystems.JarFileSystem;

public class WildflyPluginUtils {
    public static final Version JBOSS_7_0_0 = new Version("7.0.0");
    public static final Version EAP_6_3_0 = new Version("7.4.0");
    public static final Version EAP_6_4_0 = new Version("7.5.0");
    public static final Version WILDFLY_8_0_0 = new Version("8.0.0");
    public static final Version WILDFLY_8_1_0 = new Version("8.1.0");
    public static final Version WILDFLY_8_2_0 = new Version("8.2.0");
    public static final Version WILDFLY_9_0_0 = new Version("9.0.0");
    public static final Version WILDFLY_10_0_0 = new Version("10.0.0");
    private static final Logger LOGGER = Logger.getLogger(WildflyPluginUtils.class.getName());
    public static final String LIB = "lib" + File.separatorChar;
    public static final String MODULES_BASE = "modules" + File.separatorChar + "system" + File.separatorChar + "layers" + File.separatorChar + "base" + File.separatorChar;
    public static final String CLIENT = "client" + File.separatorChar;
    public static final String COMMON = "common" + File.separatorChar;
    private static List<String> domainRequirements;
    private static List<String> serverRequirements7x;

    private static synchronized List<String> getDomainRequirements8x() {
        if (domainRequirements == null) {
            domainRequirements = new ArrayList<String>(11);
            Collections.addAll(domainRequirements, "configuration");
        }
        return domainRequirements;
    }

    private static synchronized List<String> getServerRequirements8x() {
        if (serverRequirements7x == null) {
            serverRequirements7x = new ArrayList<String>(6);
            Collections.addAll(serverRequirements7x, "bin", "modules", "jboss-modules.jar");
        }
        return serverRequirements7x;
    }

    @NonNull
    public static String getModulesBase(String serverRoot) {
        return MODULES_BASE;
    }

    public static final String getDefaultConfigurationFile(String installDir) {
        return installDir + File.separatorChar + "standalone" + File.separatorChar + "configuration" + File.separatorChar + "standalone-full.xml";
    }

    public static Map getRegisteredDomains(String serverLocation) {
        HashMap<String, String> result = new HashMap<String, String>();
        File serverDirectory = new File(serverLocation);
        if (WildflyPluginUtils.isGoodJBServerLocation(serverDirectory)) {
            String[] files = new String[]{"standalone"};
            File file = serverDirectory;
            if (files != null) {
                for (String file1 : files) {
                    String path = file.getAbsolutePath() + File.separatorChar + file1;
                    if (!WildflyPluginUtils.isGoodJBInstanceLocation(serverDirectory, new File(path))) continue;
                    result.put(file1, path);
                }
            }
        }
        return result;
    }

    private static boolean isGoodJBInstanceLocation(File candidate, List<String> requirements) {
        return null != candidate && candidate.exists() && candidate.canRead() && candidate.isDirectory() && WildflyPluginUtils.hasRequiredChildren(candidate, requirements);
    }

    private static boolean isGoodJBInstanceLocation8x(File serverDir, File candidate) {
        return WildflyPluginUtils.isGoodJBInstanceLocation(candidate, WildflyPluginUtils.getDomainRequirements8x());
    }

    public static boolean isGoodJBInstanceLocation(File serverDir, File candidate) {
        Version version = WildflyPluginUtils.getServerVersion(serverDir);
        if (version == null || !"8".equals(version.getMajorNumber())) {
            return WildflyPluginUtils.isGoodJBInstanceLocation8x(serverDir, candidate);
        }
        return "8".equals(version.getMajorNumber()) && WildflyPluginUtils.isGoodJBInstanceLocation8x(serverDir, candidate);
    }

    private static boolean isGoodJBServerLocation(File candidate, List<String> requirements) {
        return null != candidate && candidate.exists() && candidate.canRead() && candidate.isDirectory() && WildflyPluginUtils.hasRequiredChildren(candidate, requirements);
    }

    private static boolean isGoodJBServerLocation8x(File candidate) {
        return WildflyPluginUtils.isGoodJBServerLocation(candidate, WildflyPluginUtils.getServerRequirements8x());
    }

    public static boolean isGoodJBServerLocation(File candidate) {
        Version version = WildflyPluginUtils.getServerVersion(candidate);
        if (version == null || !"8".equals(version.getMajorNumber())) {
            return WildflyPluginUtils.isGoodJBServerLocation8x(candidate);
        }
        return "8".equals(version.getMajorNumber()) && WildflyPluginUtils.isGoodJBServerLocation8x(candidate);
    }

    private static boolean hasRequiredChildren(File candidate, List<String> requiredChildren) {
        if (null == candidate || null == candidate.list()) {
            return false;
        }
        if (null == requiredChildren) {
            return true;
        }
        for (String next : requiredChildren) {
            File test = new File(candidate.getPath() + File.separatorChar + next);
            if (test.exists()) continue;
            return false;
        }
        return true;
    }

    public static String getDeployDir(String domainDir) {
        return domainDir + File.separatorChar + "deployments";
    }

    public static String getHTTPConnectorPort(String configFile) {
        String defaultPort = "8080";
        return defaultPort;
    }

    public static String getManagementConnectorPort(String configFile) {
        String defaultPort = "9990";
        return defaultPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortFree(int port) {
        ServerSocket soc = null;
        try {
            soc = new ServerSocket(port);
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (soc != null) {
                try {
                    soc.close();
                }
                catch (IOException ex) {}
            }
        }
        return true;
    }

    @CheckForNull
    public static Version getServerVersion(File serverPath) {
        File serverDir;
        File[] files;
        assert (serverPath != null) : "Can't determine version with null server path";
        Version version = WildflyPluginUtils.getProductVersion(serverPath);
        if (version == null && (files = (serverDir = new File(serverPath, WildflyPluginUtils.getModulesBase(serverPath.getAbsolutePath()) + "org/jboss/as/version/main")).listFiles(new VersionJarFileFilter())) != null) {
            File jarFile;
            File[] arr$ = files;
            int len$ = arr$.length;
            for (int i$ = 0; !(i$ >= len$ || (jarFile = arr$[i$]).getName().startsWith("jboss-as-version") && (version = WildflyPluginUtils.getVersion(jarFile)) != null); ++i$) {
            }
        }
        if (version == null) {
            return WILDFLY_8_0_0;
        }
        return version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    public static Version getProductVersion(File serverPath) {
        assert (serverPath != null) : "Can't determine version with null server path";
        String productConf = WildflyPluginUtils.getProductConf(serverPath);
        if (productConf == null) return null;
        try (FileReader reader = new FileReader(productConf);){
            Properties props = new Properties();
            props.load(reader);
            String slot = props.getProperty("slot");
            if (slot == null) return null;
            File manifestFile = new File(serverPath, WildflyPluginUtils.getModulesBase(serverPath.getAbsolutePath()) + "org.jboss.as.product".replace('.', File.separatorChar) + File.separatorChar + slot + File.separatorChar + "dir" + File.separatorChar + "META-INF" + File.separatorChar + "MANIFEST.MF");
            FileInputStream stream = new FileInputStream(manifestFile);
            Manifest manifest = new Manifest(stream);
            Version version = new Version(manifest.getMainAttributes().getValue("JBoss-Product-Release-Version"));
            return version;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String getProductConf(File serverPath) {
        String defaultVal = serverPath.getAbsolutePath() + File.separatorChar + "bin" + File.separatorChar + "product.conf";
        String env = System.getenv("JBOSS_PRODUCT_CONF");
        if (env == null) {
            env = defaultVal;
        }
        return env;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    public static boolean isWildFly(File serverPath) {
        assert (serverPath != null) : "Can't determine version with null server path";
        String productConf = WildflyPluginUtils.getProductConf(serverPath);
        if (productConf == null) return true;
        try (FileReader reader = new FileReader(productConf);){
            Properties props = new Properties();
            props.load(reader);
            String slot = props.getProperty("slot");
            if (slot == null) return true;
            File manifestFile = new File(serverPath, WildflyPluginUtils.getModulesBase(serverPath.getAbsolutePath()) + "org.jboss.as.product".replace('.', File.separatorChar) + File.separatorChar + slot + File.separatorChar + "dir" + File.separatorChar + "META-INF" + File.separatorChar + "MANIFEST.MF");
            FileInputStream stream = new FileInputStream(manifestFile);
            Manifest manifest = new Manifest(stream);
            String productName = manifest.getMainAttributes().getValue("JBoss-Product-Release-Name");
            if (productName == null || productName.isEmpty()) {
                productName = manifest.getMainAttributes().getValue("JBoss-Project-Release-Name");
            }
            boolean bl = productName == null || !productName.toLowerCase().contains("eap");
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    public static boolean isWildFlyServlet(File serverPath) {
        assert (serverPath != null) : "Can't determine version with null server path";
        String productConf = WildflyPluginUtils.getProductConf(serverPath);
        if (productConf == null) return false;
        try (FileReader reader = new FileReader(productConf);){
            Properties props = new Properties();
            props.load(reader);
            String slot = props.getProperty("slot");
            if (slot == null) return false;
            File manifestFile = new File(serverPath, WildflyPluginUtils.getModulesBase(serverPath.getAbsolutePath()) + "org.jboss.as.product".replace('.', File.separatorChar) + File.separatorChar + slot + File.separatorChar + "dir" + File.separatorChar + "META-INF" + File.separatorChar + "MANIFEST.MF");
            FileInputStream stream = new FileInputStream(manifestFile);
            Manifest manifest = new Manifest(stream);
            String productName = manifest.getMainAttributes().getValue("JBoss-Product-Release-Name");
            if (productName == null || productName.isEmpty()) {
                productName = manifest.getMainAttributes().getValue("JBoss-Project-Release-Name");
            }
            boolean bl = productName != null && (productName.contains("WildFly Web Lite") || productName.contains("WildFly Servlet"));
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static Version getVersion(File systemJarFile) {
        if (!systemJarFile.exists()) {
            return null;
        }
        try {
            JarFileSystem systemJar = new JarFileSystem();
            systemJar.setJarFile(systemJarFile);
            Attributes attributes = systemJar.getManifest().getMainAttributes();
            String version = attributes.getValue("Specification-Version");
            if (version != null) {
                return new Version(version);
            }
            return null;
        }
        catch (PropertyVetoException | IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
    }

    public static final class Version
    implements Comparable<Version> {
        private String majorNumber = "0";
        private String minorNumber = "0";
        private String microNumber = "0";
        private String update = "";

        public Version(String version) {
            assert (version != null) : "Version can't be null";
            String[] tokens = version.split("\\.");
            if (tokens.length >= 4) {
                this.update = tokens[3];
            }
            if (tokens.length >= 3) {
                this.microNumber = tokens[2];
            }
            if (tokens.length >= 2) {
                this.minorNumber = tokens[1];
            }
            this.majorNumber = tokens[0];
        }

        public String getMajorNumber() {
            return this.majorNumber;
        }

        public String getMinorNumber() {
            return this.minorNumber;
        }

        public String getMicroNumber() {
            return this.microNumber;
        }

        public String getUpdate() {
            return this.update;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Version other = (Version)obj;
            if (!(this.majorNumber == other.majorNumber || this.majorNumber != null && this.majorNumber.equals(other.majorNumber))) {
                return false;
            }
            if (!(this.minorNumber == other.minorNumber || this.minorNumber != null && this.minorNumber.equals(other.minorNumber))) {
                return false;
            }
            if (!(this.microNumber == other.microNumber || this.microNumber != null && this.microNumber.equals(other.microNumber))) {
                return false;
            }
            return this.update == other.update || this.update != null && this.update.equals(other.update);
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + (this.majorNumber != null ? this.majorNumber.hashCode() : 0);
            hash = 17 * hash + (this.minorNumber != null ? this.minorNumber.hashCode() : 0);
            hash = 17 * hash + (this.microNumber != null ? this.microNumber.hashCode() : 0);
            hash = 17 * hash + (this.update != null ? this.update.hashCode() : 0);
            return hash;
        }

        @Override
        public int compareTo(Version o) {
            int comparison = this.compareToIgnoreUpdate(o);
            if (comparison != 0) {
                return comparison;
            }
            return this.update.compareTo(o.update);
        }

        public int compareToIgnoreUpdate(Version o) {
            if (o == null) {
                return 1;
            }
            int comparison = this.compare(this.majorNumber, o.majorNumber);
            if (comparison != 0) {
                return comparison;
            }
            comparison = this.compare(this.minorNumber, o.minorNumber);
            if (comparison != 0) {
                return comparison;
            }
            return this.compare(this.microNumber, o.microNumber);
        }

        private int compare(String number1, String number2) {
            if (number1.length() != number2.length()) {
                try {
                    Integer i1 = Integer.parseInt(number1);
                    Integer i2 = Integer.parseInt(number2);
                    return i1.compareTo(i2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return number1.compareTo(number2);
        }
    }

    private static class VersionJarFileFilter
    implements FilenameFilter {
        private VersionJarFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar") && (name.startsWith("jboss-as-version") || name.startsWith("wildfly-version"));
        }
    }
}

