/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.nodes.actions;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentManager;
import org.netbeans.modules.javaee.wildfly.nodes.actions.UndeployModuleCookie;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class UndeployModuleCookieImpl
implements UndeployModuleCookie {
    private static final RequestProcessor PROCESSOR = new RequestProcessor("JBoss undeploy", 1);
    private final String fileName;
    private final Lookup lookup;
    private final ModuleType type;
    private boolean isRunning;

    public UndeployModuleCookieImpl(String fileName, Lookup lookup) {
        this(fileName, ModuleType.EJB, lookup);
    }

    public UndeployModuleCookieImpl(String fileName, ModuleType type, Lookup lookup) {
        this.lookup = lookup;
        this.fileName = fileName;
        this.type = type;
        this.isRunning = false;
    }

    @Override
    public RequestProcessor.Task undeploy() {
        final WildflyDeploymentManager dm = (WildflyDeploymentManager)this.lookup.lookup(WildflyDeploymentManager.class);
        String nameWoExt = this.fileName.substring(0, this.fileName.lastIndexOf(46));
        final ProgressHandle handle = ProgressHandle.createHandle((String)NbBundle.getMessage(UndeployModuleCookieImpl.class, (String)"LBL_UndeployProgress", (Object)nameWoExt));
        Runnable r = new Runnable(){

            @Override
            public void run() {
                UndeployModuleCookieImpl.this.isRunning = true;
                try {
                    dm.getClient().undeploy(UndeployModuleCookieImpl.this.fileName);
                }
                catch (IOException ex) {
                    Logger.getLogger(UndeployModuleCookieImpl.class.getName()).log(Level.INFO, null, ex);
                }
                handle.finish();
                UndeployModuleCookieImpl.this.isRunning = false;
            }
        };
        handle.start();
        return PROCESSOR.post(r);
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }
}

