/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.spi.debugger.jpda.EditorContext;

public class ExpressionPool {
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.step");
    private Map<ExpressionLocation, Expression> expressions = new HashMap<ExpressionLocation, Expression>();

    ExpressionPool() {
    }

    public synchronized Expression getExpressionAt(Location loc, String url) {
        try {
            ExpressionLocation exprLocation = new ExpressionLocation(LocationWrapper.method(loc), LocationWrapper.lineNumber(loc));
            if (!this.expressions.containsKey(exprLocation)) {
                LinkedHashSet<Location> lineLocationsInExpression = new LinkedHashSet<Location>();
                lineLocationsInExpression.add(loc);
                Expression expr = this.createExpressionAt(loc, url, lineLocationsInExpression);
                this.expressions.put(exprLocation, expr);
                Iterator locIt = lineLocationsInExpression.iterator();
                locIt.next();
                while (locIt.hasNext()) {
                    loc = (Location)locIt.next();
                    exprLocation = new ExpressionLocation(LocationWrapper.method(loc), LocationWrapper.lineNumber(loc));
                    this.expressions.put(exprLocation, expr);
                }
            }
            return this.expressions.get(exprLocation);
        }
        catch (InternalExceptionWrapper ex) {
            logger.log(Level.INFO, "No expression at '" + url + "', JDI internal error", ex);
            return null;
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUnusedExpressions(ThreadReference thr) {
        ExpressionPool expressionPool = this;
        synchronized (expressionPool) {
            if (this.expressions.size() == 0) {
                return;
            }
        }
        try {
            List<StackFrame> stackFrames = ThreadReferenceWrapper.frames(thr);
            ExpressionPool expressionPool2 = this;
            synchronized (expressionPool2) {
                Iterator<ExpressionLocation> locIt = this.expressions.keySet().iterator();
                while (locIt.hasNext()) {
                    ExpressionLocation exprLoc = locIt.next();
                    Method method = exprLoc.getMethod();
                    for (StackFrame sf : stackFrames) {
                        if (!method.equals(LocationWrapper.method(StackFrameWrapper.location(sf)))) continue;
                        method = null;
                        break;
                    }
                    if (method == null) continue;
                    locIt.remove();
                }
            }
        }
        catch (InternalExceptionWrapper ex) {
        }
        catch (ObjectCollectedExceptionWrapper ex) {
        }
        catch (VMDisconnectedExceptionWrapper ex) {
        }
        catch (IncompatibleThreadStateException ex) {
        }
        catch (IllegalThreadStateExceptionWrapper ex) {
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            // empty catch block
        }
    }

    synchronized void clear() {
        this.expressions.clear();
    }

    private Expression createExpressionAt(Location loc, String url, final Set<Location> lineLocationsInExpression) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        List<Location> methodLocations;
        VirtualMachine vm = MirrorWrapper.virtualMachine(loc);
        if (!VirtualMachineWrapper.canGetBytecodes(vm)) {
            return null;
        }
        ReferenceType clazzType = LocationWrapper.declaringType(loc);
        Method method = LocationWrapper.method(loc);
        final byte[] bytecodes = MethodWrapper.bytecodes(method);
        byte[] constantPool = null;
        if (VirtualMachineWrapper.canGetConstantPool(vm)) {
            constantPool = ReferenceTypeWrapper.constantPool(clazzType);
        }
        final byte[] theConstantPool = constantPool;
        Session currentSession = DebuggerManager.getDebuggerManager().getCurrentSession();
        final String language = currentSession == null ? null : currentSession.getCurrentLanguage();
        int line = LocationWrapper.lineNumber(loc, language);
        try {
            methodLocations = MethodWrapper.allLineLocations(method, language, null);
        }
        catch (AbsentInformationException aiex) {
            logger.log(Level.FINE, aiex.getLocalizedMessage());
            return null;
        }
        final int[] boundingLines = new int[2];
        final int[][] codeIndexIntervalsPtr = new int[1][];
        EditorContext.Operation[] ops = EditorContextBridge.getContext().getOperations(url, line, new EditorContext.BytecodeProvider(){

            public byte[] constantPool() {
                return theConstantPool;
            }

            public byte[] byteCodes() {
                return bytecodes;
            }

            public int[] indexAtLines(int startLine, int endLine) {
                int[] indexes = ExpressionPool.getIndexesAtLines(methodLocations, language, startLine, endLine, bytecodes.length, lineLocationsInExpression);
                boundingLines[0] = startLine;
                boundingLines[1] = endLine;
                codeIndexIntervalsPtr[0] = indexes;
                return indexes;
            }
        });
        logger.fine("Operations:");
        if (ops == null) {
            logger.log(Level.FINE, "Unsuccessfull bytecode matching.");
            return null;
        }
        if (ops.length == 0) {
            return null;
        }
        if (logger.isLoggable(Level.FINE)) {
            for (EditorContext.Operation op : ops) {
                logger.fine("  " + op.getMethodName() + "():" + op.getMethodStartPosition().getLine() + ", bci = " + op.getBytecodeIndex());
            }
        }
        Location[] locations = new Location[ops.length];
        for (int i = 0; i < ops.length; ++i) {
            int codeIndex = ops[i].getBytecodeIndex();
            locations[i] = MethodWrapper.locationOfCodeIndex(method, codeIndex);
            if (locations[i] != null) continue;
            logger.log(Level.FINE, "Location of the operation not found.");
            return null;
        }
        Expression expr = new Expression(new ExpressionLocation(method, line), ops, locations, new Interval(boundingLines[0], boundingLines[1]), codeIndexIntervalsPtr[0]);
        return expr;
    }

    private static int[] getIndexesAtLines(List<Location> allLocations, String language, int startLine, int endLine, int methodEndIndex, Set<Location> lineLocationsInExpression) {
        int startlocline = 0;
        try {
            Location startLocation;
            int firstLine = LocationWrapper.lineNumber(allLocations.get(0), language);
            while ((startLocation = ExpressionPool.getLocationOfLine(allLocations, language, startLine - startlocline++)) == null && startLine - (startlocline - 1) >= firstLine) {
            }
        }
        catch (VMDisconnectedExceptionWrapper e) {
            return null;
        }
        catch (InternalExceptionWrapper e) {
            return null;
        }
        int endlocline = endLine > (startLine -= startlocline - 1) ? 0 : 1;
        endLine += endlocline;
        ArrayList<int[]> indexes = new ArrayList<int[]>();
        int startIndex = -1;
        Location locInExpression = null;
        try {
            for (Location l : allLocations) {
                int line = LocationWrapper.lineNumber(l, language);
                if (startIndex == -1 && startLine <= line && line < endLine) {
                    startIndex = (int)LocationWrapper.codeIndex(l);
                    locInExpression = l;
                    continue;
                }
                if (startIndex < 0) continue;
                int ci = (int)LocationWrapper.codeIndex(l);
                lineLocationsInExpression.add(locInExpression);
                if (startLine <= line && line <= endLine - endlocline) {
                    indexes.add(new int[]{startIndex, ci});
                    startIndex = ci;
                    locInExpression = l;
                    continue;
                }
                indexes.add(new int[]{startIndex, ci});
                startIndex = -1;
                locInExpression = null;
            }
        }
        catch (VMDisconnectedExceptionWrapper e) {
            return null;
        }
        catch (InternalExceptionWrapper e) {
            return null;
        }
        if (indexes.size() == 0) {
            if (startIndex >= 0) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("getIndexesAtLines(" + startLine + ", " + endLine + ") = " + Arrays.toString(new int[]{startIndex, methodEndIndex}));
                }
                lineLocationsInExpression.add(locInExpression);
                return new int[]{startIndex, methodEndIndex};
            }
            return null;
        }
        if (indexes.size() == 1) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("getIndexesAtLines(" + startLine + ", " + endLine + ") = " + Arrays.toString((int[])indexes.get(0)));
            }
            return (int[])indexes.get(0);
        }
        int[] arr = new int[2 * indexes.size()];
        for (int i = 0; i < indexes.size(); ++i) {
            arr[2 * i] = ((int[])indexes.get(i))[0];
            arr[2 * i + 1] = ((int[])indexes.get(i))[1];
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getIndexesAtLines(" + startLine + ", " + endLine + ") = " + Arrays.toString(arr));
        }
        return arr;
    }

    private static Location getLocationOfLine(List<Location> allLocations, String language, int line) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        for (Location l : allLocations) {
            if (LocationWrapper.lineNumber(l, language) != line) continue;
            return l;
        }
        return null;
    }

    public static final class Interval {
        private int i1;
        private int i2;

        Interval(int i1, int i2) {
            this.i1 = i1;
            this.i2 = i2;
        }

        public int begin() {
            return this.i1;
        }

        public int end() {
            return this.i2;
        }

        public boolean contains(int i) {
            return this.i1 <= i && i <= this.i2;
        }
    }

    public static final class OperationLocation {
        private EditorContext.Operation op;
        private Location loc;
        private int index;

        OperationLocation(EditorContext.Operation op, Location loc, int index) {
            this.op = op;
            this.loc = loc;
            this.index = index;
        }

        public EditorContext.Operation getOperation() {
            return this.op;
        }

        public Location getLocation() {
            return this.loc;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static final class ExpressionLocation {
        private Method method;
        private int line;

        public ExpressionLocation(Method method, int line) {
            this.method = method;
            this.line = line;
        }

        public Method getMethod() {
            return this.method;
        }

        public int getLine() {
            return this.line;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ExpressionLocation)) {
                return false;
            }
            return ((ExpressionLocation)obj).line == this.line && ((ExpressionLocation)obj).method.equals(this.method);
        }

        public int hashCode() {
            return this.method.hashCode() + this.line;
        }
    }

    public static final class Expression {
        private ExpressionLocation location;
        private EditorContext.Operation[] operations;
        private Location[] locations;
        private Interval lines;
        private int[] codeIndexIntervals;

        Expression(ExpressionLocation location, EditorContext.Operation[] operations, Location[] locations, Interval lines, int[] codeIndexIntervals) {
            this.location = location;
            this.operations = operations;
            this.locations = locations;
            this.lines = lines;
            this.codeIndexIntervals = codeIndexIntervals;
        }

        public EditorContext.Operation[] getOperations() {
            return this.operations;
        }

        public Location[] getLocations() {
            return this.locations;
        }

        public Interval getInterval() {
            return this.lines;
        }

        int[] getCodeIndexIntervals() {
            return this.codeIndexIntervals;
        }

        public int findNextOperationIndex(int codeIndex) {
            for (int i = 0; i < this.operations.length; ++i) {
                int operationIndex = this.operations[i].getBytecodeIndex();
                if (operationIndex <= codeIndex) continue;
                return i;
            }
            return -1;
        }

        int[] findNextOperationIndexes(int codeIndex) {
            for (int i = 0; i < this.operations.length; ++i) {
                List nextOperations;
                int operationIndex = this.operations[i].getBytecodeIndex();
                if (operationIndex == codeIndex && !(nextOperations = this.operations[i].getNextOperations()).isEmpty()) {
                    int l = nextOperations.size();
                    int[] indexes = new int[l];
                    for (int ni = 0; ni < l; ++ni) {
                        int j;
                        EditorContext.Operation op = (EditorContext.Operation)nextOperations.get(ni);
                        for (j = 0; j < this.operations.length && op != this.operations[j]; ++j) {
                        }
                        indexes[ni] = j < this.operations.length ? j : -1;
                    }
                    return indexes;
                }
                if (operationIndex <= codeIndex) continue;
                return new int[]{i};
            }
            return null;
        }

        OperationLocation[] findNextOperationLocations(int codeIndex) {
            for (int i = 0; i < this.operations.length; ++i) {
                List nextOperations;
                int operationIndex = this.operations[i].getBytecodeIndex();
                if (operationIndex == codeIndex && !(nextOperations = this.operations[i].getNextOperations()).isEmpty()) {
                    int l = nextOperations.size();
                    OperationLocation[] opLocations = new OperationLocation[l];
                    for (int ni = 0; ni < l; ++ni) {
                        Location loc;
                        int j;
                        EditorContext.Operation op = (EditorContext.Operation)nextOperations.get(ni);
                        for (j = 0; j < this.operations.length && op != this.operations[j]; ++j) {
                        }
                        if (j < this.operations.length) {
                            opLocations[ni] = new OperationLocation(this.operations[j], this.locations[j], j);
                            continue;
                        }
                        int ci = op.getBytecodeIndex();
                        try {
                            loc = MethodWrapper.locationOfCodeIndex(this.location.getMethod(), ci);
                        }
                        catch (InternalExceptionWrapper ex) {
                            return null;
                        }
                        catch (VMDisconnectedExceptionWrapper ex) {
                            return null;
                        }
                        if (loc == null) {
                            logger.log(Level.FINE, "Location of the operation not found.");
                            return null;
                        }
                        opLocations[ni] = new OperationLocation(op, loc, -1);
                    }
                    return opLocations;
                }
                if (operationIndex <= codeIndex) continue;
                return new OperationLocation[]{new OperationLocation(this.operations[i], this.locations[i], i)};
            }
            return null;
        }
    }
}

