/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.LazyDebuggerManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class PersistenceManager
implements LazyDebuggerManagerListener {
    private static Reference<PersistenceManager> instanceRef = new WeakReference<Object>(null);
    private Breakpoint[] breakpoints;
    private RequestProcessor.Task saveTask;

    public PersistenceManager() {
        instanceRef = new WeakReference<PersistenceManager>(this);
    }

    public synchronized Breakpoint[] initBreakpoints() {
        Properties p = Properties.getDefault().getProperties("debugger").getProperties("breakpoints");
        Breakpoint[] breakpoints = (Breakpoint[])p.getArray("jpda", (Object[])new Breakpoint[0]);
        for (int i = 0; i < breakpoints.length; ++i) {
            if (breakpoints[i] instanceof LineBreakpoint) {
                LineBreakpoint lb = (LineBreakpoint)breakpoints[i];
                try {
                    FileObject fo = URLMapper.findFileObject((URL)new URL(lb.getURL()));
                    if (fo == null) {
                        Breakpoint[] breakpoints2 = new Breakpoint[breakpoints.length - 1];
                        if (i > 0) {
                            System.arraycopy(breakpoints, 0, breakpoints2, 0, i);
                        }
                        if (i < breakpoints2.length) {
                            System.arraycopy(breakpoints, i + 1, breakpoints2, i, breakpoints2.length - i);
                        }
                        breakpoints = breakpoints2;
                        --i;
                        continue;
                    }
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            breakpoints[i].addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        this.breakpoints = breakpoints;
        return breakpoints;
    }

    public synchronized Breakpoint[] unloadBreakpoints() {
        Breakpoint[] bpts = DebuggerManager.getDebuggerManager().getBreakpoints();
        ArrayList<Breakpoint> unloaded = new ArrayList<Breakpoint>();
        for (Breakpoint b : bpts) {
            if (!(b instanceof JPDABreakpoint)) continue;
            unloaded.add(b);
            b.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        this.breakpoints = null;
        return unloaded.toArray(new Breakpoint[0]);
    }

    public void initWatches() {
    }

    public String[] getProperties() {
        return new String[]{"breakpointsInit", "breakpoints"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointAdded(Breakpoint breakpoint) {
        if (breakpoint instanceof JPDABreakpoint && !((JPDABreakpoint)breakpoint).isHidden()) {
            PersistenceManager persistenceManager = this;
            synchronized (persistenceManager) {
                if (this.breakpoints == null) {
                    return;
                }
                int n = this.breakpoints.length;
                Breakpoint[] newBreakpoints = new Breakpoint[n + 1];
                System.arraycopy(this.breakpoints, 0, newBreakpoints, 0, n);
                newBreakpoints[n] = breakpoint;
                this.breakpoints = newBreakpoints;
                this.storeTheBreakpoints();
            }
            breakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointRemoved(Breakpoint breakpoint) {
        if (breakpoint instanceof JPDABreakpoint && !((JPDABreakpoint)breakpoint).isHidden()) {
            PersistenceManager persistenceManager = this;
            synchronized (persistenceManager) {
                if (this.breakpoints == null) {
                    return;
                }
                int n = this.breakpoints.length;
                for (int i = 0; i < n; ++i) {
                    if (this.breakpoints[i] != breakpoint) continue;
                    Breakpoint[] newBreakpoints = new Breakpoint[n - 1];
                    if (i > 0) {
                        System.arraycopy(this.breakpoints, 0, newBreakpoints, 0, i);
                    }
                    if (i < n - 1) {
                        System.arraycopy(this.breakpoints, i + 1, newBreakpoints, i, n - 1 - i);
                    }
                    --n;
                    this.breakpoints = newBreakpoints;
                }
                this.storeTheBreakpoints();
            }
            breakpoint.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof JPDABreakpoint) {
            BreakpointsReader r;
            if ("lineNumber".equals(evt.getPropertyName()) && (r = PersistenceManager.findBreakpointsReader()) != null) {
                r.storeCachedClassName((JPDABreakpoint)evt.getSource(), null);
            }
            if ("validity".equals(evt.getPropertyName())) {
                return;
            }
            this.storeTheBreakpoints();
        }
    }

    static BreakpointsReader findBreakpointsReader() {
        BreakpointsReader breakpointsReader = null;
        for (Properties.Reader r : DebuggerManager.getDebuggerManager().lookup(null, Properties.Reader.class)) {
            String[] ns = r.getSupportedClassNames();
            if (ns.length != 1 || !JPDABreakpoint.class.getName().equals(ns[0])) continue;
            breakpointsReader = (BreakpointsReader)r;
            break;
        }
        return breakpointsReader;
    }

    static void storeBreakpoints() {
        PersistenceManager pm = instanceRef.get();
        if (pm != null) {
            pm.storeTheBreakpoints();
        }
    }

    private synchronized void storeTheBreakpoints() {
        if (this.saveTask == null) {
            this.saveTask = new RequestProcessor("Debugger JPDA Breakpoints storage", 1).create((Runnable)new SaveTask());
        }
        this.saveTask.schedule(100);
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine engine) {
    }

    public void engineRemoved(DebuggerEngine engine) {
    }

    private final class SaveTask
    implements Runnable {
        private SaveTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PersistenceManager persistenceManager = PersistenceManager.this;
            synchronized (persistenceManager) {
                if (PersistenceManager.this.breakpoints == null) {
                    return;
                }
                Properties.getDefault().getProperties("debugger").getProperties("breakpoints").setArray("jpda", (Object[])PersistenceManager.this.breakpoints);
            }
        }
    }
}

