/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jdi.event;

import com.sun.jdi.InternalException;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.MethodExitEvent;
import org.netbeans.modules.debugger.jpda.JDIExceptionReporter;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;

public final class MethodExitEventWrapper {
    private MethodExitEventWrapper() {
    }

    public static Method method(MethodExitEvent a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.event.MethodExitEvent", "method", "JDI CALL: com.sun.jdi.event.MethodExitEvent({0}).method()", new Object[]{a});
        }
        Object retValue = null;
        try {
            Method ret = a.method();
            retValue = ret;
            Method method = ret;
            return method;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.event.MethodExitEvent", "method", retValue);
            }
        }
    }

    public static Value returnValue(MethodExitEvent a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.event.MethodExitEvent", "returnValue", "JDI CALL: com.sun.jdi.event.MethodExitEvent({0}).returnValue()", new Object[]{a});
        }
        Object retValue = null;
        try {
            Value ret = a.returnValue();
            retValue = ret;
            Value value = ret;
            return value;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.event.MethodExitEvent", "returnValue", retValue);
            }
        }
    }
}

