/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.io.IOException;
import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.debugger.jpda.jdi.ArrayReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StringReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;

public final class ShortenedStrings {
    private static final Map<String, StringInfo> infoStrings = new WeakHashMap<String, StringInfo>();
    private static final Map<StringReference, StringValueInfo> stringsCache = new WeakHashMap<StringReference, StringValueInfo>();
    private static final Set<StringReference> retrievingStrings = new HashSet<StringReference>();

    private ShortenedStrings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringInfo getShortenedInfo(String s) {
        Map<String, StringInfo> map = infoStrings;
        synchronized (map) {
            return infoStrings.get(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register(String shortedString, StringReference sr, int length, ArrayReference chars) {
        StringInfo si = new StringInfo(sr, shortedString.length() - 3, length, chars);
        Map<String, StringInfo> map = infoStrings;
        synchronized (map) {
            infoStrings.put(shortedString, si);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getStringWithLengthControl(StringReference sr) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        block32: {
            block33: {
                retrieved = false;
                var2_2 = ShortenedStrings.stringsCache;
                synchronized (var2_2) {
                    svi = ShortenedStrings.stringsCache.get(sr);
                    if (svi != null) {
                        if (svi.isShort) {
                            return StringReferenceWrapper.value(sr);
                        }
                        str = svi.shortValueRef.get();
                        if (str != null) {
                            return str;
                        }
                    }
                    if (ShortenedStrings.retrievingStrings.contains(sr)) {
                        try {
                            ShortenedStrings.stringsCache.wait();
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                        retrieved = true;
                    } else {
                        ShortenedStrings.retrievingStrings.add(sr);
                    }
                    ** if (!retrieved) goto lbl23
                }
lbl22:
                // 1 sources

                return ShortenedStrings.getStringWithLengthControl(sr);
lbl23:
                // 1 sources

                string = null;
                isShort = true;
                try {
                    st = ObjectReferenceWrapper.referenceType(sr);
                    sa = null;
                    saLength = 0;
                    try {
                        valuesField = ReferenceTypeWrapper.fieldByName(st, "value");
                        if (valuesField == null) {
                            allFields = ReferenceTypeWrapper.allFields(st);
                            for (Field f : allFields) {
                                if (f.isStatic() || !((type = f.type()) instanceof ArrayType) || !"char".equals(((ArrayType)type).componentTypeName())) continue;
                                valuesField = f;
                                break;
                            }
                        }
                        isShort = valuesField == null ? true : ((values = ObjectReferenceWrapper.getValue(sr, valuesField)) instanceof ArrayReference ? (saLength = ArrayReferenceWrapper.length(sa = (ArrayReference)values)) <= 100000 : true);
                    }
                    catch (ClassNotPreparedExceptionWrapper cnpex) {
                        isShort = true;
                    }
                    catch (ClassNotLoadedException cnlex) {
                        isShort = true;
                    }
                    if (isShort) {
                        string = StringReferenceWrapper.value(sr);
                        break block32;
                    }
                    if (!ShortenedStrings.$assertionsDisabled && sa == null) {
                        throw new AssertionError();
                    }
                    l = 100000;
                    values = ArrayReferenceWrapper.getValues(sa, 0, l);
                    characters = new char[l + 3];
                    i = 0;
lbl53:
                    // 2 sources

                    while (i < l) {
                        v = (Value)values.get(i);
                        if (!(v instanceof CharValue)) {
                            var12_19 = "<Unreadable>";
                            var13_20 = ShortenedStrings.stringsCache;
                            break block33;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl85
                }
                catch (Throwable var17_22) {
                    var18_23 = ShortenedStrings.stringsCache;
                    synchronized (var18_23) {
                        if (string != null) {
                            svi = isShort != false ? new StringValueInfo(isShort) : new StringValueInfo(string);
                            ShortenedStrings.stringsCache.put(sr, svi);
                        }
                        ShortenedStrings.retrievingStrings.remove(sr);
                        ShortenedStrings.stringsCache.notifyAll();
                        throw var17_22;
                    }
                }
            }
            synchronized (var13_20) {
                if (string != null) {
                    svi = isShort != false ? new StringValueInfo(isShort) : new StringValueInfo(string);
                    ShortenedStrings.stringsCache.put(sr, svi);
                }
                ShortenedStrings.retrievingStrings.remove(sr);
                ShortenedStrings.stringsCache.notifyAll();
                return var12_19;
            }
lbl-1000:
            // 1 sources

            {
                characters[i] = ((CharValue)v).charValue();
                ++i;
                ** GOTO lbl53
lbl85:
                // 2 sources

                for (i = l; i < l + 3; ++i) {
                    characters[i] = 46;
                }
                shortedString = new String(characters);
                ShortenedStrings.register(shortedString, sr, saLength, sa);
                string = shortedString;
            }
        }
        var4_5 = ShortenedStrings.stringsCache;
        synchronized (var4_5) {
            if (string != null) {
                svi = isShort != false ? new StringValueInfo(isShort) : new StringValueInfo(string);
                ShortenedStrings.stringsCache.put(sr, svi);
            }
            ShortenedStrings.retrievingStrings.remove(sr);
            ShortenedStrings.stringsCache.notifyAll();
            return string;
        }
    }

    static {
        DebuggerManager.getDebuggerManager().addDebuggerListener("sessions", (DebuggerManagerListener)new DebuggerManagerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sessionRemoved(Session session) {
                int n = DebuggerManager.getDebuggerManager().getSessions().length;
                if (n == 0) {
                    Map map = infoStrings;
                    synchronized (map) {
                        infoStrings.clear();
                    }
                    map = stringsCache;
                    synchronized (map) {
                        stringsCache.clear();
                        retrievingStrings.clear();
                    }
                }
            }
        });
    }

    private static class StringValueInfo {
        boolean isShort;
        Reference<String> shortValueRef;

        StringValueInfo(boolean isShort) {
            this.isShort = isShort;
        }

        StringValueInfo(String shortenedValue) {
            this.isShort = false;
            this.shortValueRef = new WeakReference<String>(shortenedValue);
        }
    }

    public static class StringInfo {
        private final StringReference sr;
        private final int shortLength;
        private final int length;
        private final ArrayReference chars;

        private StringInfo(StringReference sr, int shortLength, int length, ArrayReference chars) {
            this.sr = sr;
            this.shortLength = shortLength;
            this.length = length;
            this.chars = chars;
        }

        public int getShortLength() {
            return this.shortLength;
        }

        public int getLength() {
            return this.length;
        }

        public String getFullString() {
            try {
                return StringReferenceWrapper.value(this.sr);
            }
            catch (InternalExceptionWrapper ex) {
                return null;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return null;
            }
            catch (ObjectCollectedExceptionWrapper ex) {
                return null;
            }
        }

        public Reader getContent() {
            return new Reader(){
                int pos = 0;

                @Override
                public int read(char[] cbuf, int off, int len) throws IOException {
                    List<Value> values;
                    if (this.pos + len > StringInfo.this.length) {
                        len = StringInfo.this.length - this.pos;
                    }
                    try {
                        values = ArrayReferenceWrapper.getValues(StringInfo.this.chars, this.pos, len);
                    }
                    catch (InternalExceptionWrapper ex) {
                        throw new IOException(ex);
                    }
                    catch (VMDisconnectedExceptionWrapper ex) {
                        throw new IOException(ex);
                    }
                    catch (ObjectCollectedExceptionWrapper ex) {
                        throw new IOException(ex);
                    }
                    for (int i = 0; i < len; ++i) {
                        Value v = values.get(i);
                        if (!(v instanceof CharValue)) {
                            int p = this.pos + i;
                            throw new IOException("Char at " + p + " is not a character: " + v);
                        }
                        cbuf[off + i] = ((CharValue)v).charValue();
                    }
                    this.pos += len;
                    return len;
                }

                @Override
                public void close() throws IOException {
                }
            };
        }
    }
}

