/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.util;

import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.StepRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.actions.SuspendController;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocatableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ClassPrepareEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ClassUnloadEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.EventQueueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.EventSetWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.LocatableEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ThreadDeathEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ThreadStartEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.StepRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class Operator {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.jdievents");
    public static final String SILENT_EVENT_PROPERTY = "silent";
    private Thread thread;
    private final Set<ThreadReference> methodInvokingThreads = new HashSet<ThreadReference>();
    private boolean stop;
    private boolean canInterrupt;
    private JPDADebuggerImpl debugger;
    private RequestProcessor eventHandler;
    private Map<ThreadReference, HandlerTask> eventHandlers = new HashMap<ThreadReference, HandlerTask>();
    private final List<EventSet> parallelEvents = new LinkedList<EventSet>();
    private boolean haveParallelEventsToProcess = false;
    private final Map<EventSet, Set<ThreadReference>> threadsResumedForEvents = new WeakHashMap<EventSet, Set<ThreadReference>>();
    private final LoopControl loopControl;

    public Operator(VirtualMachine virtualMachine, JPDADebuggerImpl debugger, Executor starter, Runnable finalizer, ReadWriteLock resumeLock) {
        EventQueue eventQueue;
        try {
            eventQueue = VirtualMachineWrapper.eventQueue(virtualMachine);
        }
        catch (InternalExceptionWrapper ex) {
            eventQueue = null;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            eventQueue = null;
        }
        if (eventQueue == null) {
            throw new NullPointerException();
        }
        this.debugger = debugger;
        final SuspendControllersSupport scs = new SuspendControllersSupport(debugger);
        final SuspendCount suspendCount = new SuspendCount();
        final Object[] params = new Object[]{eventQueue, starter, finalizer};
        final Runnable operatorLoop = new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Nonsensical loop would be emitted - failure
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopIdentifier.considerAsDoLoopStart(LoopIdentifier.java:438)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopIdentifier.identifyLoops1(LoopIdentifier.java:65)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:681)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        final Lookup defaultCallerLookup = Lookup.getDefault();
        Runnable runnableWithLookup = new Runnable(){

            @Override
            public void run() {
                Lookups.executeWith((Lookup)defaultCallerLookup, (Runnable)operatorLoop);
            }
        };
        this.thread = new Thread(runnableWithLookup, "Debugger operator thread");
        this.loopControl = new LoopControl(this.thread, starter, scs, suspendCount);
    }

    /*
     * Exception decompiling
     */
    private boolean processEvents(EventSet eventSet, Executor starter, SuspendControllersSupport scs, SuspendCount suspendCount) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForParallelEventsToProcess() throws InterruptedException {
        List<EventSet> list = this.parallelEvents;
        synchronized (list) {
            while (this.haveParallelEventsToProcess) {
                this.parallelEvents.wait();
            }
        }
    }

    public static void dumpThreadsStatus(VirtualMachine vm, Level l) {
        logger.log(l, "DUMP of threads:\n");
        List<ThreadReference> allThreads = vm.allThreads();
        for (ThreadReference t : allThreads) {
            logger.log(l, "   " + t + " " + JPDAThreadImpl.getThreadStateLog(t));
        }
        logger.log(l, "DUMP DONE.");
    }

    private static void dumpThreadsStatus(VirtualMachine vm) {
        if (!logger.isLoggable(Level.FINE)) {
            return;
        }
        logger.fine("DUMP of threads:\n");
        List<ThreadReference> allThreads = vm.allThreads();
        for (ThreadReference t : allThreads) {
            logger.fine("   " + t + " " + JPDAThreadImpl.getThreadStateLog(t));
        }
        logger.fine("DUMP DONE.");
    }

    private static ThreadReference getEventThread(Event e) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        ThreadReference tref = null;
        if (e instanceof LocatableEvent) {
            tref = LocatableEventWrapper.thread((LocatableEvent)e);
        } else if (e instanceof ClassPrepareEvent) {
            tref = ClassPrepareEventWrapper.thread((ClassPrepareEvent)e);
        } else if (e instanceof ThreadStartEvent) {
            tref = ThreadStartEventWrapper.thread((ThreadStartEvent)e);
        } else if (e instanceof ThreadDeathEvent) {
            tref = ThreadDeathEventWrapper.thread((ThreadDeathEvent)e);
        }
        return tref;
    }

    public void start() {
        this.thread.start();
    }

    public synchronized void register(EventRequest req, Executor e) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        EventRequestWrapper.putProperty(req, "executor", e);
    }

    public synchronized void unregister(EventRequest req) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        Executor e = (Executor)EventRequestWrapper.getProperty(req, "executor");
        EventRequestWrapper.putProperty(req, "executor", null);
        if (e != null) {
            e.removed(req);
        }
        if (req instanceof StepRequest) {
            ThreadReference tr = StepRequestWrapper.thread((StepRequest)req);
            this.debugger.getThread(tr).setInStep(false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Operator operator = this;
        synchronized (operator) {
            if (this.stop) {
                return;
            }
            this.stop = true;
            if (this.canInterrupt) {
                this.thread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startEventHandlerThreadFor(final ThreadReference tr) {
        RequestProcessor rp;
        Operator operator = this;
        synchronized (operator) {
            if (this.eventHandler == null) {
                this.eventHandler = new RequestProcessor("Debugger Event Handler", 10);
            }
            rp = this.eventHandler;
        }
        final Thread[] threadPtr = new Thread[]{null};
        RequestProcessor.Task task = rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread[] threadArray = threadPtr;
                synchronized (threadPtr) {
                    EventQueue eventQueue;
                    threadPtr[0] = Thread.currentThread();
                    threadPtr.notifyAll();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    try {
                        eventQueue = VirtualMachineWrapper.eventQueue(MirrorWrapper.virtualMachine(tr));
                    }
                    catch (InternalExceptionWrapper ex) {
                        return;
                    }
                    catch (VMDisconnectedExceptionWrapper ex) {
                        return;
                    }
                    if (Thread.interrupted()) {
                        return;
                    }
                    while (true) {
                        block27: {
                            try {
                                Set ignoredThreads;
                                EventSet eventSet = EventQueueWrapper.remove(eventQueue);
                                if (logger.isLoggable(Level.FINE)) {
                                    try {
                                        logger.fine("HAVE EVENT(s) in the Queue for " + tr + " : " + eventSet);
                                    }
                                    catch (ObjectCollectedException ocex) {
                                        logger.log(Level.FINE, "HAVE EVENT(s) in the Queue for a thread with something collected:", ocex);
                                    }
                                }
                                if ((ignoredThreads = Operator.this.testIgnoreEvent(eventSet)) != null && ignoredThreads.isEmpty()) {
                                    if (logger.isLoggable(Level.FINE)) {
                                        logger.fine("  the event(s) in the Queue for " + tr + " are ignored and event set is resumed.");
                                    }
                                    EventSetWrapper.resume(eventSet);
                                    break block27;
                                }
                                List list = Operator.this.parallelEvents;
                                synchronized (list) {
                                    Operator.this.parallelEvents.add(eventSet);
                                    Operator.this.haveParallelEventsToProcess = true;
                                    if (logger.isLoggable(Level.FINE)) {
                                        try {
                                            logger.fine("  the event(s) in the Queue for " + tr + " are stored as parallelEvents = " + Operator.this.parallelEvents);
                                        }
                                        catch (ObjectCollectedException ocex) {
                                            logger.log(Level.FINE, "  the event(s) in the Queue for a collected thread are stored as parallelEvents with something collected:", ocex);
                                        }
                                    }
                                }
                                Operator.this.loopControl.setHaveParallelEventsInLoopThread(true);
                                if (ignoredThreads != null) {
                                    for (ThreadReference t : ignoredThreads) {
                                        if (logger.isLoggable(Level.FINE)) {
                                            logger.fine("  resuming " + t + " to finish method invocation... Status " + JPDAThreadImpl.getThreadStateLog(t));
                                        }
                                        ThreadReferenceWrapper.resume(t);
                                    }
                                }
                            }
                            catch (InterruptedException ex) {
                                return;
                            }
                            catch (InternalExceptionWrapper ex) {
                                continue;
                            }
                            catch (VMDisconnectedExceptionWrapper ex) {
                                return;
                            }
                            catch (Exception e) {
                                Exceptions.printStackTrace((Throwable)e);
                            }
                        }
                        if (Thread.interrupted()) break;
                    }
                    return;
                }
            }
        }, 500);
        this.eventHandlers.put(tr, new HandlerTask(task, threadPtr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMethodInvoking(ThreadReference tr) {
        if (logger.isLoggable(Level.FINE)) {
            try {
                logger.fine("  notifyMethodInvoking(" + tr + ") suspendCount = " + tr.suspendCount());
            }
            catch (Exception ex) {
                logger.fine("  notifyMethodInvoking(" + tr + ")");
            }
        }
        if (Thread.currentThread() == this.thread) {
            this.startEventHandlerThreadFor(tr);
        }
        Set<ThreadReference> set = this.methodInvokingThreads;
        synchronized (set) {
            this.methodInvokingThreads.add(tr);
        }
        this.loopControl.setInMethodInvoke(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMethodInvokeDone(ThreadReference tr) {
        boolean done;
        HandlerTask task;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("  notifyMethodInvokeDone(" + tr + ")");
        }
        if (Thread.currentThread() == this.thread && (task = this.eventHandlers.remove(tr)) != null) {
            task.cancel();
        }
        Set<ThreadReference> set = this.methodInvokingThreads;
        synchronized (set) {
            this.methodInvokingThreads.remove(tr);
            done = this.methodInvokingThreads.isEmpty();
        }
        if (done) {
            this.loopControl.setInMethodInvoke(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testIgnoreEvent(EventSet eventSet, Set<ThreadReference> resumedThreads) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        int suspendPolicy;
        ThreadReference tref = null;
        for (Event e : eventSet) {
            if (!(e instanceof LocatableEvent)) continue;
            tref = LocatableEventWrapper.thread((LocatableEvent)e);
        }
        if (tref != null) {
            Set<ThreadReference> i$ = this.methodInvokingThreads;
            synchronized (i$) {
                if (this.methodInvokingThreads.contains(tref)) {
                    return true;
                }
            }
        }
        if ((suspendPolicy = EventSetWrapper.suspendPolicy(eventSet)) == 2) {
            logger.log(Level.FINE, "methodInvokingThreads = {0}", this.methodInvokingThreads);
            Object object = this.methodInvokingThreads;
            synchronized (object) {
                for (ThreadReference tr : this.methodInvokingThreads) {
                    try {
                        ThreadReferenceWrapper.resume(tr);
                        resumedThreads.add(tr);
                        logger.log(Level.FINE, "  resumed threads = {0}", resumedThreads);
                    }
                    catch (ObjectCollectedExceptionWrapper ex) {
                    }
                    catch (IllegalThreadStateExceptionWrapper ex) {}
                }
            }
            object = this.threadsResumedForEvents;
            synchronized (object) {
                Set<ThreadReference> resumed = this.threadsResumedForEvents.get(eventSet);
                if (resumed != null && !resumedThreads.isEmpty()) {
                    resumed.addAll(resumedThreads);
                } else if (!resumedThreads.isEmpty()) {
                    resumed = resumedThreads;
                }
                this.threadsResumedForEvents.put(eventSet, resumed);
                logger.log(Level.FINE, "Set threadsResumedForEvents {0} for events {1}", new Object[]{resumed, System.identityHashCode(eventSet)});
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ThreadReference> testIgnoreEvent(EventSet eventSet) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        int suspendPolicy = EventSetWrapper.suspendPolicy(eventSet);
        ThreadReference tref = null;
        for (Event e : eventSet) {
            tref = Operator.getEventThread(e);
        }
        if (tref != null && suspendPolicy == 1) {
            Set<ThreadReference> i$ = this.methodInvokingThreads;
            synchronized (i$) {
                if (this.methodInvokingThreads.contains(tref)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "testIgnoreEvent({0}) = []", eventSet);
                    }
                    return Collections.emptySet();
                }
            }
        }
        HashSet<ThreadReference> threadsToResume = null;
        if (suspendPolicy == 2) {
            logger.log(Level.FINE, "methodInvokingThreads = {0}", this.methodInvokingThreads);
            Object object = this.methodInvokingThreads;
            synchronized (object) {
                if (!this.methodInvokingThreads.isEmpty()) {
                    threadsToResume = new HashSet<ThreadReference>(this.methodInvokingThreads);
                }
            }
            if (threadsToResume != null) {
                object = this.threadsResumedForEvents;
                synchronized (object) {
                    Set<ThreadReference> resumed = this.threadsResumedForEvents.get(eventSet);
                    if (resumed != null) {
                        resumed.addAll(threadsToResume);
                    } else {
                        resumed = threadsToResume;
                    }
                    this.threadsResumedForEvents.put(eventSet, resumed);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Set threadsResumedForEvents " + resumed + " for events " + System.identityHashCode(eventSet));
                    }
                }
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("testIgnoreEvent(" + eventSet + ") = " + threadsToResume);
        }
        return threadsToResume;
    }

    private void printEvent(Event e, Executor exec) {
        try {
            if (e instanceof ClassPrepareEvent) {
                logger.fine("JDI EVENT: ClassPrepareEvent " + ClassPrepareEventWrapper.referenceType((ClassPrepareEvent)e));
            } else if (e instanceof ClassUnloadEvent) {
                logger.fine("JDI EVENT: ClassUnloadEvent " + ClassUnloadEventWrapper.className((ClassUnloadEvent)e));
            } else if (e instanceof ThreadStartEvent) {
                try {
                    logger.fine("JDI EVENT: ThreadStartEvent " + ThreadStartEventWrapper.thread((ThreadStartEvent)e));
                }
                catch (Exception ex) {
                    logger.fine("JDI EVENT: ThreadStartEvent1 " + e);
                }
            } else if (e instanceof ThreadDeathEvent) {
                try {
                    logger.fine("JDI EVENT: ThreadDeathEvent " + ThreadDeathEventWrapper.thread((ThreadDeathEvent)e));
                }
                catch (Exception ex) {
                    logger.fine("JDI EVENT: ThreadDeathEvent1 " + e);
                }
            } else if (e instanceof MethodEntryEvent) {
                try {
                    logger.fine("JDI EVENT: MethodEntryEvent " + e);
                }
                catch (Exception ex) {
                    logger.fine("JDI EVENT: MethodEntryEvent " + e);
                }
            } else if (e instanceof BreakpointEvent) {
                logger.fine("JDI EVENT: BreakpointEvent " + LocatableEventWrapper.thread((BreakpointEvent)e) + " : " + LocatableWrapper.location((BreakpointEvent)e));
            } else if (e instanceof StepEvent) {
                logger.fine("JDI EVENT: StepEvent " + LocatableEventWrapper.thread((StepEvent)e) + " : " + LocatableWrapper.location((StepEvent)e));
            } else {
                logger.fine("JDI EVENT: " + e + " : " + exec);
            }
        }
        catch (Exception ex) {
            logger.fine(ex.getLocalizedMessage());
        }
    }

    static /* synthetic */ boolean access$500(Operator x0) {
        return x0.stop;
    }

    static /* synthetic */ boolean access$602(Operator x0, boolean x1) {
        x0.canInterrupt = x1;
        return x0.canInterrupt;
    }

    static /* synthetic */ void access$700(VirtualMachine x0) {
        Operator.dumpThreadsStatus(x0);
    }

    static /* synthetic */ boolean access$800(Operator x0, EventSet x1, Executor x2, SuspendControllersSupport x3, SuspendCount x4) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        return x0.processEvents(x1, x2, x3, x4);
    }

    static /* synthetic */ boolean access$400(Operator x0) {
        return x0.haveParallelEventsToProcess;
    }

    private static class SuspendControllersSupport
    implements SuspendController {
        private final List<? extends SuspendController> scs;

        public SuspendControllersSupport(JPDADebuggerImpl debugger) {
            this.scs = debugger.getSession().lookup(null, SuspendController.class);
        }

        @Override
        public boolean suspend(ThreadReference tRef) {
            boolean canSuspend = true;
            for (SuspendController suspendController : this.scs) {
                boolean s = suspendController.suspend(tRef);
                if (s) continue;
                canSuspend = false;
            }
            return canSuspend;
        }

        @Override
        public boolean suspend(VirtualMachine vm) {
            boolean canSuspend = true;
            for (SuspendController suspendController : this.scs) {
                boolean s = suspendController.suspend(vm);
                if (s) continue;
                canSuspend = false;
            }
            return canSuspend;
        }
    }

    private final class LoopControl {
        private Thread t;
        private boolean isMethodInvoke;
        private boolean haveParallelEventsInLoopThread;
        private boolean interrupedToProcessParalelEvents;

        public LoopControl(Thread t, Executor starter, SuspendControllersSupport scs, SuspendCount suspendCount) {
            this.t = t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setInMethodInvoke(boolean isMethodInvoke) {
            LoopControl loopControl;
            if (!isMethodInvoke) {
                loopControl = this;
                synchronized (loopControl) {
                    if (this.haveParallelEventsInLoopThread) {
                        this.interrupedToProcessParalelEvents = true;
                        this.t.interrupt();
                    }
                }
            }
            loopControl = this;
            synchronized (loopControl) {
                this.isMethodInvoke = isMethodInvoke;
            }
        }

        public boolean isInterrupedToProcessParallelEvents() {
            boolean is = this.interrupedToProcessParalelEvents;
            this.interrupedToProcessParalelEvents = false;
            return is;
        }

        public synchronized void setHaveParallelEventsInLoopThread(boolean haveParallelEventsInLoopThread) {
            this.haveParallelEventsInLoopThread = haveParallelEventsInLoopThread;
        }

        public synchronized boolean haveParallelEventsInLoopThread() {
            return this.haveParallelEventsInLoopThread;
        }

        public synchronized boolean isInMethodInvoke() {
            return this.isMethodInvoke;
        }
    }

    private static final class SuspendCount {
        private final Map<ThreadReference, MutableInteger> threads = new WeakHashMap<ThreadReference, MutableInteger>();

        private SuspendCount() {
        }

        public synchronized void add(ThreadReference t) {
            MutableInteger i = this.threads.get(t);
            if (i == null) {
                i = new MutableInteger(1);
                this.threads.put(t, i);
            }
            ++i.i;
        }

        public synchronized int getSuspendCountFor(ThreadReference t) {
            MutableInteger i = this.threads.get(t);
            if (i == null) {
                return 0;
            }
            return i.i;
        }

        public synchronized int removeSuspendCountFor(ThreadReference t) {
            MutableInteger i = this.threads.remove(t);
            if (i == null) {
                return 0;
            }
            return i.i;
        }

        private static final class MutableInteger {
            public int i;

            public MutableInteger(int i) {
                this.i = i;
            }
        }
    }

    private static final class HandlerTask {
        private RequestProcessor.Task task;
        private final Thread[] threadPtr;

        HandlerTask(RequestProcessor.Task task, Thread[] threadPtr) {
            this.task = task;
            this.threadPtr = threadPtr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void cancel() {
            if (this.task.cancel()) return;
            Thread[] threadArray = this.threadPtr;
            synchronized (this.threadPtr) {
                if (this.threadPtr[0] == null) {
                    try {
                        this.threadPtr.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                Thread t = this.threadPtr[0];
                if (t == null) return;
                t.interrupt();
                try {
                    while (!this.task.waitFinished(250L)) {
                        t.interrupt();
                    }
                    return;
                }
                catch (InterruptedException ex) {
                    this.task.waitFinished();
                }
                return;
            }
        }
    }
}

