/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.spi.remote.HostInfoProviderFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;

public class RemoteHostInfoProviderFactory
implements HostInfoProviderFactory {
    private static final Map<ExecutionEnvironment, RemoteHostInfo> env2hostinfo = new HashMap<ExecutionEnvironment, RemoteHostInfo>();

    public static synchronized RemoteHostInfo getHostInfo(ExecutionEnvironment execEnv) {
        RemoteHostInfo hi = env2hostinfo.get(execEnv);
        if (hi == null) {
            hi = new RemoteHostInfo(execEnv);
            env2hostinfo.put(execEnv, hi);
        }
        return hi;
    }

    public boolean canCreate(ExecutionEnvironment execEnv) {
        return execEnv.isRemote();
    }

    public HostInfoProvider create(ExecutionEnvironment execEnv) {
        return RemoteHostInfoProviderFactory.getHostInfo(execEnv);
    }

    public static class RemoteHostInfo
    extends HostInfoProvider {
        private final ExecutionEnvironment executionEnvironment;
        private Map<String, String> envCache = null;
        private Boolean isCshShell;

        public boolean fileExists(String path) {
            try {
                return HostInfoUtils.fileExists((ExecutionEnvironment)this.executionEnvironment, (String)path);
            }
            catch (IOException | InterruptedException ex) {
                return false;
            }
        }

        public String getLibDir() {
            String tmpDir;
            try {
                tmpDir = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.executionEnvironment).getTempDir();
            }
            catch (Throwable ex) {
                tmpDir = "/var/tmp";
            }
            String libDir = tmpDir + "/tools";
            return libDir;
        }

        private RemoteHostInfo(ExecutionEnvironment executionEnvironment) {
            this.executionEnvironment = executionEnvironment;
        }

        public synchronized PathMap getMapper() {
            return RemotePathMap.getPathMap(this.executionEnvironment);
        }

        public synchronized Map<String, String> getEnv() {
            if (this.envCache == null) {
                this.envCache = new HashMap<String, String>();
                ProcessUtils.ExitStatus rc = ProcessUtils.execute((ExecutionEnvironment)this.executionEnvironment, (String)"env", (String[])new String[0]);
                if (rc.isOK()) {
                    String val = rc.output;
                    String[] lines = val.split("\n");
                    for (int i = 0; i < lines.length; ++i) {
                        int pos = lines[i].indexOf(61);
                        if (pos <= 0) continue;
                        this.envCache.put(lines[i].substring(0, pos), lines[i].substring(pos + 1));
                    }
                }
            }
            return this.envCache;
        }
    }
}

