/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.networkneighbour;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.remote.ui.networkneighbour.NeighbourHost;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public final class NetworkRegistry {
    private static final int SSH_PING_TIMEOUT = Integer.getInteger("ssh.ping.timeout", 3000);
    private static final boolean NO_SCAN = Boolean.getBoolean("networkregistry.noscan");
    private static final ScannerLock lock = new ScannerLock();
    private static final NetworkRegistry instance = new NetworkRegistry();
    private static final int numOfScanThreads = 8;
    private final ExplorerManager manager = new ExplorerManager();
    private final List<NeighbourHost> hosts;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private Scanner scanner;
    private RequestProcessor.Task[] scanningTasks;
    private final RequestProcessor rc = new RequestProcessor("NetwrorkRegistry", 8);

    private NetworkRegistry() {
        System.setProperty("java.net.preferIPv4Stack", "true");
        this.hosts = new ArrayList<NeighbourHost>();
        this.scanner = NO_SCAN ? null : new Scanner();
        this.manager.setRootContext(Node.EMPTY);
        Preferences proxyPrefs = NbPreferences.root().node("org/netbeans/core");
        if (!NO_SCAN) {
            proxyPrefs.addPreferenceChangeListener(new PreferenceChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void preferenceChange(PreferenceChangeEvent evt) {
                    NetworkRegistry networkRegistry = NetworkRegistry.this;
                    synchronized (networkRegistry) {
                        NetworkRegistry.this.stopScan();
                        NetworkRegistry.this.hosts.clear();
                        NetworkRegistry.this.cs.fireChange();
                        NetworkRegistry.this.scanner = new Scanner();
                        NetworkRegistry.this.startScan();
                    }
                }
            });
        }
    }

    public NeighbourHost[] getHosts() {
        return this.hosts.toArray(new NeighbourHost[this.hosts.size()]);
    }

    public void addChangeListener(ChangeListener cl) {
        this.cs.addChangeListener(cl);
        cl.stateChanged(new ChangeEvent(this));
    }

    public void removeChangeListener(ChangeListener cl) {
        this.cs.removeChangeListener(cl);
    }

    public static NetworkRegistry getInstance() {
        return instance;
    }

    public boolean isHostAccessible(String hostname, int port) {
        try {
            return this.doPing(InetAddress.getByName(hostname), port);
        }
        catch (UnknownHostException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHost(Scanner scanner, NeighbourHost host) {
        NetworkRegistry networkRegistry = this;
        synchronized (networkRegistry) {
            if (scanner != this.scanner) {
                return;
            }
            this.hosts.add(host);
            this.cs.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startScan() {
        NetworkRegistry networkRegistry = this;
        synchronized (networkRegistry) {
            if (this.scanner != null && this.scanningTasks == null) {
                this.scanningTasks = new RequestProcessor.Task[8];
                for (int i = 0; i < 8; ++i) {
                    this.scanningTasks[i] = this.rc.post((Runnable)this.scanner);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopScan() {
        NetworkRegistry networkRegistry = this;
        synchronized (networkRegistry) {
            if (this.scanner != null && this.scanningTasks != null) {
                this.scanner.stop();
                this.scanningTasks = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doPing(InetAddress addr, int port) {
        Socket socket = null;
        try {
            socket = new Socket();
            socket.setReuseAddress(true);
            socket.setSoTimeout(SSH_PING_TIMEOUT);
            socket.setKeepAlive(false);
            InetSocketAddress address = new InetSocketAddress(addr, port);
            socket.connect(address, SSH_PING_TIMEOUT);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private static final class ScannerLock {
        private ScannerLock() {
        }
    }

    private static final class SingleRangeEnumeration
    implements Enumeration<InetAddress> {
        private final long lastAddress;
        private long currentAddress;

        public SingleRangeEnumeration(InterfaceAddress address) {
            short prefixLength = address.getNetworkPrefixLength();
            InetAddress inetAddress = address.getAddress();
            byte[] b = inetAddress.getAddress();
            this.currentAddress = (0xFFL & (long)b[0]) << 24;
            this.currentAddress |= (0xFFL & (long)b[1]) << 16;
            this.currentAddress |= (0xFFL & (long)b[2]) << 8;
            this.currentAddress |= 0xFFL & (long)b[3];
            this.currentAddress &= 0xFFFFFFFFL << 32 - prefixLength;
            ++this.currentAddress;
            this.lastAddress = this.currentAddress | (long)((1 << 32 - prefixLength) - 1);
        }

        @Override
        public boolean hasMoreElements() {
            return this.currentAddress < this.lastAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InetAddress nextElement() {
            try {
                InetAddress inetAddress = Inet4Address.getByAddress(new byte[]{(byte)(this.currentAddress >> 24 & 0xFFL), (byte)(this.currentAddress >> 16 & 0xFFL), (byte)(this.currentAddress >> 8 & 0xFFL), (byte)(this.currentAddress & 0xFFL)});
                return inetAddress;
            }
            catch (UnknownHostException unknownHostException) {
            }
            finally {
                ++this.currentAddress;
            }
            return null;
        }
    }

    private static final class AdressesEnumeration
    implements Enumeration<InetAddress> {
        private final Iterator<SingleRangeEnumeration> rangesIterator;
        private SingleRangeEnumeration currentEnumerator;

        public AdressesEnumeration() {
            HashSet<SingleRangeEnumeration> set = new HashSet<SingleRangeEnumeration>();
            try {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                while (networkInterfaces.hasMoreElements()) {
                    NetworkInterface ifc = networkInterfaces.nextElement();
                    if (ifc.isLoopback()) continue;
                    List<InterfaceAddress> interfaceAddresses = null;
                    try {
                        interfaceAddresses = ifc.getInterfaceAddresses();
                    }
                    catch (Throwable th) {
                        // empty catch block
                    }
                    if (interfaceAddresses == null) continue;
                    for (InterfaceAddress address : interfaceAddresses) {
                        InetAddress broadcast = address.getBroadcast();
                        if (broadcast == null) continue;
                        set.add(new SingleRangeEnumeration(address));
                    }
                }
            }
            catch (SocketException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.rangesIterator = set.iterator();
            this.currentEnumerator = this.rangesIterator.hasNext() ? this.rangesIterator.next() : null;
        }

        @Override
        public boolean hasMoreElements() {
            return this.currentEnumerator != null && this.currentEnumerator.hasMoreElements();
        }

        @Override
        public InetAddress nextElement() {
            InetAddress result = this.currentEnumerator.nextElement();
            if (!this.currentEnumerator.hasMoreElements()) {
                this.currentEnumerator = this.rangesIterator.hasNext() ? this.rangesIterator.next() : null;
            }
            return result;
        }
    }

    private class Scanner
    implements Runnable {
        private AdressesEnumeration addressesToScan = new AdressesEnumeration();
        private volatile boolean isInterrupted;

        private Scanner() {
        }

        public void stop() {
            this.isInterrupted = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.isInterrupted = false;
            while (!this.isInterrupted()) {
                InetAddress address = null;
                ScannerLock scannerLock = lock;
                synchronized (scannerLock) {
                    if (this.addressesToScan.hasMoreElements()) {
                        address = this.addressesToScan.nextElement();
                    }
                }
                if (address == null) break;
                String hostName = address.getCanonicalHostName();
                String ipAddress = address.getHostAddress();
                if (hostName == null || ipAddress == null || ipAddress.equalsIgnoreCase(hostName)) continue;
                NetworkRegistry.this.addHost(this, new NeighbourHost(hostName, NetworkRegistry.this.doPing(address, 22)));
            }
        }

        private boolean isInterrupted() {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException ex) {
                this.isInterrupted = true;
                Thread.currentThread().interrupt();
            }
            this.isInterrupted |= Thread.currentThread().isInterrupted();
            return this.isInterrupted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset() {
            ScannerLock scannerLock = lock;
            synchronized (scannerLock) {
                this.addressesToScan = new AdressesEnumeration();
            }
        }
    }
}

