/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.api.common.ant.PackageModifierImplementation;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMComponent;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMQName;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.PluginContainer;
import org.netbeans.modules.maven.model.pom.PluginManagement;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class MavenPackageModifierImpl
implements PackageModifierImplementation {
    private final Project project;
    static final String ID_LOGICAL = "projectTabLogical_tc";

    public MavenPackageModifierImpl(Project p) {
        this.project = p;
    }

    public void exportPackageAction(final Collection<String> packagesToExport, final boolean export) {
        final PropertyChangeListener prop = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                block7: {
                    if (!"MavenProject".equals(evt.getPropertyName())) {
                        return;
                    }
                    try {
                        FileObject srcdir = FileUtilities.convertStringToFileObject((String)((NbMavenProject)MavenPackageModifierImpl.this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject().getBuild().getSourceDirectory());
                        if (srcdir == null) break block7;
                        LogicalViewProvider lvp = (LogicalViewProvider)MavenPackageModifierImpl.this.project.getLookup().lookup(LogicalViewProvider.class);
                        assert (lvp != null);
                        Node root = this.findProjectTCRootNode();
                        if (root == null) break block7;
                        for (Node prjNode : root.getChildren().getNodes(true)) {
                            Project p = (Project)prjNode.getLookup().lookup(Project.class);
                            if (!MavenPackageModifierImpl.this.project.equals(p)) continue;
                            Node found = lvp.findPath(prjNode, (Object)srcdir);
                            if (found != null) {
                                this.iterateNodesAndFireIconChange(found);
                            }
                            break;
                        }
                    }
                    finally {
                        ((NbMavenProject)MavenPackageModifierImpl.this.project.getLookup().lookup(NbMavenProject.class)).removePropertyChangeListener((PropertyChangeListener)this);
                    }
                }
            }

            private void iterateNodesAndFireIconChange(Node found) {
                for (Node nd : found.getChildren().getNodes(true)) {
                    FileObject fo = (FileObject)nd.getLookup().lookup(FileObject.class);
                    if (fo == null || !fo.isFolder() || !fo.isFolder()) continue;
                    try {
                        Method m1 = Node.class.getDeclaredMethod("fireIconChange", new Class[0]);
                        m1.setAccessible(true);
                        Method m2 = Node.class.getDeclaredMethod("fireOpenedIconChange", new Class[0]);
                        m2.setAccessible(true);
                        m2.invoke((Object)nd, new Object[0]);
                        m1.invoke((Object)nd, new Object[0]);
                    }
                    catch (NoSuchMethodException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (SecurityException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IllegalAccessException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (InvocationTargetException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    this.iterateNodesAndFireIconChange(nd);
                }
            }

            private Node findProjectTCRootNode() {
                final Node[] toRet = new Node[1];
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            TopComponent projecttc = WindowManager.getDefault().findTopComponent(MavenPackageModifierImpl.ID_LOGICAL);
                            if (projecttc != null && projecttc instanceof ExplorerManager.Provider) {
                                Node root;
                                ExplorerManager.Provider em = (ExplorerManager.Provider)projecttc;
                                toRet[0] = root = em.getExplorerManager().getRootContext();
                            }
                        }
                    });
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                return toRet[0];
            }
        };
        Utilities.performPOMModelOperations((FileObject)this.project.getProjectDirectory().getFileObject("pom.xml"), Collections.singletonList(new ModelOperation<POMModel>(){

            public void performOperation(POMModel model) {
                PluginManagement pm;
                org.netbeans.modules.maven.model.pom.Project p = model.getProject();
                Build bld = p.getBuild();
                POMExtensibilityElement publicPackages = null;
                if (bld != null && (publicPackages = this.findPublicPackagesElement((PluginContainer)bld)) != null && (pm = bld.getPluginManagement()) != null) {
                    publicPackages = this.findPublicPackagesElement((PluginContainer)pm);
                }
                if (publicPackages == null && export) {
                    publicPackages = this.createPublicPackagesElement(p);
                    assert (publicPackages != null);
                }
                if (export) {
                    for (String exp : packagesToExport) {
                        POMExtensibilityElement pack = model.getFactory().createPOMExtensibilityElement(POMQName.createQName((String)"publicPackage"));
                        publicPackages.addExtensibilityElement(pack);
                        pack.setElementText(exp);
                    }
                } else {
                    HashSet<POMExtensibilityElement> toRemove = new HashSet<POMExtensibilityElement>();
                    block1: for (String exp : packagesToExport) {
                        for (POMExtensibilityElement el : publicPackages.getExtensibilityElements()) {
                            if (!"publicPackage".equals(el.getQName().getLocalPart()) || el.getElementText() == null || !el.getElementText().equals(exp)) continue;
                            toRemove.add(el);
                            continue block1;
                        }
                    }
                    if (!toRemove.isEmpty()) {
                        for (POMExtensibilityElement el : toRemove) {
                            publicPackages.removeExtensibilityElement(el);
                        }
                        if (publicPackages.getChildren() == null || publicPackages.getChildren().isEmpty()) {
                            ((POMComponent)publicPackages.getParent()).removeExtensibilityElement(publicPackages);
                        }
                    }
                }
                ((NbMavenProject)MavenPackageModifierImpl.this.project.getLookup().lookup(NbMavenProject.class)).addPropertyChangeListener(prop);
            }

            private POMExtensibilityElement createPublicPackagesElement(org.netbeans.modules.maven.model.pom.Project p) {
                List elems;
                Configuration conf;
                Plugin plug;
                Build bld = p.getBuild();
                if (bld == null) {
                    bld = p.getModel().getFactory().createBuild();
                    p.setBuild(bld);
                }
                if ((plug = bld.findPluginById("org.codehaus.mojo", "nbm-maven-plugin")) == null) {
                    plug = bld.getModel().getFactory().createPlugin();
                    plug.setGroupId("org.codehaus.mojo");
                    plug.setArtifactId("nbm-maven-plugin");
                    plug.setExtensions(Boolean.TRUE);
                    bld.addPlugin(plug);
                }
                if ((conf = plug.getConfiguration()) == null) {
                    conf = plug.getModel().getFactory().createConfiguration();
                    plug.setConfiguration(conf);
                }
                if ((elems = conf.getConfigurationElements()) != null) {
                    for (POMExtensibilityElement el : elems) {
                        if (!"publicPackages".equals(el.getQName().getLocalPart())) continue;
                        return el;
                    }
                }
                POMExtensibilityElement toRet = conf.getModel().getFactory().createPOMExtensibilityElement(POMQName.createQName((String)"publicPackages"));
                conf.addExtensibilityElement(toRet);
                return toRet;
            }

            private POMExtensibilityElement findPublicPackagesElement(PluginContainer bld) {
                List elems;
                Configuration conf;
                POMExtensibilityElement publicPackages = null;
                Plugin plug = bld.findPluginById("org.codehaus.mojo", "nbm-maven-plugin");
                if (plug != null && (conf = plug.getConfiguration()) != null && (elems = conf.getConfigurationElements()) != null) {
                    for (POMExtensibilityElement el : elems) {
                        if (!"publicPackages".equals(el.getQName().getLocalPart())) continue;
                        publicPackages = el;
                        break;
                    }
                }
                return publicPackages;
            }
        }));
    }
}

