/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.whitelist.WhiteListQuery;
import org.netbeans.modules.apisupport.project.ModuleDependency;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.spi.whitelist.WhiteListQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

public class ProjectWhiteListQueryImplementation
implements WhiteListQueryImplementation {
    private NbModuleProject project;
    private SoftReference<TreeSet<String>> cachedPrivatePackages;
    private boolean isCached = false;
    private static final WhiteListQuery.Result OK = new WhiteListQuery.Result();
    private final Set<ProjectWhiteListImplementation> results = Collections.synchronizedSet(new WeakSet());
    private static final RequestProcessor RP = new RequestProcessor(ProjectWhiteListQueryImplementation.class.getName(), 3);

    public ProjectWhiteListQueryImplementation(NbModuleProject project) {
        this.project = project;
    }

    public WhiteListQueryImplementation.WhiteListImplementation getWhiteList(FileObject file) {
        ProjectXMLManager pxm = new ProjectXMLManager(this.project);
        if (System.getProperty("Enable-Whitelist") == null || !System.getProperty("Enable-Whitelist").equals("true")) {
            return null;
        }
        TreeSet<String> privatePackages = null;
        if (this.isCached) {
            TreeSet<String> treeSet = privatePackages = this.cachedPrivatePackages != null ? this.cachedPrivatePackages.get() : null;
        }
        if (privatePackages == null) {
            privatePackages = this.calculatePrivatePackageList(pxm, this.project.getProjectDirectory());
            this.cachedPrivatePackages = new SoftReference<TreeSet<String>>(privatePackages);
            this.isCached = true;
        }
        this.fireChangeAllExistingResults(privatePackages);
        ProjectWhiteListImplementation pwi = new ProjectWhiteListImplementation(privatePackages);
        this.results.add(pwi);
        return pwi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeAllExistingResults(final TreeSet<String> privatePackages) {
        HashSet<ProjectWhiteListImplementation> set;
        Set<ProjectWhiteListImplementation> set2 = this.results;
        synchronized (set2) {
            set = new HashSet<ProjectWhiteListImplementation>(this.results);
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                for (ProjectWhiteListImplementation res : set) {
                    if (res == null) continue;
                    res.changeData(privatePackages);
                }
            }
        });
    }

    private Manifest getManifest(FileObject root) {
        FileObject manifestFo = root.getFileObject("META-INF/MANIFEST.MF");
        if (manifestFo != null) {
            InputStream is = null;
            try {
                is = manifestFo.getInputStream();
                return new Manifest(is);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return null;
    }

    private TreeSet<String> getAllPackages(FileObject root) {
        TreeSet<String> toRet = new TreeSet<String>();
        this.processFolder(root, root, toRet);
        toRet.remove("");
        return toRet;
    }

    private void processFolder(FileObject root, FileObject folder, TreeSet<String> foundPackages) {
        FileObject fileObject;
        Enumeration it = folder.getData(false);
        while (it.hasMoreElements()) {
            fileObject = (FileObject)it.nextElement();
            if (!fileObject.hasExt("class")) continue;
            foundPackages.add(folder.getPath().replace('/', '.'));
            break;
        }
        it = folder.getFolders(false);
        while (it.hasMoreElements()) {
            fileObject = (FileObject)it.nextElement();
            this.processFolder(root, fileObject, foundPackages);
        }
    }

    private TreeSet<String> calculatePrivatePackageList(ProjectXMLManager pxm, FileObject project) {
        TreeSet<String> privatePackages = new TreeSet<String>();
        TreeSet<String> eqPublicPackages = new TreeSet<String>();
        TreeSet<String> subPublicPackages = new TreeSet<String>();
        TreeSet<String> allPackages = new TreeSet<String>();
        try {
            for (ModuleDependency depIter : pxm.getDirectDependencies()) {
                if (!depIter.hasImplementationDependency()) continue;
                for (String pkgNameIter : depIter.getModuleEntry().getAllPackageNames()) {
                    eqPublicPackages.add(pkgNameIter);
                }
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        ClassPath compileClassPath = ClassPath.getClassPath((FileObject)project, (String)"classpath/compile");
        for (FileObject rootIter : compileClassPath.getRoots()) {
            String publicPackagesStr = null;
            Manifest mf = this.getManifest(rootIter);
            if (mf == null || mf.getMainAttributes() == null) continue;
            Attributes attrs = mf.getMainAttributes();
            publicPackagesStr = attrs.getValue("OpenIDE-Module-Public-Packages");
            if (publicPackagesStr != null && !"".equals(publicPackagesStr)) {
                publicPackagesStr = publicPackagesStr.replaceAll(" ", "");
            }
            if (publicPackagesStr != null && !"-".equals(publicPackagesStr)) {
                StringTokenizer tokenizer = new StringTokenizer(publicPackagesStr, ",");
                while (tokenizer.hasMoreElements()) {
                    String packageIter = tokenizer.nextToken();
                    if (packageIter.endsWith(".**")) {
                        String sub = packageIter.substring(0, packageIter.length() - ".**".length());
                        subPublicPackages.add(sub);
                        continue;
                    }
                    if (!packageIter.endsWith(".*")) continue;
                    String eq = packageIter.substring(0, packageIter.length() - ".*".length());
                    if (eqPublicPackages.contains(packageIter)) continue;
                    eqPublicPackages.add(eq);
                }
            }
            allPackages.addAll(this.getAllPackages(rootIter));
        }
        for (String allPkgIter : allPackages) {
            boolean contains = false;
            for (String publicPkgIter : eqPublicPackages) {
                if (!allPkgIter.equals(publicPkgIter)) continue;
                contains = true;
                break;
            }
            if (!contains) {
                for (String publicPkgIter : subPublicPackages) {
                    if (!allPkgIter.startsWith(publicPkgIter)) continue;
                    contains = true;
                    break;
                }
            }
            if (contains) continue;
            privatePackages.add(allPkgIter);
        }
        ClassPath bootClassPath = ClassPath.getClassPath((FileObject)project, (String)"classpath/boot");
        TreeSet<String> bootClassPathPkgs = new TreeSet<String>();
        for (FileObject rootIter : bootClassPath.getRoots()) {
            bootClassPathPkgs.addAll(this.getAllPackages(rootIter));
        }
        privatePackages.removeAll(bootClassPathPkgs);
        return privatePackages;
    }

    private static class ProjectWhiteListImplementation
    implements WhiteListQueryImplementation.WhiteListImplementation {
        private TreeSet<String> privatePackages;
        private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
        private final Object IMPL_LOCK = new Object();

        public ProjectWhiteListImplementation(TreeSet<String> privatePackages) {
            this.privatePackages = privatePackages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WhiteListQuery.Result check(ElementHandle<?> element, WhiteListQuery.Operation operation) {
            String qualifiedName;
            if (!operation.equals((Object)WhiteListQuery.Operation.USAGE)) {
                return OK;
            }
            if (element != null && (element.getKind().isClass() || element.getKind().isInterface()) && (qualifiedName = element.getQualifiedName()) != null && qualifiedName.lastIndexOf(".") > 0) {
                qualifiedName = qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
                Object object = this.IMPL_LOCK;
                synchronized (object) {
                    if (this.privatePackages.contains(qualifiedName)) {
                        ArrayList<WhiteListQuery.RuleDescription> descs = new ArrayList<WhiteListQuery.RuleDescription>();
                        descs.add(new WhiteListQuery.RuleDescription("Private package dependency access", "Element comes from private package of spec version dependency", null));
                        return new WhiteListQuery.Result(descs);
                    }
                }
            }
            return OK;
        }

        public void addChangeListener(ChangeListener listener) {
            this.listeners.add(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.listeners.remove(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changeData(@NonNull TreeSet<String> privatePackages) {
            Object object = this.IMPL_LOCK;
            synchronized (object) {
                this.privatePackages = privatePackages;
            }
            ArrayList<ChangeListener> changes = new ArrayList<ChangeListener>();
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                changes.addAll(this.listeners);
            }
            for (ChangeListener change : changes) {
                change.stateChanged(new ChangeEvent(this));
            }
        }
    }
}

