/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.queries.Bundle;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class SubprojectProviderImpl
implements SubprojectProvider {
    private final NbModuleProject project;

    public SubprojectProviderImpl(NbModuleProject project) {
        this.project = project;
    }

    public Set<? extends Project> getSubprojects() {
        File jar;
        ModuleList ml;
        HashSet<Project> s = new HashSet<Project>();
        try {
            ml = this.project.getModuleList();
        }
        catch (IOException e) {
            Util.err.notify(1, (Throwable)e);
            DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)Bundle.WRN_problem_getting_module_list(), Bundle.TITLE_getting_module_list(), 2, 2, new Object[]{NotifyDescriptor.OK_OPTION}, null));
            return Collections.emptySet();
        }
        Element data = this.project.getPrimaryConfigurationData();
        Element moduleDependencies = XMLUtil.findElement((Element)data, (String)"module-dependencies", (String)"http://www.netbeans.org/ns/nb-module-project/3");
        assert (moduleDependencies != null) : "Malformed metadata in " + this.project;
        for (Element dep : XMLUtil.findSubElements((Element)moduleDependencies)) {
            Element cnbEl = XMLUtil.findElement((Element)dep, (String)"code-name-base", (String)"http://www.netbeans.org/ns/nb-module-project/3");
            String cnb = XMLUtil.findText((Node)cnbEl);
            ModuleEntry module = ml.getEntry(cnb);
            if (module == null) {
                Util.err.log(16, "Warning - could not find dependent module " + cnb + " for " + this.project);
                continue;
            }
            File moduleProjectDirF = module.getSourceLocation();
            if (moduleProjectDirF == null) continue;
            FileObject moduleProjectDir = FileUtil.toFileObject((File)moduleProjectDirF);
            if (moduleProjectDir == null) {
                Util.err.log(16, "Warning - could not load sources for dependent module " + cnb + " for " + this.project);
                continue;
            }
            try {
                Project moduleProject = ProjectManager.getDefault().findProject(moduleProjectDir);
                if (moduleProject == null) {
                    Util.err.log(16, "Warning - dependent module " + cnb + " for " + this.project + " is not projectized");
                    continue;
                }
                s.add(moduleProject);
            }
            catch (IOException e) {
                Logger.getLogger(SubprojectProviderImpl.class.getName()).log(Level.INFO, "Could not load dependent module " + cnb + " for " + this.project, e);
            }
        }
        for (Element cpext : XMLUtil.findSubElements((Element)data)) {
            Project owner;
            AntArtifact aa;
            Element binorig;
            if (!cpext.getTagName().equals("class-path-extension") || (binorig = XMLUtil.findElement((Element)cpext, (String)"binary-origin", (String)"http://www.netbeans.org/ns/nb-module-project/3")) == null) continue;
            String text = XMLUtil.findText((Node)binorig);
            String eval = this.project.evaluator().evaluate(text);
            if (eval == null || (aa = AntArtifactQuery.findArtifactFromFile((File)(jar = this.project.getHelper().resolveFile(eval)))) == null || (owner = aa.getProject()) == null) continue;
            s.add(owner);
        }
        String eval = this.project.evaluator().getProperty("cp.extra");
        if (eval != null) {
            for (String piece : PropertyUtils.tokenizePath((String)eval)) {
                Project owner;
                if (piece.contains("${") || (owner = FileOwnerQuery.getOwner((URI)Utilities.toURI((File)(jar = this.project.getHelper().resolveFile(piece))))) == null) continue;
                s.add(owner);
            }
        }
        return s;
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public void removeChangeListener(ChangeListener listener) {
    }
}

