/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.tomcat5.deploy.TomcatManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TomcatUsers {
    private TomcatUsers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createUser(File tomcatUsersFile, String username, String password, TomcatManager.TomcatVersion version) throws IOException {
        String roles;
        Document doc = TomcatUsers.getDocument(tomcatUsersFile);
        Element root = doc.getDocumentElement();
        Element userElement = TomcatUsers.findUserByName(root, username);
        if (userElement == null) {
            userElement = doc.createElement("user");
            userElement.setAttribute("username", username);
        }
        if ((roles = userElement.getAttribute("roles")) == null) {
            roles = "";
        }
        StringBuilder newRoles = new StringBuilder(roles.trim());
        if (TomcatManager.TomcatVersion.TOMCAT_70.equals((Object)version) || TomcatManager.TomcatVersion.TOMCAT_80.equals((Object)version)) {
            if (!TomcatUsers.hasRole(roles, "manager-script")) {
                if (newRoles.length() > 0 && !newRoles.toString().endsWith(",")) {
                    newRoles.append(',');
                }
                newRoles.append("manager-script");
            }
        } else if (!TomcatUsers.hasRole(roles, "manager")) {
            if (newRoles.length() > 0 && !newRoles.toString().endsWith(",")) {
                newRoles.append(',');
            }
            newRoles.append("manager");
        }
        if (!TomcatUsers.hasRole(roles, "admin")) {
            if (!newRoles.toString().endsWith(",")) {
                newRoles.append(',');
            }
            newRoles.append("admin");
        }
        userElement.setAttribute("roles", newRoles.toString());
        userElement.setAttribute("password", password);
        root.appendChild(userElement);
        FileObject fo = FileUtil.toFileObject((File)tomcatUsersFile);
        if (fo == null) {
            throw new IOException(NbBundle.getMessage(TomcatUsers.class, (String)"MSG_FileNotFound", (Object)tomcatUsersFile.getPath()));
        }
        try (OutputStream os = fo.getOutputStream();){
            XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
        }
    }

    public static boolean hasManagerRole(TomcatManager.TomcatVersion version, File tomcatUsersFile, String username) throws IOException {
        Document doc = TomcatUsers.getDocument(tomcatUsersFile);
        Element root = doc.getDocumentElement();
        NodeList users = root.getElementsByTagName("user");
        int length = users.getLength();
        for (int i = 0; i < length; ++i) {
            Element user = (Element)users.item(i);
            String name = user.getAttribute("name");
            if (name.length() == 0) {
                name = user.getAttribute("username");
            }
            if (!username.equals(name)) continue;
            String roles = user.getAttribute("roles");
            if (!(TomcatManager.TomcatVersion.TOMCAT_70.equals((Object)version) || TomcatManager.TomcatVersion.TOMCAT_80.equals((Object)version) ? TomcatUsers.hasRole(roles, "manager-script") : TomcatUsers.hasRole(roles, "manager"))) continue;
            return true;
        }
        return false;
    }

    public static boolean userExists(File tomcatUsersFile, String username) throws IOException {
        Document doc = TomcatUsers.getDocument(tomcatUsersFile);
        return TomcatUsers.findUserByName(doc.getDocumentElement(), username) != null;
    }

    private static Document getDocument(File tomcatUsersFile) throws IOException {
        FileObject fo = FileUtil.toFileObject((File)tomcatUsersFile);
        if (fo == null) {
            throw new IOException(NbBundle.getMessage(TomcatUsers.class, (String)"MSG_FileNotFound", (Object)tomcatUsersFile.getPath()));
        }
        XMLDataObject dobj = (XMLDataObject)DataObject.find((FileObject)fo);
        try {
            return dobj.getDocument();
        }
        catch (SAXException ex) {
            throw (IOException)new IOException().initCause(ex);
        }
    }

    private static Element findUserByName(Element root, String username) {
        NodeList users = root.getElementsByTagName("user");
        int length = users.getLength();
        for (int i = 0; i < length; ++i) {
            Element user = (Element)users.item(i);
            String name = user.getAttribute("name");
            if (name.length() == 0) {
                name = user.getAttribute("username");
            }
            if (!username.equals(name)) continue;
            return user;
        }
        return null;
    }

    private static boolean hasRole(String roles, String rolename) {
        for (String role : roles.split(",")) {
            if (!rolename.equals(role.trim())) continue;
            return true;
        }
        return false;
    }
}

