/**
 * This interface represents a document with a CSS view.The getOverrideStyle method provides a mechanism through which a DOM author could effect immediate change to the style of an element without modifying the explicitly linked style sheets of a document or the inline style of elements in the style sheets. This style sheet comes after the author style sheet in the cascade algorithm and is called override style sheet. The override style sheet takes precedence over author style sheets. An "!important" declaration still takes precedence over a normal declaration. Override, author, and user style sheets all may contain "!important" declarations. User "!important" rules take precedence over both override and author "!important" rules, and override "!important" rules take precedence over author "!important" rules.The expectation is that an instance of the DocumentCSS interface can be obtained by using binding-specific casting methods on an instance of the Document interface.
 */
var DocumentCSS = {
}
/**
 * This method is used to retrieve the override style declaration for a specified element and a specified pseudo-element.
 * @syntax documentCSS.getOverrideStyle(elt, pseudoElt)
 * @param {Element} elt The element whose style is to be modified. This parameter cannot be null.
 * @param {String} pseudoElt The pseudo-element or null if none.
 * @returns {CSSStyleDeclaration} The override style declaration.
 */
DocumentCSS.prototype.getOverrideStyle = function(elt,  pseudoElt) {};

/**
 * Represents the DocumentCSS prototype object.
 * @syntax DocumentCSS.prototype
 * @static
 */
DocumentCSS.prototype;

