/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

public class PackageDesc {
    private final String name;
    private final String part;
    private final boolean recursive;

    public PackageDesc(String name, String part, boolean recursive) {
        this.name = name;
        this.part = part;
        this.recursive = recursive;
    }

    public boolean matches(String className) {
        String pkName;
        if (this.name.equals(className)) {
            return true;
        }
        if (this.name.endsWith(".*") && className.startsWith(pkName = this.name.substring(0, this.name.length() - 1))) {
            String postfix = className.substring(pkName.length() + 1);
            if (this.recursive || -1 == postfix.indexOf(".")) {
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getPart() {
        return this.part;
    }

    public boolean isRecursive() {
        return this.recursive;
    }
}

