/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel.desktopintegrationeditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.jnlp.config.PathsAndFiles;
import net.sourceforge.jnlp.controlpanel.desktopintegrationeditor.Blinker;
import net.sourceforge.jnlp.controlpanel.desktopintegrationeditor.JListUtils;
import net.sourceforge.jnlp.controlpanel.desktopintegrationeditor.Panels;
import net.sourceforge.jnlp.controlpanel.desktopintegrationeditor.PreviewSelectionJTextPane;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.dialogs.SecurityDialogPanel;
import net.sourceforge.jnlp.util.XDesktopEntry;
import net.sourceforge.jnlp.util.logging.ConsoleOutputPaneModel;

public class FreeDesktopIntegrationEditorFrame
extends JFrame {
    private final JLabel title = new JLabel();
    private final JCheckBox selectRelativeRecordsFromOtherColumns = new JCheckBox();
    private final JButton removeSelectedButton = new JButton();
    private final JButton cleanAll = new JButton();
    private final JButton closeButton = new JButton();
    private final JButton reloadsListButton = new JButton();
    private final JButton selectAll = new JButton();
    private final JList menuList = new JListUtils.CustomRendererJList();
    private final JList desktopList = new JListUtils.CustomValidatingRendererJList();
    private final JList generatedList = new JListUtils.CustomRendererJList();
    private final JList iconsList = new JListUtils.CustomRendererWithIconJList();
    PreviewSelectionJTextPane previewPane = new PreviewSelectionJTextPane(this.iconsList, this.menuList, this.desktopList, this.generatedList);
    private final Blinker blinker;
    private boolean selecting = false;
    private final int expectedWidth = 800;
    private final int expectedHeight = 600;

    private void setListeners() {
        this.removeSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FreeDesktopIntegrationEditorFrame.this.removeSelected();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FreeDesktopIntegrationEditorFrame.this.dispose();
            }
        });
        this.reloadsListButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FreeDesktopIntegrationEditorFrame.this.populateLists();
            }
        });
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FreeDesktopIntegrationEditorFrame.this.selectAll();
            }
        });
        this.cleanAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FreeDesktopIntegrationEditorFrame.this.cleanAll();
            }
        });
    }

    private void setTexts() {
        this.setTitle(Translator.R("DIMtitle"));
        this.closeButton.setText(Translator.R("ButClose"));
        this.removeSelectedButton.setText(Translator.R("DIMremoveSelected"));
        this.selectRelativeRecordsFromOtherColumns.setText(Translator.R("DIMselectRelativeRecordsFromOtherColumns"));
        this.reloadsListButton.setText(Translator.R("DIMreloadLists"));
        this.selectAll.setText(Translator.R("DIMselectAll"));
        this.cleanAll.setText(Translator.R("DIMclearSelection"));
        this.title.setText(SecurityDialogPanel.htmlWrap("<p>" + Translator.R("DIMdescription") + "</p>"));
    }

    private JPanel createMainControls() {
        JPanel mainControls = new JPanel(new GridLayout(1, 2));
        mainControls.add(this.closeButton);
        mainControls.add(this.removeSelectedButton);
        return mainControls;
    }

    private JPanel createMiddleToolBox() {
        JPanel middleToolBox = new JPanel(new GridLayout(1, 2));
        middleToolBox.add(this.selectRelativeRecordsFromOtherColumns);
        middleToolBox.add(this.reloadsListButton);
        middleToolBox.add(this.selectAll);
        middleToolBox.add(this.cleanAll);
        return middleToolBox;
    }

    private JPanel createPreviewPanel(JTextPane previewPane) {
        JPanel previewPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setViewportView(previewPane);
        previewPanel.add((Component)jScrollPane2, "Center");
        this.createMiddleToolBox();
        previewPanel.add((Component)this.createMiddleToolBox(), "First");
        return previewPanel;
    }

    private JSplitPane createListsLayout() {
        JPanel menusPanel = Panels.createMenuPanel(this.menuList, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FreeDesktopIntegrationEditorFrame.this.selectSomeRelatives(FreeDesktopIntegrationEditorFrame.this.menuList.getSelectedValuesList(), FreeDesktopIntegrationEditorFrame.this.iconsList);
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FreeDesktopIntegrationEditorFrame.this.selectSomeRelatives(FreeDesktopIntegrationEditorFrame.this.menuList.getSelectedValuesList(), FreeDesktopIntegrationEditorFrame.this.generatedList);
            }
        });
        JPanel desktopsPanel = Panels.createDesktopPanel(this.desktopList, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FreeDesktopIntegrationEditorFrame.this.selectSomeRelatives(FreeDesktopIntegrationEditorFrame.this.desktopList.getSelectedValuesList(), FreeDesktopIntegrationEditorFrame.this.iconsList);
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FreeDesktopIntegrationEditorFrame.this.selectSomeRelatives(FreeDesktopIntegrationEditorFrame.this.desktopList.getSelectedValuesList(), FreeDesktopIntegrationEditorFrame.this.generatedList);
            }
        });
        JPanel iconsPanel = Panels.createIconsPanel(this.iconsList, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FreeDesktopIntegrationEditorFrame.this.findOrphans(FreeDesktopIntegrationEditorFrame.this.iconsList, new List[]{FreeDesktopIntegrationEditorFrame.this.allItemsAsFiles(FreeDesktopIntegrationEditorFrame.this.menuList), FreeDesktopIntegrationEditorFrame.this.allItemsAsFiles(FreeDesktopIntegrationEditorFrame.this.desktopList)});
            }
        });
        JPanel generatedsPanel = Panels.createGeneratedPanel(this.generatedList, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FreeDesktopIntegrationEditorFrame.this.findOrphans(FreeDesktopIntegrationEditorFrame.this.generatedList, new List[]{FreeDesktopIntegrationEditorFrame.this.allItemsAsFiles(FreeDesktopIntegrationEditorFrame.this.menuList), FreeDesktopIntegrationEditorFrame.this.allItemsAsFiles(FreeDesktopIntegrationEditorFrame.this.desktopList)});
            }
        });
        return Panels.createQuadroSplit(800, menusPanel, desktopsPanel, iconsPanel, generatedsPanel);
    }

    private void setLayout() {
        this.createMainControls();
        this.getContentPane().add((Component)this.createMainControls(), "Last");
        JSplitPane splitListsAndPreview = new JSplitPane(0);
        splitListsAndPreview.setLeftComponent(this.createListsLayout());
        splitListsAndPreview.setRightComponent(this.createPreviewPanel(this.previewPane));
        this.getContentPane().add((Component)splitListsAndPreview, "Center");
        this.getContentPane().add((Component)this.title, "First");
        splitListsAndPreview.setDividerLocation(300);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FreeDesktopIntegrationEditorFrame().setVisible(true);
            }
        });
    }

    public FreeDesktopIntegrationEditorFrame() {
        this.setDefaultCloseOperation(2);
        this.setSize(800, 600);
        this.populateLists();
        this.setTexts();
        this.setListeners();
        this.setLayout();
        this.selectRelativeRecordsFromOtherColumns.setSelected(true);
        GeneratePreviewListener generatePreviewListener = new GeneratePreviewListener();
        this.iconsList.addListSelectionListener(generatePreviewListener);
        this.desktopList.addListSelectionListener(generatePreviewListener);
        this.menuList.addListSelectionListener(generatePreviewListener);
        this.generatedList.addListSelectionListener(generatePreviewListener);
        this.blinker = new Blinker(this.selectRelativeRecordsFromOtherColumns);
    }

    private void populateLists() {
        this.menuList.setModel(new JListUtils.InfrastructureFileDescriptorListingBasedJListModel(PathsAndFiles.MENUS_DIR));
        this.desktopList.setModel(new JListUtils.FileListBasedJListModel(new File(XDesktopEntry.findFreedesktopOrgDesktopPathCatch()), "(?i)^.*\\.desktop$"){

            @Override
            public String toString() {
                return Translator.R("DIMguessedDesktop");
            }
        });
        this.iconsList.setModel(new JListUtils.InfrastructureFileDescriptorListingBasedJListModel(PathsAndFiles.ICONS_DIR));
        this.generatedList.setModel(new JListUtils.InfrastructureFileDescriptorListingBasedJListModel(PathsAndFiles.GEN_JNLPS_DIR));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanAll() {
        this.selecting = true;
        try {
            this.clearAll();
        }
        finally {
            this.selecting = false;
        }
    }

    private void clearAll() {
        this.desktopList.clearSelection();
        this.menuList.clearSelection();
        this.generatedList.clearSelection();
        this.iconsList.clearSelection();
        this.previewPane.setText(Translator.R("DIMselectionPreview"));
    }

    private void removeSelected() {
        int a = this.getTotal(this.objectListToFileList(this.iconsList.getSelectedValuesList()), this.objectListToFileList(this.menuList.getSelectedValuesList()), this.objectListToFileList(this.desktopList.getSelectedValuesList()), this.objectListToFileList(this.generatedList.getSelectedValuesList()));
        if (a <= 0) {
            return;
        }
        int x = JOptionPane.showConfirmDialog(this, Translator.R("DIMaskBeforeDelete", a));
        if (x == 0 || x == 0) {
            this.removeSelected(this.objectListToFileList(this.iconsList.getSelectedValuesList()), this.objectListToFileList(this.menuList.getSelectedValuesList()), this.objectListToFileList(this.desktopList.getSelectedValuesList()), this.objectListToFileList(this.generatedList.getSelectedValuesList()));
            this.populateLists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectAll() {
        this.selecting = true;
        try {
            this.selectAll(this.menuList);
            this.selectAll(this.desktopList);
            this.selectAll(this.iconsList);
            this.selectAll(this.generatedList);
        }
        finally {
            this.selecting = false;
        }
        this.previewPane.generatePreview();
    }

    public List<File> allItemsAsFiles(JList l) {
        return this.allItemsAsFiles(l.getModel());
    }

    public List<File> allItemsAsFiles(ListModel l) {
        ArrayList<File> r = new ArrayList<File>(l.getSize());
        for (int i = 0; i < l.getSize(); ++i) {
            r.add((File)l.getElementAt(i));
        }
        return r;
    }

    private List<File> objectListToFileList(List l) {
        ArrayList<File> r = new ArrayList<File>(l.size());
        for (Object l1 : l) {
            r.add((File)l1);
        }
        return r;
    }

    private void removeSelected(List<File> ... a) {
        for (List<File> list : a) {
            for (File file : list) {
                file.delete();
            }
        }
    }

    private int getTotal(List<File> ... a) {
        int i = 0;
        for (List<File> list : a) {
            i += list.size();
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findOrphans(JList possibleOrphans, List<File> ... whereItCanBe) {
        this.selecting = true;
        if (this.selectRelativeRecordsFromOtherColumns.isSelected()) {
            this.clearAll();
            this.blinker.blink();
        }
        try {
            possibleOrphans.clearSelection();
            List<File> l = this.allItemsAsFiles(possibleOrphans);
            for (int i = 0; i < l.size(); ++i) {
                File file = l.get(i);
                boolean found = false;
                block4: for (List<File> lf : whereItCanBe) {
                    if (found) break;
                    for (File f : lf) {
                        String s = FreeDesktopIntegrationEditorFrame.fileToString(f, false);
                        if (!s.contains(file.getAbsolutePath())) continue;
                        found = true;
                        continue block4;
                    }
                }
                if (found) continue;
                possibleOrphans.addSelectionInterval(i, i);
            }
        }
        finally {
            this.selecting = false;
        }
        this.previewPane.generatePreview();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectSomeRelatives(List selected, JList target) {
        this.selecting = true;
        try {
            this.selectFileFromShortcuts(selected, target);
        }
        finally {
            this.selecting = false;
        }
        this.previewPane.generatePreview();
    }

    private void selectAll(JList list) {
        int start = 0;
        int end = list.getModel().getSize() - 1;
        if (end >= 0) {
            list.setSelectionInterval(start, end);
        }
    }

    private void selectRelatives(Object source) {
        if (source instanceof JList) {
            int[] indexes = ((JList)source).getSelectedIndices();
            this.clearAll();
            ((JList)source).setSelectedIndices(indexes);
        }
        for (int x = 1; x <= 3; ++x) {
            this.selectShortcutsByFiles(this.objectListToFileList(this.iconsList.getSelectedValuesList()), this.objectListToFileList(this.generatedList.getSelectedValuesList()));
            this.selectFilesByShortcuts(this.objectListToFileList(this.menuList.getSelectedValuesList()), this.objectListToFileList(this.desktopList.getSelectedValuesList()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String fileToString(File f, boolean escape) {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(f));){
            StringBuilder sb = new StringBuilder();
            while (true) {
                String line;
                if ((line = bufferedReader.readLine()) == null) {
                    String string = sb.toString();
                    return string;
                }
                if (escape) {
                    line = ConsoleOutputPaneModel.escapeHtmlForJTextPane(line);
                }
                sb.append(line).append("\n");
                continue;
                break;
            }
        }
        catch (Exception ex) {
            return ex.toString();
        }
    }

    private void selectShortcutsByFiles(List<File> icons, List<File> jnlps) {
        this.selectShortcutsWithFiles(icons, this.desktopList);
        this.selectShortcutsWithFiles(icons, this.menuList);
        this.selectShortcutsWithFiles(jnlps, this.desktopList);
        this.selectShortcutsWithFiles(jnlps, this.menuList);
    }

    private void selectFilesByShortcuts(List<File> menu, List<File> desktop) {
        this.selectFileFromShortcuts(desktop, this.iconsList);
        this.selectFileFromShortcuts(desktop, this.generatedList);
        this.selectFileFromShortcuts(menu, this.iconsList);
        this.selectFileFromShortcuts(menu, this.generatedList);
    }

    private void selectShortcutsWithFiles(List<File> icons, JList list) {
        for (int i = 0; i < list.getModel().getSize(); ++i) {
            File item = (File)list.getModel().getElementAt(i);
            String s = FreeDesktopIntegrationEditorFrame.fileToString(item, false);
            for (File icon : icons) {
                if (!s.contains(icon.getAbsolutePath())) continue;
                list.addSelectionInterval(i, i);
            }
        }
    }

    private void selectFileFromShortcuts(List<File> shortcuts, JList files) {
        for (File shortcut : shortcuts) {
            String s = FreeDesktopIntegrationEditorFrame.fileToString(shortcut, false);
            for (int i = 0; i < files.getModel().getSize(); ++i) {
                File item = (File)files.getModel().getElementAt(i);
                if (!s.contains(item.getAbsolutePath())) continue;
                files.addSelectionInterval(i, i);
            }
        }
    }

    private class GeneratePreviewListener
    implements ListSelectionListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (FreeDesktopIntegrationEditorFrame.this.selecting) {
                return;
            }
            try {
                FreeDesktopIntegrationEditorFrame.this.selecting = true;
                if (FreeDesktopIntegrationEditorFrame.this.selectRelativeRecordsFromOtherColumns.isSelected()) {
                    FreeDesktopIntegrationEditorFrame.this.blinker.blink();
                    FreeDesktopIntegrationEditorFrame.this.selectRelatives(e.getSource());
                }
            }
            finally {
                FreeDesktopIntegrationEditorFrame.this.selecting = false;
            }
            FreeDesktopIntegrationEditorFrame.this.previewPane.generatePreview();
        }
    }
}

