/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.appletextendedsecurity;

import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.config.PathsAndFiles;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.appletextendedsecurity.AppletSecurityLevel;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletActionStorage;
import net.sourceforge.jnlp.security.appletextendedsecurity.impl.UnsignedAppletActionStorageImpl;
import net.sourceforge.jnlp.util.lockingfile.StorageIoException;

public class AppletStartupSecuritySettings {
    private static final AppletStartupSecuritySettings instance = new AppletStartupSecuritySettings();
    private UnsignedAppletActionStorageImpl globalInstance;
    private UnsignedAppletActionStorageImpl customInstance;

    public static AppletStartupSecuritySettings getInstance() {
        return instance;
    }

    public static AppletSecurityLevel getHardcodedDefaultSecurityLevel() {
        return AppletSecurityLevel.getDefault();
    }

    public UnsignedAppletActionStorage getUnsignedAppletActionGlobalStorage() {
        if (this.globalInstance == null) {
            this.globalInstance = new UnsignedAppletActionStorageImpl(PathsAndFiles.APPLET_TRUST_SETTINGS_SYS.getFile());
        }
        return this.globalInstance;
    }

    public UnsignedAppletActionStorage getUnsignedAppletActionCustomStorage() {
        if (this.customInstance == null) {
            this.customInstance = new UnsignedAppletActionStorageImpl(PathsAndFiles.APPLET_TRUST_SETTINGS_USER.getFile());
        }
        return this.customInstance;
    }

    public AppletSecurityLevel getSecurityLevel() {
        DeploymentConfiguration conf = JNLPRuntime.getConfiguration();
        if (conf == null) {
            throw new StorageIoException("JNLPRuntime configuration is null. Try to reinstall IcedTea-Web");
        }
        String s = conf.getProperty("deployment.security.level");
        if (s == null) {
            return AppletStartupSecuritySettings.getHardcodedDefaultSecurityLevel();
        }
        return AppletSecurityLevel.fromString(s);
    }
}

