/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.sourceforge.jnlp.util.logging.LogConfig;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.jnlp.util.logging.SingleStreamLogger;
import net.sourceforge.jnlp.util.logging.filelogs.LogBasedFileLog;
import net.sourceforge.jnlp.util.logging.filelogs.WriterBasedFileLog;
import net.sourceforge.jnlp.util.logging.headers.Header;

public final class FileLog {
    public static final SimpleDateFormat fileLogNameFormatter = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.S");
    public static final SimpleDateFormat pluginSharedFormatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss ZZZ yyyy");
    public static final String defaultloggerName = "icedtea-web file-logger";

    public static Header getHeadlineHeader() {
        return new Header(OutputController.Level.WARNING_ALL, Thread.currentThread().getStackTrace(), Thread.currentThread(), false);
    }

    public static SingleStreamLogger createFileLog() {
        return FileLog.createFileLog("javantx");
    }

    public static SingleStreamLogger createAppFileLog() {
        return FileLog.createFileLog("clienta");
    }

    private static SingleStreamLogger createFileLog(String id) {
        SingleStreamLogger s;
        try {
            s = LogConfig.getLogConfig().isLegacyLogBasedFileLog() ? new LogBasedFileLog(defaultloggerName, FileLog.getFileName(id), false) : new WriterBasedFileLog(defaultloggerName, FileLog.getFileName(id), false);
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
            s = new SingleStreamLoggerImpl();
        }
        return s;
    }

    private static String getFileName(String id) {
        return LogConfig.getLogConfig().getIcedteaLogDir() + "itw-" + id + "-" + FileLog.getStamp() + ".log";
    }

    public static String getStamp() {
        return fileLogNameFormatter.format(new Date());
    }

    public static SimpleDateFormat getFileLogNameFormatter() {
        return fileLogNameFormatter;
    }

    public static SimpleDateFormat getPluginSharedFormatter() {
        return pluginSharedFormatter;
    }

    private static final class SingleStreamLoggerImpl
    implements SingleStreamLogger {
        @Override
        public void log(String s) {
        }

        @Override
        public void close() {
        }
    }
}

