/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.optionparser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.jnlp.OptionsDefinitions;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.optionparser.ParsedOption;
import net.sourceforge.jnlp.util.optionparser.UnevenParameterException;

public class OptionParser {
    private final String[] args;
    private final List<ParsedOption> parsedOptions;
    private final List<OptionsDefinitions.OPTIONS> possibleOptions;
    private final List<String> mainArgumentList = new ArrayList<String>();
    private boolean evenNumberFound;

    public OptionParser(String[] args, List<OptionsDefinitions.OPTIONS> options) throws UnevenParameterException {
        this.args = Arrays.copyOf(args, args.length);
        this.possibleOptions = options;
        this.evenNumberFound = false;
        this.parsedOptions = new ArrayList<ParsedOption>();
        this.parseContents();
        if (this.evenNumberFound) {
            this.checkOptionHasEvenNumber();
        }
    }

    private void parseContents() {
        ParsedOption lastOption = null;
        for (String arg : this.args) {
            if (this.isOption(arg)) {
                lastOption = this.addOptionToList(arg);
                continue;
            }
            if (this.shouldAddParam(lastOption)) {
                lastOption.addParam(arg);
                continue;
            }
            if (this.isEvenNumberSupportingEqualsChars(lastOption)) {
                this.evenNumberFound = true;
                this.handleEvenNumberSupportingEqualsChar(lastOption, arg);
                continue;
            }
            this.mainArgumentList.add(arg);
        }
    }

    private void handleEvenNumberSupportingEqualsChar(ParsedOption lastOption, String arg) {
        if (arg.contains("=")) {
            lastOption.addParam(arg.split("=")[0]);
            lastOption.addParam(arg.split("=", 2)[1]);
        } else {
            lastOption.addParam(arg);
        }
    }

    private boolean shouldAddParam(ParsedOption lastOption) {
        return lastOption != null && (this.oneOrMoreArguments(lastOption) || this.isOneArgumentNotFull(lastOption));
    }

    private boolean isOneArgumentNotFull(ParsedOption lastOption) {
        return lastOption.getOption().hasOneArgument() && lastOption.getParams().size() == 0;
    }

    private boolean oneOrMoreArguments(ParsedOption lastOption) {
        return lastOption.getOption().hasOneOrMoreArguments();
    }

    private boolean isEvenNumberSupportingEqualsChars(ParsedOption lastOption) {
        return lastOption != null && lastOption.getOption().hasEvenNumberSupportingEqualsChar();
    }

    private ParsedOption addOptionToList(String arg) {
        ParsedOption option = new ParsedOption(this.argumentToOption(arg));
        if (arg.contains("=")) {
            option.addParam(arg.split("=", 2)[1]);
        }
        this.parsedOptions.add(option);
        return option;
    }

    private void checkOptionHasEvenNumber() throws UnevenParameterException {
        for (ParsedOption option : this.parsedOptions) {
            if (!this.isEvenNumberSupportingEqualsChars(option) || option.getParams().size() % 2 == 0) continue;
            throw new UnevenParameterException(Translator.R("OPUnevenParams", option.getOption().option));
        }
    }

    private OptionsDefinitions.OPTIONS argumentToOption(String arg) {
        for (OptionsDefinitions.OPTIONS opt : this.possibleOptions) {
            if (!OptionParser.stringEqualsOption(arg, opt)) continue;
            return opt;
        }
        return null;
    }

    private boolean isOption(String input) {
        return this.argumentToOption(input) != null;
    }

    protected static boolean stringEqualsOption(String input, OptionsDefinitions.OPTIONS opt) {
        String option = OptionParser.removeLeadingHyphens(opt.option);
        input = OptionParser.removeLeadingHyphens(input).split("=")[0];
        return input.equals(option);
    }

    private static String removeLeadingHyphens(String input) {
        return input.replaceAll("^-*", "");
    }

    public boolean hasOption(OptionsDefinitions.OPTIONS option) {
        for (ParsedOption parsed : this.parsedOptions) {
            if (option != parsed.getOption()) continue;
            return true;
        }
        return false;
    }

    public boolean mainArgExists() {
        return this.mainArgumentList.size() > 0;
    }

    public String getMainArg() {
        if (this.mainArgExists()) {
            return this.mainArgumentList.get(0);
        }
        return "";
    }

    public List<String> getMainArgs() {
        return new ArrayList<String>(this.mainArgumentList);
    }

    public String getParam(OptionsDefinitions.OPTIONS option) {
        List<String> params = this.getParams(option);
        if (params.size() > 0) {
            return this.getParams(option).get(0);
        }
        return "";
    }

    public List<String> getParams(OptionsDefinitions.OPTIONS option) {
        ArrayList<String> result = new ArrayList<String>();
        for (ParsedOption parsed : this.parsedOptions) {
            if (parsed.getOption() != option) continue;
            for (String param : parsed.getParams()) {
                result.add(param);
            }
        }
        return result;
    }

    public int getNumberOfOptions() {
        return this.parsedOptions.size();
    }

    public void addOption(OptionsDefinitions.OPTIONS options, String ... params) {
        ParsedOption x = new ParsedOption(options);
        for (String string : params) {
            x.addParam(string);
        }
        this.parsedOptions.add(x);
    }
}

