# This file is part of lyx2lyx
# -*- coding: utf-8 -*-
# Copyright (C) 2006 José Matos <jamatos@lyx.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

""" This module parses lib/languages and prints it as a python
dictionary, ready to use by other python modules"""

import pprint

def parse_line(line):
    " Parse line from languages and return it as a list. "
    j = 0
    tmp = []
    while j< len(line):
        token = line[j:].split()[0]
        if not token:
            break
        if token[0] != '"':
            tmp.append(token)
            j += len(token) + 1
        elif line[j+1:].find('"') != -1:
            k = line.find('"', j + 1)
            tmp.append(line[j+1:k])
            j = k + 1
        else:
            tmp.append(line[j+1:])
            break

        while j < len(line) and line[j].isspace():
            j += 1

    return tmp


if __name__ == '__main__':  
    lines = open("../languages", "rb")
    lang = {}
    for line in lines:
        if line[:1] != '#':
            tmp = parse_line(line[:-1])
            lang[tmp[0]] = tmp[1:]


    print "# This file is generated by generate_incoding_info.py from lib/languages file."
    print "# Do not change this file directly."
    print
    print "lang = ",
    pprint.pprint(lang)
