// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Units_ShiftedToken_HeaderFile
#define _Units_ShiftedToken_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Units_ShiftedToken.hxx>

#include <Standard_Real.hxx>
#include <Units_Token.hxx>
#include <Standard_CString.hxx>
#include <Handle_Units_Dimensions.hxx>
#include <Handle_Units_Token.hxx>
#include <Standard_Integer.hxx>
class Units_Dimensions;
class Units_Token;


//! The  ShiftedToken class  inherits   from Token and
//! describes tokens which have  a gap in  addition of
//! the  multiplicative factor.   This kind  of  token
//! allows  the  description of linear functions which
//! do not pass through the origin, of the form :
//!
//! y = ax  +b
//!
//! where <x> and  <y>  are the unknown variables, <a>
//! the mutiplicative factor, and <b> the gap relative
//! to the ordinate axis.
//!
//! An example is the  tranlation between the  Celsius
//! and Fahrenheit degree of temperature.
class Units_ShiftedToken : public Units_Token
{

public:

  
  //! Creates and returns a  shifted   token.  <aword> is  a
  //! string containing the   available word, <amean>  gives
  //! the signification   of the   token,  <avalue> is   the
  //! numeric value  of the  dimension, <amove> is  the gap,
  //! and <adimensions> is  the dimension of the given  word
  //! <aword>.
  Standard_EXPORT Units_ShiftedToken(const Standard_CString aword, const Standard_CString amean, const Standard_Real avalue, const Standard_Real amove, const Handle(Units_Dimensions)& adimensions);
  
  //! Creates and returns a  token, which is a ShiftedToken.
  Standard_EXPORT virtual   Handle(Units_Token) Creates()  const;
  
  //! Returns the gap <themove>
  Standard_EXPORT   Standard_Real Move()  const;
  
  //! This  virtual   method  is  called  by the Measurement
  //! methods,  to   compute  the   measurement    during  a
  //! conversion.
  Standard_EXPORT virtual   Standard_Real Multiplied (const Standard_Real avalue)  const;
  
  //! This   virtual  method is  called  by  the Measurement
  //! methods,   to   compute   the   measurement   during a
  //! conversion.
  Standard_EXPORT virtual   Standard_Real Divided (const Standard_Real avalue)  const;
  
  //! Destroies the Token
  Standard_EXPORT virtual   void Destroy() ;
~Units_ShiftedToken()
{
  Destroy();
}
  
  Standard_EXPORT virtual   void Dump (const Standard_Integer ashift, const Standard_Integer alevel)  const;



  DEFINE_STANDARD_RTTI(Units_ShiftedToken)

protected:




private: 


  Standard_Real themove;


};







#endif // _Units_ShiftedToken_HeaderFile
