/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;

public abstract class AbstractLanguageConcurrencyTest {
    volatile int failedTests;

    protected abstract Language createLanguage();

    protected abstract String createSampleText();

    @Test
    public void testSpellCheckerFailure() throws Exception {
        String sampleText = this.createSampleText();
        Language language = this.createLanguage();
        int threadCount = Runtime.getRuntime().availableProcessors() * 10;
        int testRuns = 100;
        ReentrantReadWriteLock testWaitLock = new ReentrantReadWriteLock();
        Lock testWriteLock = testWaitLock.writeLock();
        testWriteLock.lock();
        this.failedTests = 0;
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < threadCount; ++i) {
            Thread t = new Thread(new TestRunner(testWaitLock, language, 100, sampleText));
            t.start();
            threads.add(t);
        }
        testWriteLock.unlock();
        for (Thread t : threads) {
            t.join();
        }
        Assert.assertEquals((long)0L, (long)this.failedTests);
    }

    final class TestRunner
    implements Runnable {
        private final ReadWriteLock waitLock;
        private final Language language;
        private final int testRuns;
        private final String sampleText;

        TestRunner(ReadWriteLock waitLock, Language language, int testRuns, String sampleText) {
            this.waitLock = waitLock;
            this.language = language;
            this.testRuns = testRuns;
            this.sampleText = sampleText;
        }

        @Override
        public void run() {
            Lock lock = this.waitLock.readLock();
            lock.lock();
            lock.unlock();
            for (int i = 0; i < this.testRuns; ++i) {
                try {
                    JLanguageTool tool = new JLanguageTool(this.language);
                    Assert.assertNotNull((Object)tool.check(this.sampleText));
                    continue;
                }
                catch (Exception e) {
                    ++AbstractLanguageConcurrencyTest.this.failedTests;
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

