/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import java.util.Hashtable;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.StyleConverter;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.latex.util.Context;
import writer2latex.latex.util.StyleMap;
import writer2latex.office.FontDeclaration;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.Misc;

public class CharStyleConverter
extends StyleConverter {
    private Hashtable<String, String> fontDecls = new Hashtable();
    private boolean bIgnoreHardFontsize;
    private boolean bIgnoreFontsize;
    private boolean bIgnoreFont;
    private boolean bIgnoreAll;
    private boolean bUseUlem;
    private boolean bNeedUlem = false;
    private boolean bNeedSubscript = false;

    public CharStyleConverter(OfficeReader ofr, LaTeXConfig config, ConverterPalette palette) {
        super(ofr, config, palette);
        this.bUseUlem = config.useUlem();
        this.bIgnoreAll = config.formatting() == 0;
        this.bIgnoreFont = config.formatting() <= 1;
        this.bIgnoreFontsize = config.formatting() <= 2;
        this.bIgnoreHardFontsize = config.formatting() <= 3;
    }

    @Override
    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bNeedUlem) {
            pack.append("\\usepackage[normalem]{ulem}").nl();
        }
        if (this.bNeedSubscript && !this.config.getTextAttributeStyleMap().contains("subscript")) {
            decl.append("\\newcommand\\textsubscript[1]{\\ensuremath{{}_{\\text{#1}}}}").nl();
        }
        if (!this.styleNames.isEmpty()) {
            decl.append("% Text styles").nl().append(this.declarations);
        }
    }

    public void applyTextStyle(String sName, BeforeAfter ba, Context context) {
        if (sName == null) {
            return;
        }
        String sDisplayName = this.ofr.getTextStyles().getDisplayName(sName);
        if (this.bIgnoreAll) {
            StyleMap sm = this.config.getTextStyleMap();
            if (sm.contains(sDisplayName)) {
                ba.add(sm.getBefore(sDisplayName), sm.getAfter(sDisplayName));
                context.setVerbatim(sm.getVerbatim(sDisplayName));
                context.setNoLineBreaks(sm.getVerbatim(sDisplayName));
            }
            return;
        }
        if (this.styleMap.contains(sName)) {
            ba.add(this.styleMap.getBefore(sName), this.styleMap.getAfter(sName));
            context.updateFormattingFromStyle(this.ofr.getTextStyle(sName));
            StyleMap sm = this.config.getTextStyleMap();
            boolean bIsVerbatim = sm.contains(sDisplayName) && sm.getVerbatim(sDisplayName);
            context.setVerbatim(bIsVerbatim);
            context.setNoLineBreaks(bIsVerbatim);
            return;
        }
        StyleMap sm = this.config.getTextStyleMap();
        if (sm.contains(sDisplayName)) {
            this.styleMap.put(sName, sm.getBefore(sDisplayName), sm.getAfter(sDisplayName));
            this.applyTextStyle(sName, ba, context);
            return;
        }
        StyleWithProperties style = this.ofr.getTextStyle(sName);
        if (style == null) {
            this.styleMap.put(sName, "", "");
            this.applyTextStyle(sName, ba, context);
            return;
        }
        if (style.isAutomatic()) {
            this.palette.getI18n().applyLanguage(style, false, true, ba);
            this.applyFont(style, false, true, ba, context);
            this.applyFontEffects(style, true, ba);
            context.updateFormattingFromStyle(this.ofr.getTextStyle(sName));
            return;
        }
        BeforeAfter baText = new BeforeAfter();
        this.palette.getI18n().applyLanguage(style, false, true, baText);
        this.applyFont(style, false, true, baText, new Context());
        this.applyFontEffects(style, true, baText);
        String sTeXName = this.styleNames.getExportName(this.ofr.getTextStyles().getDisplayName(sName));
        this.styleMap.put(sName, "\\textstyle" + sTeXName + "{", "}");
        this.declarations.append("\\newcommand\\textstyle").append(sTeXName).append("[1]{").append(baText.getBefore()).append("#1").append(baText.getAfter()).append("}").nl();
        this.applyTextStyle(sName, ba, context);
    }

    public String getFontName(StyleWithProperties style) {
        FontDeclaration fd;
        String sName;
        if (style != null && (sName = style.getProperty("style:font-name")) != null && (fd = this.ofr.getFontDeclaration(sName)) != null) {
            return fd.getFontFamily();
        }
        return null;
    }

    public String getFontName(String sStyleName) {
        return this.getFontName(this.ofr.getTextStyle(sStyleName));
    }

    public void applyHardCharFormatting(StyleWithProperties style, BeforeAfter ba) {
        this.palette.getI18n().applyLanguage(style, true, false, ba);
        this.applyFont(style, true, false, ba, new Context());
        if (!ba.isEmpty()) {
            ba.add(" ", "");
        }
    }

    public void applyFont(StyleWithProperties style, boolean bDecl, boolean bInherit, BeforeAfter ba, Context context) {
        if (style == null) {
            return;
        }
        this.applyNfssSize(style, bDecl, bInherit, ba, context);
        this.applyNfssFamily(style, bDecl, bInherit, ba, context);
        this.applyNfssSeries(style, bDecl, bInherit, ba, context);
        this.applyNfssShape(style, bDecl, bInherit, ba, context);
        this.palette.getColorCv().applyColor(style, bDecl, bInherit, ba, context);
    }

    public void applyNormalFont(BeforeAfter ba) {
        ba.add("\\normalfont\\normalsize", "");
        this.palette.getColorCv().applyNormalColor(ba);
    }

    public void applyDefaultFont(StyleWithProperties style, LaTeXDocumentPortion ldp) {
        if (style == null) {
            return;
        }
        String s = this.convertFontDeclaration(style.getProperty("style:font-name"));
        if (s != null) {
            ldp.append("\\renewcommand\\familydefault{\\").append(s).append("default}").nl();
        }
        if ((s = CharStyleConverter.nfssSeries(style.getProperty("fo:font-weight"))) != null) {
            ldp.append("\\renewcommand\\seriesdefault{\\").append(s).append("default}").nl();
        }
        if ((s = CharStyleConverter.nfssShape(style.getProperty("fo:font-variant"), style.getProperty("fo:font-style"))) != null) {
            ldp.append("\\renewcommand\\shapedefault{\\").append(s).append("default}").nl();
        }
        this.palette.getColorCv().setNormalColor(style.getProperty("fo:color"), ldp);
    }

    public void applyFontEffects(StyleWithProperties style, boolean bInherit, BeforeAfter ba) {
        if (style == null) {
            return;
        }
        this.applyTextPosition(style, bInherit, ba);
        this.applyUnderline(style, bInherit, ba);
        this.applyCrossout(style, bInherit, ba);
        this.applyChangeCase(style, bInherit, ba);
    }

    private void applyNfssFamily(StyleWithProperties style, boolean bDecl, boolean bInherit, BeforeAfter ba, Context context) {
        if (style == null || this.bIgnoreFont) {
            return;
        }
        String sFontName = style.getProperty("style:font-name", bInherit);
        if (sFontName != null) {
            String sFamily = this.convertFontDeclaration(sFontName);
            if (sFamily == null) {
                return;
            }
            if (sFamily.equals(this.convertFontDeclaration(context.getFontName()))) {
                return;
            }
            if (bDecl) {
                ba.add("\\" + sFamily + "family", "");
            } else {
                ba.add("\\text" + sFamily + "{", "}");
            }
        }
    }

    private void applyNfssSeries(StyleWithProperties style, boolean bDecl, boolean bInherit, BeforeAfter ba, Context context) {
        String sSeries;
        if (style != null && !this.bIgnoreAll && (sSeries = CharStyleConverter.nfssSeries(style.getProperty("fo:font-weight", bInherit))) != null) {
            if (!bDecl && "bf".equals(sSeries) && this.config.getTextAttributeStyleMap().contains("bold")) {
                ba.add(this.config.getTextAttributeStyleMap().getBefore("bold"), this.config.getTextAttributeStyleMap().getAfter("bold"));
            } else {
                if (style.isAutomatic()) {
                    if (sSeries.equals(CharStyleConverter.nfssSeries(context.getFontWeight()))) {
                        return;
                    }
                    if (context.getFontWeight() == null && sSeries.equals("md")) {
                        return;
                    }
                }
                if (bDecl) {
                    ba.add("\\" + sSeries + "series", "");
                } else {
                    ba.add("\\text" + sSeries + "{", "}");
                }
            }
        }
    }

    private void applyNfssShape(StyleWithProperties style, boolean bDecl, boolean bInherit, BeforeAfter ba, Context context) {
        String sStyle;
        String sVariant;
        String sShape;
        if (style != null && !this.bIgnoreAll && (sShape = CharStyleConverter.nfssShape(sVariant = style.getProperty("fo:font-variant", bInherit), sStyle = style.getProperty("fo:font-style", bInherit))) != null) {
            if (!bDecl && "sc".equals(sShape) && this.config.getTextAttributeStyleMap().contains("small-caps")) {
                ba.add(this.config.getTextAttributeStyleMap().getBefore("small-caps"), this.config.getTextAttributeStyleMap().getAfter("small-caps"));
            } else if (!bDecl && "it".equals(sShape) && this.config.getTextAttributeStyleMap().contains("italic")) {
                ba.add(this.config.getTextAttributeStyleMap().getBefore("italic"), this.config.getTextAttributeStyleMap().getAfter("italic"));
            } else {
                if (style.isAutomatic()) {
                    if (sShape.equals(CharStyleConverter.nfssShape(context.getFontVariant(), context.getFontStyle()))) {
                        return;
                    }
                    if (context.getFontVariant() == null && context.getFontStyle() == null && sShape.equals("up")) {
                        return;
                    }
                }
                if (bDecl) {
                    ba.add("\\" + sShape + "shape", "");
                } else {
                    ba.add("\\text" + sShape + "{", "}");
                }
            }
        }
    }

    private void applyNfssSize(StyleWithProperties style, boolean bDecl, boolean bInherit, BeforeAfter ba, Context context) {
        if (style == null || this.bIgnoreFontsize || this.bIgnoreHardFontsize && style.isAutomatic()) {
            return;
        }
        if (style.getProperty("fo:font-size", bInherit) == null) {
            return;
        }
        String sSize = CharStyleConverter.nfssSize(style.getAbsoluteProperty("fo:font-size"));
        if (sSize == null) {
            return;
        }
        if (sSize.equals(CharStyleConverter.nfssSize(context.getFontSize()))) {
            return;
        }
        if (bDecl) {
            ba.add(sSize, "");
        } else {
            ba.add("{" + sSize + " ", "}");
        }
    }

    private void applyTextPosition(StyleWithProperties style, boolean bInherit, BeforeAfter ba) {
        if (style != null && !this.bIgnoreAll) {
            String s = this.textPosition(style.getProperty("style:text-position", bInherit));
            if (this.config.getTextAttributeStyleMap().contains("superscript") && "\\textsuperscript".equals(s)) {
                ba.add(this.config.getTextAttributeStyleMap().getBefore("superscript"), this.config.getTextAttributeStyleMap().getAfter("superscript"));
            } else if (this.config.getTextAttributeStyleMap().contains("subscript") && "\\textsubscript".equals(s)) {
                ba.add(this.config.getTextAttributeStyleMap().getBefore("subscript"), this.config.getTextAttributeStyleMap().getAfter("subscript"));
            } else if (s != null) {
                ba.add(s + "{", "}");
            }
        }
    }

    private void applyUnderline(StyleWithProperties style, boolean bInherit, BeforeAfter ba) {
        if (style == null || !this.bUseUlem) {
            return;
        }
        if (this.bIgnoreAll) {
            return;
        }
        String sTag = this.ofr.isOpenDocument() ? "style:text-underline-style" : "style:text-underline";
        String s = CharStyleConverter.underline(style.getProperty(sTag, bInherit));
        if (s != null) {
            this.bNeedUlem = true;
            ba.add(s + "{", "}");
        }
    }

    private void applyCrossout(StyleWithProperties style, boolean bInherit, BeforeAfter ba) {
        if (style == null || !this.bUseUlem) {
            return;
        }
        if (this.bIgnoreAll) {
            return;
        }
        String sTag = this.ofr.isOpenDocument() ? "style:text-line-through-style" : "style:text-crossing-out";
        String s = CharStyleConverter.crossout(style.getProperty(sTag, bInherit));
        if (s != null) {
            this.bNeedUlem = true;
            ba.add(s + "{", "}");
        }
    }

    private void applyChangeCase(StyleWithProperties style, boolean bInherit, BeforeAfter ba) {
        if (style == null) {
            return;
        }
        if (this.bIgnoreAll) {
            return;
        }
        String s = CharStyleConverter.changeCase(style.getProperty("fo:text-transform"));
        if (s != null) {
            ba.add(s + "{", "}");
        }
    }

    private String convertFontDeclaration(String sName) {
        FontDeclaration fd = this.ofr.getFontDeclaration(sName);
        if (fd == null) {
            return null;
        }
        if (!this.fontDecls.containsKey(sName)) {
            String sFontFamily = fd.getFontFamily();
            String sFontPitch = fd.getFontPitch();
            String sFontFamilyGeneric = fd.getFontFamilyGeneric();
            this.fontDecls.put(sName, CharStyleConverter.nfssFamily(sFontFamily, sFontFamilyGeneric, sFontPitch));
        }
        return this.fontDecls.get(sName);
    }

    private static final String nfssFamily(String sFontFamily, String sFontFamilyGeneric, String sFontPitch) {
        if ("fixed".equals(sFontPitch)) {
            return "tt";
        }
        if ("modern".equals(sFontFamilyGeneric)) {
            return "tt";
        }
        if ("swiss".equals(sFontFamilyGeneric)) {
            return "sf";
        }
        return "rm";
    }

    private static final String nfssSeries(String sFontWeight) {
        if (sFontWeight == null) {
            return null;
        }
        if ("bold".equals(sFontWeight)) {
            return "bf";
        }
        return "md";
    }

    private static final String nfssShape(String sFontVariant, String sFontStyle) {
        if (sFontVariant == null && sFontStyle == null) {
            return null;
        }
        if ("small-caps".equals(sFontVariant)) {
            return "sc";
        }
        if ("italic".equals(sFontStyle)) {
            return "it";
        }
        if ("oblique".equals(sFontStyle)) {
            return "sl";
        }
        return "up";
    }

    private static final String nfssSize(String sFontSize) {
        if (sFontSize == null) {
            return null;
        }
        return "\\fontsize{" + sFontSize + "}{" + Misc.multiply("120%", sFontSize) + "}\\selectfont";
    }

    private final String textPosition(String sTextPosition) {
        if (sTextPosition == null) {
            return null;
        }
        if (sTextPosition.startsWith("super")) {
            return "\\textsuperscript";
        }
        if (sTextPosition.startsWith("sub") || sTextPosition.startsWith("-")) {
            this.bNeedSubscript = true;
            return "\\textsubscript";
        }
        if (sTextPosition.startsWith("0%")) {
            return null;
        }
        return "\\textsuperscript";
    }

    private static final String underline(String sUnderline) {
        if (sUnderline == null) {
            return null;
        }
        if (sUnderline.equals("none")) {
            return null;
        }
        if (sUnderline.indexOf("wave") >= 0) {
            return "\\uwave";
        }
        return "\\uline";
    }

    private static final String crossout(String sCrossout) {
        if (sCrossout == null) {
            return null;
        }
        if (sCrossout.equals("X")) {
            return "\\xout";
        }
        if (sCrossout.equals("slash")) {
            return "\\xout";
        }
        return "\\sout";
    }

    private static final String changeCase(String sTextTransform) {
        if ("lowercase".equals(sTextTransform)) {
            return "\\MakeLowercase";
        }
        if ("uppercase".equals(sTextTransform)) {
            return "\\MakeUppercase";
        }
        return null;
    }
}

