// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IntCurvesFace_Intersector_HeaderFile
#define _IntCurvesFace_Intersector_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Handle_BRepTopAdaptor_TopolTool.hxx>
#include <Handle_BRepAdaptor_HSurface.hxx>
#include <Standard_Real.hxx>
#include <IntCurveSurface_SequenceOfPnt.hxx>
#include <TColStd_SequenceOfInteger.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Integer.hxx>
#include <TopoDS_Face.hxx>
#include <Standard_Address.hxx>
#include <Handle_Adaptor3d_HCurve.hxx>
#include <GeomAbs_SurfaceType.hxx>
#include <IntCurveSurface_TransitionOnCurve.hxx>
#include <TopAbs_State.hxx>
class BRepTopAdaptor_TopolTool;
class BRepAdaptor_HSurface;
class TopoDS_Face;
class gp_Lin;
class Adaptor3d_HCurve;
class gp_Pnt;
class IntCurveSurface_HInter;
class gp_Pnt2d;
class Bnd_Box;



class IntCurvesFace_Intersector 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Load a Face.
  //!
  //! The Tolerance <Tol> is used to determine if the
  //! first point of the segment is near the face. In
  //! that case, the parameter of the intersection point
  //! on the line can be a negative value (greater than -Tol).
  Standard_EXPORT IntCurvesFace_Intersector(const TopoDS_Face& F, const Standard_Real aTol);
  
  //! Perform the intersection between the
  //! segment L and the loaded face.
  //!
  //! PInf is the smallest parameter on the line
  //! PSup is the highest  parmaeter on the line
  //!
  //! For an infinite line PInf and PSup can be
  //! +/- RealLast.
  Standard_EXPORT   void Perform (const gp_Lin& L, const Standard_Real PInf, const Standard_Real PSup) ;
  
  //! same method for a HCurve from Adaptor3d.
  //! PInf an PSup can also be - and + INF.
  Standard_EXPORT   void Perform (const Handle(Adaptor3d_HCurve)& HCu, const Standard_Real PInf, const Standard_Real PSup) ;
  
  //! Return the surface type
  Standard_EXPORT   GeomAbs_SurfaceType SurfaceType()  const;
  
  //! True is returned when the intersection have been computed.
      Standard_Boolean IsDone()  const;
  
      Standard_Integer NbPnt()  const;
  
  //! Returns the U parameter of the ith intersection point
  //! on the surface.
      Standard_Real UParameter (const Standard_Integer I)  const;
  
  //! Returns the V parameter of the ith intersection point
  //! on the surface.
      Standard_Real VParameter (const Standard_Integer I)  const;
  
  //! Returns the parameter of the ith intersection point
  //! on the line.
      Standard_Real WParameter (const Standard_Integer I)  const;
  
  //! Returns the geometric point of the ith intersection
  //! between the line and the surface.
     const  gp_Pnt& Pnt (const Standard_Integer I)  const;
  
  //! Returns the ith transition of the line on the surface.
      IntCurveSurface_TransitionOnCurve Transition (const Standard_Integer I)  const;
  
  //! Returns the ith state of the point on the face.
  //! The values can be either TopAbs_IN
  //! ( the point is in the face)
  //! or TopAbs_ON
  //! ( the point is on a boudary of the face).
      TopAbs_State State (const Standard_Integer I)  const;
  
  //! Returns the significant face used to determine
  //! the intersection.
     const  TopoDS_Face& Face()  const;
  
  Standard_EXPORT   TopAbs_State ClassifyUVPoint (const gp_Pnt2d& Puv)  const;
  
  Standard_EXPORT   Bnd_Box Bounding()  const;
  
  Standard_EXPORT   void Destroy() ;
~IntCurvesFace_Intersector()
{
  Destroy();
}




protected:





private:

  
  Standard_EXPORT   void InternalCall (const IntCurveSurface_HInter& HICS, const Standard_Real pinf, const Standard_Real psup) ;


  Handle(BRepTopAdaptor_TopolTool) myTopolTool;
  Handle(BRepAdaptor_HSurface) Hsurface;
  Standard_Real Tol;
  IntCurveSurface_SequenceOfPnt SeqPnt;
  TColStd_SequenceOfInteger mySeqState;
  Standard_Boolean done;
  Standard_Integer nbpnt;
  TopoDS_Face face;
  Standard_Address PtrOnPolyhedron;
  Standard_Address PtrOnBndBounding;


};


#include <IntCurvesFace_Intersector.lxx>





#endif // _IntCurvesFace_Intersector_HeaderFile
