/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

class WikiProtocolSocketFactory
extends SSLSocketFactory {
    private SSLContext m_aSSLContext;

    WikiProtocolSocketFactory() {
    }

    private synchronized SSLContext GetNotSoSecureSSLContext() {
        if (this.m_aSSLContext != null) {
            return this.m_aSSLContext;
        }
        TrustManager[] pTrustUnknownCerts = new TrustManager[]{new X509TrustManager(){
            private X509TrustManager m_aOrgTrustManager;

            private X509TrustManager GetOrgTrustManager() {
                if (this.m_aOrgTrustManager == null) {
                    try {
                        TrustManagerFactory aFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        aFactory.init((KeyStore)null);
                        TrustManager[] pTrustmanagers = aFactory.getTrustManagers();
                        if (pTrustmanagers.length != 0 && pTrustmanagers[0] != null) {
                            this.m_aOrgTrustManager = (X509TrustManager)pTrustmanagers[0];
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("No access to the default trust manager!", e);
                    }
                }
                return this.m_aOrgTrustManager;
            }

            public X509Certificate[] getAcceptedIssuers() {
                return this.GetOrgTrustManager().getAcceptedIssuers();
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                this.GetOrgTrustManager().checkClientTrusted(certs, authType);
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                if (certs == null || certs.length == 0) {
                    this.GetOrgTrustManager().checkServerTrusted(certs, authType);
                } else {
                    for (int nInd = 0; nInd < certs.length; ++nInd) {
                        certs[nInd].checkValidity();
                    }
                }
            }
        }};
        try {
            SSLContext aContext = SSLContext.getInstance("SSL");
            if (aContext != null) {
                aContext.init(null, pTrustUnknownCerts, null);
                this.m_aSSLContext = aContext;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_aSSLContext == null) {
            throw new RuntimeException("failed to create SSLContext");
        }
        return this.m_aSSLContext;
    }

    public Socket createSocket(InetAddress address, int port) throws IOException {
        return this.GetNotSoSecureSSLContext().getSocketFactory().createSocket(address, port);
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.GetNotSoSecureSSLContext().getSocketFactory().createSocket(address, port, localAddress, localPort);
    }

    public Socket createSocket(String sHost, int nPort, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return this.GetNotSoSecureSSLContext().getSocketFactory().createSocket(sHost, nPort, clientHost, clientPort);
    }

    public Socket createSocket(String sHost, int nPort) throws IOException, UnknownHostException {
        return this.GetNotSoSecureSSLContext().getSocketFactory().createSocket(sHost, nPort);
    }

    public Socket createSocket(Socket aSocket, String sHost, int nPort, boolean bAutoClose) throws IOException {
        return this.GetNotSoSecureSSLContext().getSocketFactory().createSocket(aSocket, sHost, nPort, bAutoClose);
    }

    public String[] getDefaultCipherSuites() {
        return this.GetNotSoSecureSSLContext().getSocketFactory().getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.GetNotSoSecureSSLContext().getSocketFactory().getSupportedCipherSuites();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(WikiProtocolSocketFactory.class);
    }

    public int hashCode() {
        return WikiProtocolSocketFactory.class.hashCode();
    }
}

