/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.help;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.help.HelpViewerInterface;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.EnhancedTreeCellRenderer;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.ThreadUtilities;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class HelpTOCPanel
extends JPanel {
    private HelpViewerInterface helpViewer;
    private DefaultTreeModel tocModel;
    private DefaultMutableTreeNode tocRoot;
    private JTree toc;
    private Map<String, DefaultMutableTreeNode> nodes;

    public HelpTOCPanel(HelpViewerInterface helpViewerInterface) {
        super(new BorderLayout());
        this.helpViewer = helpViewerInterface;
        this.nodes = new HashMap<String, DefaultMutableTreeNode>();
        this.toc = new TOCTree();
        if (!OperatingSystem.isMacOSLF()) {
            this.toc.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.toc.setCellRenderer(new TOCCellRenderer());
        this.toc.setEditable(false);
        this.toc.setShowsRootHandles(true);
        this.add("Center", new JScrollPane(this.toc));
        this.load();
    }

    public void selectNode(String string) {
        if (this.tocModel == null) {
            return;
        }
        final DefaultMutableTreeNode defaultMutableTreeNode = this.nodes.get(string);
        if (defaultMutableTreeNode == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreePath treePath = new TreePath(HelpTOCPanel.this.tocModel.getPathToRoot(defaultMutableTreeNode));
                HelpTOCPanel.this.toc.expandPath(treePath);
                HelpTOCPanel.this.toc.setSelectionPath(treePath);
                HelpTOCPanel.this.toc.scrollPathToVisible(treePath);
            }
        });
    }

    public void load() {
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode(jEdit.getProperty("helpviewer.toc.loading")));
        this.toc.setModel(defaultTreeModel);
        this.toc.setRootVisible(true);
        ThreadUtilities.runInBackground(new Runnable(){

            @Override
            public void run() {
                HelpTOCPanel.this.createTOC();
                HelpTOCPanel.this.tocModel.reload(HelpTOCPanel.this.tocRoot);
                HelpTOCPanel.this.toc.setModel(HelpTOCPanel.this.tocModel);
                HelpTOCPanel.this.toc.setRootVisible(false);
                for (int i = 0; i < HelpTOCPanel.this.tocRoot.getChildCount(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)HelpTOCPanel.this.tocRoot.getChildAt(i);
                    HelpTOCPanel.this.toc.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
                }
                if (HelpTOCPanel.this.helpViewer.getShortURL() != null) {
                    HelpTOCPanel.this.selectNode(HelpTOCPanel.this.helpViewer.getShortURL());
                }
            }
        });
    }

    private DefaultMutableTreeNode createNode(String string, String string2) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new HelpNode(string, string2), true);
        this.nodes.put(string, defaultMutableTreeNode);
        return defaultMutableTreeNode;
    }

    private void createTOC() {
        EditPlugin[] editPluginArray = jEdit.getPlugins();
        Arrays.sort(editPluginArray, new PluginCompare());
        this.tocRoot = new DefaultMutableTreeNode();
        this.tocRoot.add(this.createNode("welcome.html", jEdit.getProperty("helpviewer.toc.welcome")));
        this.tocRoot.add(this.createNode("README.txt", jEdit.getProperty("helpviewer.toc.readme")));
        this.tocRoot.add(this.createNode("CHANGES.txt", jEdit.getProperty("helpviewer.toc.changes")));
        this.tocRoot.add(this.createNode("TODO.txt", jEdit.getProperty("helpviewer.toc.todo")));
        this.tocRoot.add(this.createNode("COPYING.txt", jEdit.getProperty("helpviewer.toc.copying")));
        this.tocRoot.add(this.createNode("COPYING.DOC.txt", jEdit.getProperty("helpviewer.toc.copying-doc")));
        this.tocRoot.add(this.createNode("Apache.LICENSE.txt", jEdit.getProperty("helpviewer.toc.copying-apache")));
        this.tocRoot.add(this.createNode("COPYING.PLUGINS.txt", jEdit.getProperty("helpviewer.toc.copying-plugins")));
        this.loadTOC(this.tocRoot, "whatsnew/toc.xml");
        this.loadTOC(this.tocRoot, "users-guide/toc.xml");
        this.loadTOC(this.tocRoot, "FAQ/toc.xml");
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(jEdit.getProperty("helpviewer.toc.plugins"), true);
        for (EditPlugin editPlugin : editPluginArray) {
            String string = editPlugin.getClassName();
            String string2 = jEdit.getProperty("plugin." + string + ".docs");
            String string3 = jEdit.getProperty("plugin." + string + ".name");
            if (string3 == null || string2 == null) continue;
            String string4 = editPlugin.getPluginJAR().getClassLoader().getResourceAsPath(string2);
            defaultMutableTreeNode.add(this.createNode(string4, string3));
        }
        if (defaultMutableTreeNode.getChildCount() != 0) {
            this.tocRoot.add(defaultMutableTreeNode);
        } else {
            defaultMutableTreeNode = null;
        }
        this.loadTOC(this.tocRoot, "api/toc.xml");
        this.tocModel = new DefaultTreeModel(this.tocRoot);
    }

    private void loadTOC(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        TOCHandler tOCHandler = new TOCHandler(defaultMutableTreeNode, MiscUtilities.getParentOfPath(string));
        try {
            XMLUtilities.parseXML(new URL(this.helpViewer.getBaseURL() + '/' + string).openStream(), tOCHandler);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if ("api/toc.xml".equals(string)) {
                Log.log(5, this, "The API docs for jEdit will not be available (reinstall jEdit if you want them)");
                defaultMutableTreeNode.add(this.createNode("http://www.jedit.org/api/overview-summary.html", jEdit.getProperty("helpviewer.toc.online-apidocs")));
            } else {
                Log.log(9, this, fileNotFoundException);
            }
        }
        catch (IOException iOException) {
            Log.log(9, this, iOException);
        }
    }

    static class PluginCompare
    implements Comparator<EditPlugin> {
        PluginCompare() {
        }

        @Override
        public int compare(EditPlugin editPlugin, EditPlugin editPlugin2) {
            return StandardUtilities.compareStrings(jEdit.getProperty("plugin." + editPlugin.getClassName() + ".name"), jEdit.getProperty("plugin." + editPlugin2.getClassName() + ".name"), true);
        }
    }

    static class TOCCellRenderer
    extends EnhancedTreeCellRenderer {
        EmptyBorder border = new EmptyBorder(1, 0, 1, 1);

        TOCCellRenderer() {
        }

        @Override
        protected TreeCellRenderer newInstance() {
            return new TOCCellRenderer();
        }

        @Override
        protected void configureTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.setIcon(bl3 ? FileCellRenderer.fileIcon : (bl2 ? FileCellRenderer.openDirIcon : FileCellRenderer.dirIcon));
            this.setBorder(this.border);
        }
    }

    class TOCTree
    extends JTree {
        TOCTree() {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.selectionModel.setSelectionMode(1);
        }

        @Override
        public final String getToolTipText(MouseEvent mouseEvent) {
            Rectangle rectangle;
            TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null && (rectangle = this.getPathBounds(treePath)) != null && !this.cellRectIsVisible(rectangle)) {
                return treePath.getLastPathComponent().toString();
            }
            return null;
        }

        @Override
        public void processKeyEvent(KeyEvent keyEvent) {
            if (401 == keyEvent.getID() && 10 == keyEvent.getKeyCode()) {
                TreePath treePath = this.getSelectionPath();
                if (treePath != null) {
                    Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                    if (!(object instanceof HelpNode)) {
                        this.expandPath(treePath);
                        return;
                    }
                    HelpNode helpNode = (HelpNode)object;
                    HelpTOCPanel.this.helpViewer.gotoURL(helpNode.href, true, 0);
                }
                keyEvent.consume();
            } else {
                super.processKeyEvent(keyEvent);
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            switch (mouseEvent.getID()) {
                case 500: {
                    TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath != null) {
                        Object object;
                        if (!this.isPathSelected(treePath)) {
                            this.setSelectionPath(treePath);
                        }
                        if (!((object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof HelpNode)) {
                            this.expandPath(treePath);
                            return;
                        }
                        HelpNode helpNode = (HelpNode)object;
                        HelpTOCPanel.this.helpViewer.gotoURL(helpNode.href, true, 0);
                    }
                    super.processMouseEvent(mouseEvent);
                    break;
                }
                default: {
                    super.processMouseEvent(mouseEvent);
                }
            }
        }

        private boolean cellRectIsVisible(Rectangle rectangle) {
            Rectangle rectangle2 = this.getVisibleRect();
            return rectangle2.contains(rectangle.x, rectangle.y) && rectangle2.contains(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        }
    }

    class TOCHandler
    extends DefaultHandler {
        String dir;
        private String tag;
        private StringBuilder title = new StringBuilder();
        private String href;
        private DefaultMutableTreeNode node;
        private Stack<DefaultMutableTreeNode> nodes = new Stack();

        TOCHandler(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
            this.node = defaultMutableTreeNode;
            this.dir = string;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (this.tag.equals("TITLE")) {
                boolean bl = false;
                for (int i = 0; i < n2; ++i) {
                    char c = cArray[n + i];
                    if (!bl && Character.isWhitespace(c)) continue;
                    bl = true;
                    this.title.append(c);
                }
            }
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this.tag = string3;
            if (string3.equals("ENTRY")) {
                this.href = attributes.getValue("HREF");
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (string3 == null) {
                return;
            }
            if (string3.equals("TITLE")) {
                DefaultMutableTreeNode defaultMutableTreeNode = HelpTOCPanel.this.createNode(this.dir + this.href, this.title.toString());
                this.node.add(defaultMutableTreeNode);
                this.nodes.push(this.node);
                this.node = defaultMutableTreeNode;
                this.title.setLength(0);
            } else if (string3.equals("ENTRY")) {
                this.node = this.nodes.pop();
                this.href = null;
            }
        }
    }

    static class HelpNode {
        String href;
        String title;

        HelpNode(String string, String string2) {
            this.href = string;
            this.title = string2;
        }

        public String toString() {
            return this.title;
        }
    }
}

