/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.ManualTagger;
import org.languagetool.tagging.Tagger;
import org.languagetool.tokenizers.ManualTaggerAdapter;

public class ManualTaggerAdapterTest
extends TestCase {
    private static final String TEST_DATA = "# some test data\ninflectedform11\tlemma1\tPOS1\ninflectedform121\tlemma1\tPOS2\ninflectedform122\tlemma1\tPOS2\ninflectedform123\tlemma1\tPOS3\ninflectedform2\tlemma2\tPOS1a\ninflectedform2\tlemma2\tPOS1b\ninflectedform2\tlemma2\tPOS1c\ninflectedform3\tlemma3a\tPOS3a\ninflectedform3\tlemma3b\tPOS3b\ninflectedform3\tlemma3c\tPOS3c\ninflectedform3\tlemma3d\tPOS3d\n";
    protected Tagger tagger;

    protected void setUp() throws Exception {
        super.setUp();
        this.tagger = new ManualTaggerAdapter(new ManualTagger((InputStream)new ByteArrayInputStream(TEST_DATA.getBytes("UTF-8"))));
    }

    public void testMultipleLemma() throws Exception {
        List<String> l = Arrays.asList("inflectedform3");
        List analyzedTokenReadings = this.tagger.tag(l);
        ManualTaggerAdapterTest.assertNotNull((Object)analyzedTokenReadings);
        ManualTaggerAdapterTest.assertEquals((int)1, (int)analyzedTokenReadings.size());
        AnalyzedTokenReadings analyzedTokenReading = (AnalyzedTokenReadings)analyzedTokenReadings.get(0);
        ManualTaggerAdapterTest.assertEquals((String)"inflectedform3", (String)analyzedTokenReading.getToken());
        ManualTaggerAdapterTest.assertNotNull((Object)analyzedTokenReading.getReadings());
        ManualTaggerAdapterTest.assertEquals((int)4, (int)analyzedTokenReading.getReadingsLength());
        AnalyzedToken analyzedToken = (AnalyzedToken)analyzedTokenReading.getReadings().get(0);
        ManualTaggerAdapterTest.assertEquals((String)"inflectedform3", (String)analyzedToken.getToken());
        ManualTaggerAdapterTest.assertEquals((String)"lemma3a", (String)analyzedToken.getLemma());
        ManualTaggerAdapterTest.assertEquals((String)"POS3a", (String)analyzedToken.getPOSTag());
        analyzedToken = (AnalyzedToken)analyzedTokenReading.getReadings().get(1);
        ManualTaggerAdapterTest.assertEquals((String)"inflectedform3", (String)analyzedToken.getToken());
        ManualTaggerAdapterTest.assertEquals((String)"lemma3b", (String)analyzedToken.getLemma());
        ManualTaggerAdapterTest.assertEquals((String)"POS3b", (String)analyzedToken.getPOSTag());
        analyzedToken = (AnalyzedToken)analyzedTokenReading.getReadings().get(2);
        ManualTaggerAdapterTest.assertEquals((String)"inflectedform3", (String)analyzedToken.getToken());
        ManualTaggerAdapterTest.assertEquals((String)"lemma3c", (String)analyzedToken.getLemma());
        ManualTaggerAdapterTest.assertEquals((String)"POS3c", (String)analyzedToken.getPOSTag());
        analyzedToken = (AnalyzedToken)analyzedTokenReading.getReadings().get(3);
        ManualTaggerAdapterTest.assertEquals((String)"inflectedform3", (String)analyzedToken.getToken());
        ManualTaggerAdapterTest.assertEquals((String)"lemma3d", (String)analyzedToken.getLemma());
        ManualTaggerAdapterTest.assertEquals((String)"POS3d", (String)analyzedToken.getPOSTag());
    }

    public void testMultiplePOS() throws Exception {
        List<String> l = Arrays.asList("inflectedform2");
        List analyzedTokenReadings = this.tagger.tag(l);
        ManualTaggerAdapterTest.assertNotNull((Object)analyzedTokenReadings);
        ManualTaggerAdapterTest.assertEquals((int)1, (int)analyzedTokenReadings.size());
        AnalyzedTokenReadings analyzedTokenReading = (AnalyzedTokenReadings)analyzedTokenReadings.get(0);
        ManualTaggerAdapterTest.assertEquals((String)"inflectedform2", (String)analyzedTokenReading.getToken());
        ManualTaggerAdapterTest.assertNotNull((Object)analyzedTokenReading.getReadings());
        ManualTaggerAdapterTest.assertEquals((int)3, (int)analyzedTokenReading.getReadingsLength());
        AnalyzedToken analyzedToken = (AnalyzedToken)analyzedTokenReading.getReadings().get(0);
        ManualTaggerAdapterTest.assertEquals((String)"POS1a", (String)analyzedToken.getPOSTag());
        ManualTaggerAdapterTest.assertEquals((String)"inflectedform2", (String)analyzedToken.getToken());
        ManualTaggerAdapterTest.assertEquals((String)"lemma2", (String)analyzedToken.getLemma());
        analyzedToken = (AnalyzedToken)analyzedTokenReading.getReadings().get(1);
        ManualTaggerAdapterTest.assertEquals((String)"POS1b", (String)analyzedToken.getPOSTag());
        ManualTaggerAdapterTest.assertEquals((String)"inflectedform2", (String)analyzedToken.getToken());
        ManualTaggerAdapterTest.assertEquals((String)"lemma2", (String)analyzedToken.getLemma());
        analyzedToken = (AnalyzedToken)analyzedTokenReading.getReadings().get(2);
        ManualTaggerAdapterTest.assertEquals((String)"POS1c", (String)analyzedToken.getPOSTag());
        ManualTaggerAdapterTest.assertEquals((String)"inflectedform2", (String)analyzedToken.getToken());
        ManualTaggerAdapterTest.assertEquals((String)"lemma2", (String)analyzedToken.getLemma());
    }

    public void testMultipleWords() throws Exception {
        List<String> l = Arrays.asList("inflectedform2", "inflectedform3");
        List analyzedTokenReadings = this.tagger.tag(l);
        ManualTaggerAdapterTest.assertNotNull((Object)analyzedTokenReadings);
        ManualTaggerAdapterTest.assertEquals((int)2, (int)analyzedTokenReadings.size());
        AnalyzedTokenReadings analyzedTokenReading = (AnalyzedTokenReadings)analyzedTokenReadings.get(0);
        ManualTaggerAdapterTest.assertEquals((String)"inflectedform2", (String)analyzedTokenReading.getToken());
        ManualTaggerAdapterTest.assertNotNull((Object)analyzedTokenReading.getReadings());
        ManualTaggerAdapterTest.assertEquals((int)3, (int)analyzedTokenReading.getReadingsLength());
        analyzedTokenReading = (AnalyzedTokenReadings)analyzedTokenReadings.get(1);
        ManualTaggerAdapterTest.assertEquals((String)"inflectedform3", (String)analyzedTokenReading.getToken());
        ManualTaggerAdapterTest.assertNotNull((Object)analyzedTokenReading.getReadings());
        ManualTaggerAdapterTest.assertEquals((int)4, (int)analyzedTokenReading.getReadingsLength());
    }
}

