/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene45;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.Version;
import org.apache.lucene.util.packed.BlockPackedReader;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

@Deprecated
class Lucene45DocValuesProducer
extends DocValuesProducer
implements Closeable {
    private final Map<Integer, NumericEntry> numerics;
    private final Map<Integer, BinaryEntry> binaries;
    private final Map<Integer, SortedSetEntry> sortedSets;
    private final Map<Integer, NumericEntry> ords;
    private final Map<Integer, NumericEntry> ordIndexes;
    private final AtomicLong ramBytesUsed;
    private final IndexInput data;
    private final int maxDoc;
    private final int version;
    private final int numFields;
    @Deprecated
    private final boolean lenientFieldInfoCheck;
    private final Map<Integer, MonotonicBlockPackedReader> addressInstances;
    private final Map<Integer, MonotonicBlockPackedReader> ordIndexInstances;
    private final boolean merging;

    Lucene45DocValuesProducer(Lucene45DocValuesProducer original) throws IOException {
        this.addressInstances = new HashMap<Integer, MonotonicBlockPackedReader>();
        this.ordIndexInstances = new HashMap<Integer, MonotonicBlockPackedReader>();
        assert (Thread.holdsLock(original));
        this.numerics = original.numerics;
        this.binaries = original.binaries;
        this.sortedSets = original.sortedSets;
        this.ords = original.ords;
        this.ordIndexes = original.ordIndexes;
        this.ramBytesUsed = new AtomicLong(original.ramBytesUsed.get());
        this.data = original.data.clone();
        this.maxDoc = original.maxDoc;
        this.version = original.version;
        this.numFields = original.numFields;
        this.lenientFieldInfoCheck = original.lenientFieldInfoCheck;
        this.addressInstances.putAll(original.addressInstances);
        this.ordIndexInstances.putAll(original.ordIndexInstances);
        this.merging = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Lucene45DocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        block10: {
            boolean success;
            block11: {
                ChecksumIndexInput in;
                block9: {
                    this.addressInstances = new HashMap<Integer, MonotonicBlockPackedReader>();
                    this.ordIndexInstances = new HashMap<Integer, MonotonicBlockPackedReader>();
                    Version ver = state.segmentInfo.getVersion();
                    this.lenientFieldInfoCheck = Version.LUCENE_4_9_0.onOrAfter(ver);
                    String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaExtension);
                    in = state.directory.openChecksumInput(metaName, state.context);
                    this.maxDoc = state.segmentInfo.maxDoc();
                    this.merging = false;
                    success = false;
                    try {
                        this.version = CodecUtil.checkHeader((DataInput)in, (String)metaCodec, (int)0, (int)2);
                        this.numerics = new HashMap<Integer, NumericEntry>();
                        this.ords = new HashMap<Integer, NumericEntry>();
                        this.ordIndexes = new HashMap<Integer, NumericEntry>();
                        this.binaries = new HashMap<Integer, BinaryEntry>();
                        this.sortedSets = new HashMap<Integer, SortedSetEntry>();
                        this.numFields = this.readFields((IndexInput)in, state.fieldInfos);
                        if (this.version >= 2) {
                            CodecUtil.checkFooter((ChecksumIndexInput)in);
                        } else {
                            CodecUtil.checkEOF((IndexInput)in);
                        }
                        success = true;
                        if (!success) break block9;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            IOUtils.close((Closeable[])new Closeable[]{in});
                            throw throwable;
                        }
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                        throw throwable;
                    }
                    IOUtils.close((Closeable[])new Closeable[]{in});
                    break block11;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
            }
            String dataName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dataExtension);
            this.data = state.directory.openInput(dataName, state.context);
            success = false;
            try {
                int version2 = CodecUtil.checkHeader((DataInput)this.data, (String)dataCodec, (int)0, (int)2);
                if (this.version != version2) {
                    throw new CorruptIndexException("Format versions mismatch: meta=" + this.version + ", data=" + version2, (DataInput)this.data);
                }
                if (this.version >= 2) {
                    CodecUtil.retrieveChecksum((IndexInput)this.data);
                }
                if (success = true) break block10;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data});
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data});
        }
        this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(this.getClass()));
    }

    private void readSortedField(int fieldNumber, IndexInput meta, FieldInfos infos) throws IOException {
        if (meta.readVInt() != fieldNumber) {
            throw new CorruptIndexException("sorted entry for field: " + fieldNumber + " is corrupt", (DataInput)meta);
        }
        if (meta.readByte() != 1) {
            throw new CorruptIndexException("sorted entry for field: " + fieldNumber + " is corrupt", (DataInput)meta);
        }
        BinaryEntry b = Lucene45DocValuesProducer.readBinaryEntry(meta);
        this.binaries.put(fieldNumber, b);
        if (meta.readVInt() != fieldNumber) {
            throw new CorruptIndexException("sorted entry for field: " + fieldNumber + " is corrupt", (DataInput)meta);
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sorted entry for field: " + fieldNumber + " is corrupt", (DataInput)meta);
        }
        NumericEntry n = Lucene45DocValuesProducer.readNumericEntry(meta);
        this.ords.put(fieldNumber, n);
    }

    private void readSortedSetFieldWithAddresses(int fieldNumber, IndexInput meta, FieldInfos infos) throws IOException {
        if (meta.readVInt() != fieldNumber) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt", (DataInput)meta);
        }
        if (meta.readByte() != 1) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt", (DataInput)meta);
        }
        BinaryEntry b = Lucene45DocValuesProducer.readBinaryEntry(meta);
        this.binaries.put(fieldNumber, b);
        if (meta.readVInt() != fieldNumber) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt", (DataInput)meta);
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt", (DataInput)meta);
        }
        NumericEntry n1 = Lucene45DocValuesProducer.readNumericEntry(meta);
        this.ords.put(fieldNumber, n1);
        if (meta.readVInt() != fieldNumber) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt", (DataInput)meta);
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt", (DataInput)meta);
        }
        NumericEntry n2 = Lucene45DocValuesProducer.readNumericEntry(meta);
        this.ordIndexes.put(fieldNumber, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int numFields = 0;
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            ++numFields;
            if (this.lenientFieldInfoCheck && fieldNumber < 0 || !this.lenientFieldInfoCheck && infos.fieldInfo(fieldNumber) == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, (DataInput)meta);
            }
            byte type = meta.readByte();
            if (type == 0) {
                this.numerics.put(fieldNumber, Lucene45DocValuesProducer.readNumericEntry(meta));
            } else if (type == 1) {
                BinaryEntry b = Lucene45DocValuesProducer.readBinaryEntry(meta);
                this.binaries.put(fieldNumber, b);
            } else if (type == 2) {
                this.readSortedField(fieldNumber, meta, infos);
            } else {
                if (type != 3) throw new CorruptIndexException("invalid type: " + type, (DataInput)meta);
                SortedSetEntry ss = this.readSortedSetEntry(meta);
                this.sortedSets.put(fieldNumber, ss);
                if (ss.format == 0) {
                    this.readSortedSetFieldWithAddresses(fieldNumber, meta, infos);
                } else {
                    if (ss.format != 1) throw new AssertionError();
                    if (meta.readVInt() != fieldNumber) {
                        throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt", (DataInput)meta);
                    }
                    if (meta.readByte() != 2) {
                        throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt", (DataInput)meta);
                    }
                    this.readSortedField(fieldNumber, meta, infos);
                }
            }
            fieldNumber = meta.readVInt();
        }
        return numFields;
    }

    static NumericEntry readNumericEntry(IndexInput meta) throws IOException {
        NumericEntry entry = new NumericEntry();
        entry.format = meta.readVInt();
        entry.missingOffset = meta.readLong();
        entry.packedIntsVersion = meta.readVInt();
        entry.offset = meta.readLong();
        entry.count = meta.readVLong();
        entry.blockSize = meta.readVInt();
        switch (entry.format) {
            case 1: {
                entry.minValue = meta.readLong();
                entry.gcd = meta.readLong();
                break;
            }
            case 2: {
                if (entry.count > Integer.MAX_VALUE) {
                    throw new CorruptIndexException("Cannot use TABLE_COMPRESSED with more than MAX_VALUE values, got=" + entry.count, (DataInput)meta);
                }
                int uniqueValues = meta.readVInt();
                if (uniqueValues > 256) {
                    throw new CorruptIndexException("TABLE_COMPRESSED cannot have more than 256 distinct values, got=" + uniqueValues, (DataInput)meta);
                }
                entry.table = new long[uniqueValues];
                for (int i = 0; i < uniqueValues; ++i) {
                    entry.table[i] = meta.readLong();
                }
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + entry.format, (DataInput)meta);
            }
        }
        return entry;
    }

    static BinaryEntry readBinaryEntry(IndexInput meta) throws IOException {
        BinaryEntry entry = new BinaryEntry();
        entry.format = meta.readVInt();
        entry.missingOffset = meta.readLong();
        entry.minLength = meta.readVInt();
        entry.maxLength = meta.readVInt();
        entry.count = meta.readVLong();
        entry.offset = meta.readLong();
        switch (entry.format) {
            case 0: {
                break;
            }
            case 2: {
                entry.addressInterval = meta.readVInt();
                entry.addressesOffset = meta.readLong();
                entry.packedIntsVersion = meta.readVInt();
                entry.blockSize = meta.readVInt();
                break;
            }
            case 1: {
                entry.addressesOffset = meta.readLong();
                entry.packedIntsVersion = meta.readVInt();
                entry.blockSize = meta.readVInt();
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + entry.format, (DataInput)meta);
            }
        }
        return entry;
    }

    SortedSetEntry readSortedSetEntry(IndexInput meta) throws IOException {
        SortedSetEntry entry = new SortedSetEntry();
        entry.format = this.version >= 1 ? meta.readVInt() : 0;
        if (entry.format != 1 && entry.format != 0) {
            throw new CorruptIndexException("Unknown format: " + entry.format, (DataInput)meta);
        }
        return entry;
    }

    public NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericEntry entry = this.numerics.get(field.number);
        return this.getNumeric(entry);
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    public synchronized Collection<Accountable> getChildResources() {
        ArrayList resources = new ArrayList();
        resources.addAll(Accountables.namedAccountables((String)"addresses field number", this.addressInstances));
        resources.addAll(Accountables.namedAccountables((String)"ord index field number", this.ordIndexInstances));
        return Collections.unmodifiableList(resources);
    }

    public void checkIntegrity() throws IOException {
        if (this.version >= 2) {
            CodecUtil.checksumEntireFile((IndexInput)this.data);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.numFields + ")";
    }

    LongValues getNumeric(NumericEntry entry) throws IOException {
        IndexInput data = this.data.clone();
        data.seek(entry.offset);
        switch (entry.format) {
            case 0: {
                BlockPackedReader reader = new BlockPackedReader(data, entry.packedIntsVersion, entry.blockSize, entry.count, true);
                return reader;
            }
            case 1: {
                final long min = entry.minValue;
                final long mult = entry.gcd;
                final BlockPackedReader quotientReader = new BlockPackedReader(data, entry.packedIntsVersion, entry.blockSize, entry.count, true);
                return new LongValues(){

                    public long get(long id) {
                        return min + mult * quotientReader.get(id);
                    }
                };
            }
            case 2: {
                final long[] table = entry.table;
                int bitsRequired = PackedInts.bitsRequired((long)(table.length - 1));
                final PackedInts.Reader ords = PackedInts.getDirectReaderNoHeader((IndexInput)data, (PackedInts.Format)PackedInts.Format.PACKED, (int)entry.packedIntsVersion, (int)((int)entry.count), (int)bitsRequired);
                return new LongValues(){

                    public long get(long id) {
                        return table[(int)ords.get((int)id)];
                    }
                };
            }
        }
        throw new AssertionError();
    }

    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        BinaryEntry bytes = this.binaries.get(field.number);
        switch (bytes.format) {
            case 0: {
                return this.getFixedBinary(field, bytes);
            }
            case 1: {
                return this.getVariableBinary(field, bytes);
            }
            case 2: {
                return this.getCompressedBinary(field, bytes);
            }
        }
        throw new AssertionError();
    }

    private BinaryDocValues getFixedBinary(FieldInfo field, final BinaryEntry bytes) {
        final IndexInput data = this.data.clone();
        return new LongBinaryDocValues(){
            final BytesRef term;
            {
                this.term = new BytesRef(bytes.maxLength);
                this.term.offset = 0;
                this.term.length = bytes.maxLength;
            }

            @Override
            public BytesRef get(long id) {
                long address = bytes.offset + id * (long)bytes.maxLength;
                try {
                    data.seek(address);
                    data.readBytes(this.term.bytes, 0, this.term.length);
                    return this.term;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    protected synchronized MonotonicBlockPackedReader getAddressInstance(IndexInput data, FieldInfo field, BinaryEntry bytes) throws IOException {
        MonotonicBlockPackedReader addrInstance = this.addressInstances.get(field.number);
        if (addrInstance == null) {
            data.seek(bytes.addressesOffset);
            addrInstance = MonotonicBlockPackedReader.of((IndexInput)data, (int)bytes.packedIntsVersion, (int)bytes.blockSize, (long)bytes.count, (boolean)false);
            if (!this.merging) {
                this.addressInstances.put(field.number, addrInstance);
                this.ramBytesUsed.addAndGet(addrInstance.ramBytesUsed() + 4L);
            }
        }
        MonotonicBlockPackedReader addresses = addrInstance;
        return addresses;
    }

    private BinaryDocValues getVariableBinary(FieldInfo field, final BinaryEntry bytes) throws IOException {
        final IndexInput data = this.data.clone();
        final MonotonicBlockPackedReader addresses = this.getAddressInstance(data, field, bytes);
        return new LongBinaryDocValues(){
            final BytesRef term;
            {
                this.term = new BytesRef(Math.max(0, bytes.maxLength));
            }

            @Override
            public BytesRef get(long id) {
                long startAddress = bytes.offset + (id == 0L ? 0L : addresses.get(id - 1L));
                long endAddress = bytes.offset + addresses.get(id);
                int length = (int)(endAddress - startAddress);
                try {
                    data.seek(startAddress);
                    data.readBytes(this.term.bytes, 0, length);
                    this.term.length = length;
                    return this.term;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    protected synchronized MonotonicBlockPackedReader getIntervalInstance(IndexInput data, FieldInfo field, BinaryEntry bytes) throws IOException {
        long interval = bytes.addressInterval;
        MonotonicBlockPackedReader addrInstance = this.addressInstances.get(field.number);
        if (addrInstance == null) {
            data.seek(bytes.addressesOffset);
            long size = bytes.count % interval == 0L ? bytes.count / interval : 1L + bytes.count / interval;
            addrInstance = MonotonicBlockPackedReader.of((IndexInput)data, (int)bytes.packedIntsVersion, (int)bytes.blockSize, (long)size, (boolean)false);
            if (!this.merging) {
                this.addressInstances.put(field.number, addrInstance);
                this.ramBytesUsed.addAndGet(addrInstance.ramBytesUsed() + 4L);
            }
        }
        MonotonicBlockPackedReader addresses = addrInstance;
        return addresses;
    }

    private BinaryDocValues getCompressedBinary(FieldInfo field, BinaryEntry bytes) throws IOException {
        IndexInput data = this.data.clone();
        MonotonicBlockPackedReader addresses = this.getIntervalInstance(data, field, bytes);
        return new CompressedBinaryDocValues(bytes, addresses, data);
    }

    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        final int valueCount = (int)this.binaries.get((Object)Integer.valueOf((int)field.number)).count;
        final BinaryDocValues binary = this.getBinary(field);
        NumericEntry entry = this.ords.get(field.number);
        IndexInput data = this.data.clone();
        data.seek(entry.offset);
        final BlockPackedReader ordinals = new BlockPackedReader(data, entry.packedIntsVersion, entry.blockSize, entry.count, true);
        return new SortedDocValues(){

            public int getOrd(int docID) {
                return (int)ordinals.get(docID);
            }

            public BytesRef lookupOrd(int ord) {
                return binary.get(ord);
            }

            public int getValueCount() {
                return valueCount;
            }

            public int lookupTerm(BytesRef key) {
                if (binary instanceof CompressedBinaryDocValues) {
                    return (int)((CompressedBinaryDocValues)binary).lookupTerm(key);
                }
                return super.lookupTerm(key);
            }

            public TermsEnum termsEnum() {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).getTermsEnum();
                }
                return super.termsEnum();
            }
        };
    }

    protected synchronized MonotonicBlockPackedReader getOrdIndexInstance(IndexInput data, FieldInfo field, NumericEntry entry) throws IOException {
        MonotonicBlockPackedReader ordIndexInstance = this.ordIndexInstances.get(field.number);
        if (ordIndexInstance == null) {
            data.seek(entry.offset);
            ordIndexInstance = MonotonicBlockPackedReader.of((IndexInput)data, (int)entry.packedIntsVersion, (int)entry.blockSize, (long)entry.count, (boolean)false);
            if (!this.merging) {
                this.ordIndexInstances.put(field.number, ordIndexInstance);
                this.ramBytesUsed.addAndGet(ordIndexInstance.ramBytesUsed() + 4L);
            }
        }
        MonotonicBlockPackedReader ordIndex = ordIndexInstance;
        return ordIndex;
    }

    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        throw new IllegalStateException("Lucene 4.5 does not support SortedNumeric: how did you pull this off?");
    }

    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        SortedSetEntry ss = this.sortedSets.get(field.number);
        if (ss.format == 1) {
            SortedDocValues values = this.getSorted(field);
            return DocValues.singleton((SortedDocValues)values);
        }
        if (ss.format != 0) {
            throw new AssertionError();
        }
        IndexInput data = this.data.clone();
        final long valueCount = this.binaries.get((Object)Integer.valueOf((int)field.number)).count;
        final LongBinaryDocValues binary = (LongBinaryDocValues)this.getBinary(field);
        final LongValues ordinals = this.getNumeric(this.ords.get(field.number));
        final MonotonicBlockPackedReader ordIndex = this.getOrdIndexInstance(data, field, this.ordIndexes.get(field.number));
        return new RandomAccessOrds(){
            long startOffset;
            long offset;
            long endOffset;

            public long nextOrd() {
                if (this.offset == this.endOffset) {
                    return -1L;
                }
                long ord = ordinals.get(this.offset);
                ++this.offset;
                return ord;
            }

            public void setDocument(int docID) {
                this.offset = docID == 0 ? 0L : ordIndex.get(docID - 1);
                this.startOffset = this.offset;
                this.endOffset = ordIndex.get(docID);
            }

            public BytesRef lookupOrd(long ord) {
                return binary.get(ord);
            }

            public long getValueCount() {
                return valueCount;
            }

            public long lookupTerm(BytesRef key) {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).lookupTerm(key);
                }
                return super.lookupTerm(key);
            }

            public TermsEnum termsEnum() {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).getTermsEnum();
                }
                return super.termsEnum();
            }

            public long ordAt(int index) {
                return ordinals.get(this.startOffset + (long)index);
            }

            public int cardinality() {
                return (int)(this.endOffset - this.startOffset);
            }
        };
    }

    private Bits getMissingBits(final long offset) throws IOException {
        if (offset == -1L) {
            return new Bits.MatchAllBits(this.maxDoc);
        }
        final IndexInput in = this.data.clone();
        return new Bits(){

            public boolean get(int index) {
                try {
                    in.seek(offset + (long)(index >> 3));
                    return (in.readByte() & 1 << (index & 7)) != 0;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public int length() {
                return Lucene45DocValuesProducer.this.maxDoc;
            }
        };
    }

    public Bits getDocsWithField(FieldInfo field) throws IOException {
        switch (field.getDocValuesType()) {
            case SORTED_SET: {
                return DocValues.docsWithValue((SortedSetDocValues)this.getSortedSet(field), (int)this.maxDoc);
            }
            case SORTED: {
                return DocValues.docsWithValue((SortedDocValues)this.getSorted(field), (int)this.maxDoc);
            }
            case BINARY: {
                BinaryEntry be = this.binaries.get(field.number);
                return this.getMissingBits(be.missingOffset);
            }
            case NUMERIC: {
                NumericEntry ne = this.numerics.get(field.number);
                return this.getMissingBits(ne.missingOffset);
            }
        }
        throw new AssertionError();
    }

    public synchronized DocValuesProducer getMergeInstance() throws IOException {
        return new Lucene45DocValuesProducer(this);
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    static class CompressedBinaryDocValues
    extends LongBinaryDocValues {
        final BinaryEntry bytes;
        final long interval;
        final long numValues;
        final long numIndexValues;
        final MonotonicBlockPackedReader addresses;
        final IndexInput data;
        final TermsEnum termsEnum;

        public CompressedBinaryDocValues(BinaryEntry bytes, MonotonicBlockPackedReader addresses, IndexInput data) throws IOException {
            this.bytes = bytes;
            this.interval = bytes.addressInterval;
            this.addresses = addresses;
            this.data = data;
            this.numValues = bytes.count;
            this.numIndexValues = addresses.size();
            this.termsEnum = this.getTermsEnum(data);
        }

        @Override
        public BytesRef get(long id) {
            try {
                this.termsEnum.seekExact(id);
                return this.termsEnum.term();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        long lookupTerm(BytesRef key) {
            try {
                TermsEnum.SeekStatus status = this.termsEnum.seekCeil(key);
                if (status == TermsEnum.SeekStatus.END) {
                    return -this.numValues - 1L;
                }
                if (status == TermsEnum.SeekStatus.FOUND) {
                    return this.termsEnum.ord();
                }
                return -this.termsEnum.ord() - 1L;
            }
            catch (IOException bogus) {
                throw new RuntimeException(bogus);
            }
        }

        TermsEnum getTermsEnum() {
            try {
                return this.getTermsEnum(this.data.clone());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private TermsEnum getTermsEnum(final IndexInput input) throws IOException {
            input.seek(this.bytes.offset);
            return new TermsEnum(){
                private long currentOrd = -1L;
                private final BytesRef term;
                {
                    this.term = new BytesRef(CompressedBinaryDocValues.this.bytes.maxLength < 0 ? 0 : CompressedBinaryDocValues.this.bytes.maxLength);
                }

                public BytesRef next() throws IOException {
                    if (++this.currentOrd >= CompressedBinaryDocValues.this.numValues) {
                        return null;
                    }
                    int start = input.readVInt();
                    int suffix = input.readVInt();
                    input.readBytes(this.term.bytes, start, suffix);
                    this.term.length = start + suffix;
                    return this.term;
                }

                public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
                    int cmp;
                    long low = 0L;
                    long high = CompressedBinaryDocValues.this.numIndexValues - 1L;
                    while (low <= high) {
                        long mid = low + high >>> 1;
                        this.seekExact(mid * CompressedBinaryDocValues.this.interval);
                        cmp = this.term.compareTo(text);
                        if (cmp < 0) {
                            low = mid + 1L;
                            continue;
                        }
                        if (cmp > 0) {
                            high = mid - 1L;
                            continue;
                        }
                        return TermsEnum.SeekStatus.FOUND;
                    }
                    if (CompressedBinaryDocValues.this.numIndexValues == 0L) {
                        return TermsEnum.SeekStatus.END;
                    }
                    long block = low - 1L;
                    this.seekExact(block < 0L ? -1L : block * CompressedBinaryDocValues.this.interval);
                    while (this.next() != null) {
                        cmp = this.term.compareTo(text);
                        if (cmp == 0) {
                            return TermsEnum.SeekStatus.FOUND;
                        }
                        if (cmp <= 0) continue;
                        return TermsEnum.SeekStatus.NOT_FOUND;
                    }
                    return TermsEnum.SeekStatus.END;
                }

                public void seekExact(long ord) throws IOException {
                    long block = ord / CompressedBinaryDocValues.this.interval;
                    if (ord < this.currentOrd || block != this.currentOrd / CompressedBinaryDocValues.this.interval) {
                        this.currentOrd = ord - ord % CompressedBinaryDocValues.this.interval - 1L;
                        input.seek(CompressedBinaryDocValues.this.bytes.offset + CompressedBinaryDocValues.this.addresses.get(block));
                    }
                    while (this.currentOrd < ord) {
                        this.next();
                    }
                }

                public BytesRef term() throws IOException {
                    return this.term;
                }

                public long ord() throws IOException {
                    return this.currentOrd;
                }

                public int docFreq() throws IOException {
                    throw new UnsupportedOperationException();
                }

                public long totalTermFreq() throws IOException {
                    return -1L;
                }

                public PostingsEnum postings(Bits liveDocs, PostingsEnum reuse, int flags) throws IOException {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    static abstract class LongBinaryDocValues
    extends BinaryDocValues {
        LongBinaryDocValues() {
        }

        public final BytesRef get(int docID) {
            return this.get((long)docID);
        }

        abstract BytesRef get(long var1);
    }

    protected static class SortedSetEntry {
        int format;

        private SortedSetEntry() {
        }
    }

    protected static class BinaryEntry {
        long missingOffset;
        long offset;
        int format;
        public long count;
        int minLength;
        int maxLength;
        public long addressesOffset;
        public long addressInterval;
        public int packedIntsVersion;
        public int blockSize;

        private BinaryEntry() {
        }
    }

    protected static class NumericEntry {
        long missingOffset;
        public long offset;
        int format;
        public int packedIntsVersion;
        public long count;
        public int blockSize;
        long minValue;
        long gcd;
        long[] table;

        private NumericEntry() {
        }
    }
}

