/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class RequestLimiter {
    private static final int API_REQUEST_QUEUE_SIZE = 1000;
    private final List<RequestEvent> requestEvents = new CopyOnWriteArrayList<RequestEvent>();
    private final int requestLimit;
    private final int requestLimitPeriodInSeconds;

    RequestLimiter(int requestLimit, int requestLimitPeriodInSeconds) {
        this.requestLimit = requestLimit;
        this.requestLimitPeriodInSeconds = requestLimitPeriodInSeconds;
    }

    int getRequestLimit() {
        return this.requestLimit;
    }

    int getRequestLimitPeriodInSeconds() {
        return this.requestLimitPeriodInSeconds;
    }

    boolean isAccessOkay(String ipAddress) {
        while (this.requestEvents.size() > 1000) {
            this.requestEvents.remove(0);
        }
        this.requestEvents.add(new RequestEvent(ipAddress, new Date()));
        return !this.limitReached(ipAddress);
    }

    private boolean limitReached(String ipAddress) {
        int requestsByIp = 0;
        Date thresholdDate = new Date(System.currentTimeMillis() - (long)(this.requestLimitPeriodInSeconds * 1000));
        for (RequestEvent requestEvent : this.requestEvents) {
            if (!requestEvent.ip.equals(ipAddress) || !requestEvent.date.after(thresholdDate) || ++requestsByIp <= this.requestLimit) continue;
            return true;
        }
        return false;
    }

    class RequestEvent {
        private final String ip;
        private final Date date;

        RequestEvent(String ip, Date date) {
            this.ip = ip;
            this.date = date;
        }
    }
}

