/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.actions.FileSystemRefreshAction;
import org.openide.awt.JInlineMenu;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class FileSystemAction
extends SystemAction
implements ContextAwareAction,
Presenter.Menu,
Presenter.Popup {
    static JMenuItem[] NONE = new JMenuItem[0];

    private static Node[] nodes(Lookup lookup) {
        Collection<Object> collection = lookup != null ? lookup.lookupAll(Node.class) : Collections.emptyList();
        return collection.toArray(new Node[collection.size()]);
    }

    /*
     * WARNING - void declaration
     */
    static JMenuItem[] createMenu(boolean bl, Lookup lookup) {
        DataObject dataObject;
        Node[] nodeArray = FileSystemAction.nodes(lookup);
        if (nodeArray == null) {
            nodeArray = WindowManager.getDefault().getRegistry().getActivatedNodes();
        }
        HashMap hashMap = new HashMap();
        LinkedList<DataObject> linkedList = new LinkedList<DataObject>();
        if (nodeArray == null || nodeArray.length == 0) {
            linkedList.addAll(lookup.lookupAll(DataObject.class));
        } else {
            for (Node entry : nodeArray) {
                dataObject = (DataObject)entry.getCookie(DataObject.class);
                if (dataObject == null) continue;
                linkedList.add(dataObject);
            }
        }
        if (!linkedList.isEmpty()) {
            for (DataObject dataObject2 : linkedList) {
                while (dataObject2 instanceof DataShadow) {
                    dataObject2 = ((DataShadow)dataObject2).getOriginal();
                }
                if (dataObject2 == null) continue;
                try {
                    void var8_17;
                    FileSystem fileSystem = dataObject2.getPrimaryFile().getFileSystem();
                    Set set = (Set)hashMap.get(fileSystem);
                    if (set == null) {
                        LinkedHashSet linkedHashSet = new LinkedHashSet();
                        hashMap.put(fileSystem, linkedHashSet);
                    }
                    var8_17.addAll(dataObject2.files());
                }
                catch (FileStateInvalidException fileStateInvalidException) {}
            }
            if (hashMap.size() == 0 || hashMap.size() > 1) {
                return FileSystemAction.createMenu(Enumerations.empty(), bl, lookup);
            }
            LinkedList linkedList2 = new LinkedList();
            LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
            for (Map.Entry entry : hashMap.entrySet()) {
                dataObject = (FileSystem)entry.getKey();
                Set set = (Set)entry.getValue();
                LinkedList linkedList3 = new LinkedList(set);
                Iterator iterator = linkedList3.iterator();
                while (iterator.hasNext()) {
                    FileObject fileObject = (FileObject)iterator.next();
                    try {
                        if (fileObject.getFileSystem() == dataObject) continue;
                        iterator.remove();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        iterator.remove();
                    }
                }
                linkedHashSet.addAll(linkedList3);
                linkedList2.addAll(Arrays.asList(dataObject.getActions(linkedHashSet)));
            }
            if (FileSystemAction.isManualRefresh()) {
                linkedList2.add(FileSystemRefreshAction.get(FileSystemRefreshAction.class));
            }
            return FileSystemAction.createMenu(Collections.enumeration(linkedList2), bl, (Lookup)FileSystemAction.createProxyLookup(lookup, linkedHashSet));
        }
        return NONE;
    }

    private static boolean isManualRefresh() {
        return NbPreferences.root().node("org/openide/actions/FileSystemRefreshAction").getBoolean("manual", false);
    }

    private static ProxyLookup createProxyLookup(Lookup lookup, Set<FileObject> set) {
        return new ProxyLookup(new Lookup[]{lookup, Lookups.fixed((Object[])set.toArray(new FileObject[set.size()]))});
    }

    static JMenuItem[] createMenu(Enumeration<? extends Action> enumeration, boolean bl, Lookup lookup) {
        Object object;
        enumeration = Enumerations.removeDuplicates(enumeration);
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        while (enumeration.hasMoreElements()) {
            object = (JMenuItem[])enumeration.nextElement();
            if (lookup != null && object instanceof ContextAwareAction) {
                object = ((ContextAwareAction)object).createContextAwareInstance(lookup);
            }
            boolean bl2 = false;
            try {
                bl2 = object.isEnabled();
            }
            catch (RuntimeException runtimeException) {
                Exceptions.attachMessage((Throwable)runtimeException, (String)("Guilty action: " + object.getClass().getName()));
                Exceptions.printStackTrace((Throwable)runtimeException);
            }
            if (!bl2) continue;
            JMenuItem jMenuItem = null;
            if (bl) {
                if (object instanceof Presenter.Popup) {
                    jMenuItem = ((Presenter.Popup)object).getPopupPresenter();
                }
            } else if (object instanceof Presenter.Menu) {
                jMenuItem = ((Presenter.Menu)object).getMenuPresenter();
            }
            if (jMenuItem == null) continue;
            arrayList.add(jMenuItem);
        }
        object = new JMenuItem[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public JMenuItem getMenuPresenter() {
        return new Menu(false, null);
    }

    public JMenuItem getPopupPresenter() {
        return new Menu(true, null);
    }

    public String getName() {
        return NbBundle.getMessage(DataObject.class, (String)"ACT_FileSystemAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(FileSystemAction.class);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        assert (false) : "ActionEvt: " + actionEvent;
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new DelegateAction(lookup);
    }

    private static final class DelegateAction
    extends AbstractAction
    implements Presenter.Menu,
    Presenter.Popup {
        private Lookup lookup;

        public DelegateAction(Lookup lookup) {
            this.lookup = lookup;
        }

        public JMenuItem getMenuPresenter() {
            return new Menu(false, this.lookup);
        }

        public JMenuItem getPopupPresenter() {
            return new Menu(true, this.lookup);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            assert (false) : actionEvent;
        }
    }

    private static class Menu
    extends JInlineMenu
    implements PropertyChangeListener {
        private boolean popup;
        private JMenuItem[] last = NONE;
        private Lookup lookup;
        static final long serialVersionUID = 2650151487189209766L;
        boolean needsChange = false;

        Menu(boolean bl, Lookup lookup) {
            this.popup = bl;
            this.lookup = lookup;
            this.changeMenuItems(FileSystemAction.createMenu(bl, lookup));
            if (lookup == null) {
                TopComponent.Registry registry = WindowManager.getDefault().getRegistry();
                registry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)registry));
            }
        }

        synchronized void changeMenuItems(JMenuItem[] jMenuItemArray) {
            this.removeListeners(this.last);
            this.addListeners(jMenuItemArray);
            this.last = jMenuItemArray;
            this.setMenuItems(jMenuItemArray);
        }

        private void addListeners(JMenuItem[] jMenuItemArray) {
            int n = jMenuItemArray.length;
            for (int i = 0; i < n; ++i) {
                jMenuItemArray[i].addPropertyChangeListener(this);
            }
        }

        private void removeListeners(JMenuItem[] jMenuItemArray) {
            int n = jMenuItemArray.length;
            for (int i = 0; i < n; ++i) {
                jMenuItemArray[i].removePropertyChangeListener(this);
            }
        }

        public void addNotify() {
            if (this.needsChange) {
                this.changeMenuItems(FileSystemAction.createMenu(this.popup, this.lookup));
                this.needsChange = false;
            }
            super.addNotify();
        }

        public void removeNotify() {
            this.removeListeners(this.last);
            this.last = NONE;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || string.equals("enabled") || string.equals("activatedNodes")) {
                this.needsChange = true;
            }
        }
    }
}

