/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.recipe;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.xbean.recipe.CircularDependencyException;
import org.apache.xbean.recipe.Recipe;
import org.apache.xbean.recipe.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExecutionContext {
    private static final ThreadLocal<ExecutionContext> context = new ThreadLocal();

    public static boolean isContextSet() {
        return context.get() != null;
    }

    public static ExecutionContext getContext() {
        ExecutionContext executionContext = context.get();
        if (executionContext == null) {
            throw new IllegalStateException("Execution context has not been set");
        }
        return executionContext;
    }

    public static ExecutionContext setContext(ExecutionContext newContext) {
        ExecutionContext oldContext = context.get();
        context.set(newContext);
        return oldContext;
    }

    public abstract void push(Recipe var1) throws CircularDependencyException;

    public abstract Recipe pop();

    public abstract LinkedList<Recipe> getStack();

    public abstract boolean containsObject(String var1);

    public abstract Object getObject(String var1);

    public abstract void addObject(String var1, Object var2);

    public abstract void addReference(Reference var1);

    public abstract Map<String, List<Reference>> getUnresolvedRefs();

    public abstract ClassLoader getClassLoader();
}

