/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.MenuElement;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ActionParameter;
import org.openstreetmap.josm.actions.AdaptableAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.ParameterizedAction;
import org.openstreetmap.josm.actions.ParameterizedActionDecorator;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class ToolbarPreferences
implements PreferenceSettingFactory {
    private static final String EMPTY_TOOLBAR_MARKER = "<!-empty-!>";
    private final ToolbarPopupMenu popupMenu = new ToolbarPopupMenu();
    private final Map<String, Action> actions = new ConcurrentHashMap<String, Action>();
    private final Map<String, Action> regactions = new ConcurrentHashMap<String, Action>();
    private final DefaultMutableTreeNode rootActionsNode = new DefaultMutableTreeNode(I18n.tr("Actions", new Object[0]));
    public final JToolBar control = new JToolBar();
    private final Map<Object, ActionDefinition> buttonActions = new ConcurrentHashMap<Object, ActionDefinition>(30);
    private static final String[] deftoolbar = new String[]{"open", "save", "download", "upload", "|", "undo", "redo", "|", "dialogs/search", "preference", "|", "splitway", "combineway", "wayflip", "|", "imagery-offset", "|", "tagginggroup_Highways/Streets", "tagginggroup_Highways/Ways", "tagginggroup_Highways/Waypoints", "tagginggroup_Highways/Barriers", "|", "tagginggroup_Transport/Car", "tagginggroup_Transport/Public Transport", "|", "tagginggroup_Facilities/Tourism", "tagginggroup_Facilities/Food+Drinks", "|", "tagginggroup_Man Made/Historic Places", "|", "tagginggroup_Man Made/Man Made"};
    private static final DataFlavor ACTION_FLAVOR = new DataFlavor(ActionDefinition.class, "ActionItem");

    @Override
    public PreferenceSetting createPreferenceSetting() {
        return new Settings(this.rootActionsNode);
    }

    public ToolbarPreferences() {
        this.control.setFloatable(false);
        this.control.setComponentPopupMenu(this.popupMenu);
        Main.pref.addPreferenceChangeListener(new Preferences.PreferenceChangedListener(){

            @Override
            public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
                if ("toolbar.visible".equals(preferenceChangeEvent.getKey())) {
                    ToolbarPreferences.this.refreshToolbarControl();
                }
            }
        });
    }

    private void loadAction(DefaultMutableTreeNode defaultMutableTreeNode, MenuElement menuElement) {
        Object object = null;
        MenuElement menuElement2 = menuElement;
        if (menuElement.getSubElements().length > 0 && menuElement.getSubElements()[0] instanceof JPopupMenu) {
            menuElement2 = menuElement.getSubElements()[0];
        }
        for (MenuElement menuElement3 : menuElement2.getSubElements()) {
            Serializable serializable;
            if (menuElement3 instanceof JMenuItem) {
                serializable = (JMenuItem)menuElement3;
                if (((AbstractButton)serializable).getAction() != null) {
                    Action action = ((AbstractButton)serializable).getAction();
                    object = action;
                    Object object2 = action.getValue("toolbar");
                    if (object2 == null) {
                        Main.info(I18n.tr("Toolbar action without name: {0}", action.getClass().getName()));
                        continue;
                    }
                    if (!(object2 instanceof String)) {
                        if (object2 instanceof Boolean && !((Boolean)object2).booleanValue()) continue;
                        Main.info(I18n.tr("Strange toolbar value: {0}", action.getClass().getName()));
                        continue;
                    }
                    String string = (String)object2;
                    Action action2 = this.actions.get(string);
                    if (action2 != null && action2 != action && !string.startsWith("imagery_")) {
                        Main.info(I18n.tr("Toolbar action {0} overwritten: {1} gets {2}", string, action2.getClass().getName(), action.getClass().getName()));
                    }
                    this.actions.put(string, action);
                } else {
                    object = ((AbstractButton)serializable).getText();
                }
            }
            serializable = new DefaultMutableTreeNode(object);
            defaultMutableTreeNode.add((MutableTreeNode)((Object)serializable));
            this.loadAction((DefaultMutableTreeNode)serializable, menuElement3);
        }
    }

    private void loadActions() {
        this.rootActionsNode.removeAllChildren();
        this.loadAction(this.rootActionsNode, Main.main.menu);
        for (Map.Entry<String, Action> entry : this.regactions.entrySet()) {
            if (this.actions.get(entry.getKey()) != null) continue;
            this.rootActionsNode.add(new DefaultMutableTreeNode(entry.getValue()));
        }
        this.rootActionsNode.add(new DefaultMutableTreeNode(null));
    }

    public static Collection<String> getToolString() {
        Collection<String> collection = Main.pref.getCollection("toolbar", Arrays.asList(deftoolbar));
        if (collection == null || collection.isEmpty()) {
            collection = Arrays.asList(deftoolbar);
        }
        return collection;
    }

    private Collection<ActionDefinition> getDefinedActions() {
        this.loadActions();
        ConcurrentHashMap<String, Action> concurrentHashMap = new ConcurrentHashMap<String, Action>(this.regactions);
        concurrentHashMap.putAll(this.actions);
        ActionParser actionParser = new ActionParser(concurrentHashMap);
        ArrayList<ActionDefinition> arrayList = new ArrayList<ActionDefinition>();
        for (String string : ToolbarPreferences.getToolString()) {
            if ("|".equals(string)) {
                arrayList.add(ActionDefinition.getSeparator());
                continue;
            }
            ActionDefinition actionDefinition = actionParser.loadAction(string);
            if (actionDefinition != null) {
                arrayList.add(actionDefinition);
                continue;
            }
            Main.info("Could not load tool definition " + string);
        }
        return arrayList;
    }

    public Action register(Action action) {
        String string = (String)action.getValue("toolbar");
        if (string == null) {
            Main.info(I18n.tr("Registered toolbar action without name: {0}", action.getClass().getName()));
        } else {
            Action action2 = this.regactions.get(string);
            if (action2 != null) {
                Main.info(I18n.tr("Registered toolbar action {0} overwritten: {1} gets {2}", string, action2.getClass().getName(), action.getClass().getName()));
            }
        }
        if (string != null) {
            this.regactions.put(string, action);
        }
        return action;
    }

    public void refreshToolbarControl() {
        this.control.removeAll();
        this.buttonActions.clear();
        boolean bl = Shortcut.findShortcut(9, 0) != null;
        for (ActionDefinition actionDefinition : this.getDefinedActions()) {
            if (actionDefinition.isSeparator()) {
                this.control.addSeparator();
                continue;
            }
            final JButton jButton = this.addButtonAndShortcut(actionDefinition);
            this.buttonActions.put(jButton, actionDefinition);
            Icon icon = actionDefinition.getDisplayIcon();
            if (icon != null) {
                jButton.setIcon(icon);
                Dimension dimension = jButton.getPreferredSize();
                if (dimension.width < dimension.height) {
                    dimension.width = dimension.height;
                    jButton.setMinimumSize(dimension);
                    jButton.setMaximumSize(dimension);
                } else if (dimension.height < dimension.width) {
                    dimension.height = dimension.width;
                    jButton.setMinimumSize(dimension);
                    jButton.setMaximumSize(dimension);
                }
            } else {
                actionDefinition.getParametrizedAction().addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("SmallIcon".equals(propertyChangeEvent.getPropertyName())) {
                            jButton.setHideActionText(propertyChangeEvent.getNewValue() != null);
                        }
                    }
                });
            }
            jButton.setInheritsPopupMenu(true);
            jButton.setFocusTraversalKeysEnabled(!bl);
        }
        boolean bl2 = Main.pref.getBoolean("toolbar.visible", true);
        this.control.setFocusTraversalKeysEnabled(!bl);
        this.control.setVisible(bl2 && this.control.getComponentCount() != 0);
        this.control.repaint();
    }

    public void addCustomButton(String string, int n, boolean bl) {
        LinkedList<String> linkedList = new LinkedList<String>(ToolbarPreferences.getToolString());
        if (linkedList.contains(string)) {
            if (!bl) {
                return;
            }
            linkedList.remove(string);
        } else if (n >= 0 && n < linkedList.size()) {
            linkedList.add(n, string);
        } else {
            linkedList.add(string);
        }
        Main.pref.putCollection("toolbar", linkedList);
        Main.toolbar.refreshToolbarControl();
    }

    private JButton addButtonAndShortcut(ActionDefinition actionDefinition) {
        String string;
        Action action = actionDefinition.getParametrizedAction();
        JButton jButton = this.control.add(action);
        Shortcut shortcut = null;
        if (actionDefinition.getAction() instanceof JosmAction && (shortcut = ((JosmAction)actionDefinition.getAction()).getShortcut()).getAssignedKey() == 65535) {
            shortcut = null;
        }
        long l = 0L;
        if (actionDefinition.hasParameters()) {
            l = actionDefinition.parameters.hashCode();
        }
        if ((string = actionDefinition.getDisplayTooltip()) == null) {
            string = "";
        }
        if (shortcut == null || l != 0L) {
            String string2 = (String)actionDefinition.getAction().getValue("toolbar");
            if (string2 == null) {
                string2 = actionDefinition.getDisplayName();
            }
            if (l != 0L) {
                string2 = string2 + l;
            }
            String string3 = actionDefinition.getDisplayName() + (l == 0L ? "" : actionDefinition.parameters.toString());
            shortcut = Shortcut.registerShortcut("toolbar:" + string2, I18n.tr("Toolbar: {0}", string3), 65535, 5000);
            Main.unregisterShortcut(shortcut);
            Main.registerActionShortcut(action, shortcut);
            if (shortcut.isAssignedUser()) {
                if (string.startsWith("<html>") && string.endsWith("</html>")) {
                    string = string.substring(6, string.length() - 6);
                }
                string = Main.platform.makeTooltip(string, shortcut);
            }
        }
        if (!string.isEmpty()) {
            jButton.setToolTipText(string);
        }
        return jButton;
    }

    public class Settings
    extends DefaultTabPreferenceSetting {
        private final Move moveAction;
        private final DefaultListModel<ActionDefinition> selected;
        private final JList<ActionDefinition> selectedList;
        private final DefaultTreeModel actionsTreeModel;
        private final JTree actionsTree;
        private final ActionParametersTableModel actionParametersModel;
        private final JTable actionParametersTable;
        private JPanel actionParametersPanel;
        private JButton upButton;
        private JButton downButton;
        private JButton removeButton;
        private JButton addButton;
        private String movingComponent;

        public Settings(DefaultMutableTreeNode defaultMutableTreeNode) {
            super("toolbar", I18n.tr("Toolbar customization", new Object[0]), I18n.tr("Customize the elements on the toolbar.", new Object[0]));
            this.moveAction = new Move();
            this.selected = new DefaultListModel();
            this.selectedList = new JList<ActionDefinition>(this.selected);
            this.actionParametersModel = new ActionParametersTableModel();
            this.actionParametersTable = new JTable(this.actionParametersModel);
            this.actionsTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
            this.actionsTree = new JTree(this.actionsTreeModel);
        }

        private JButton createButton(String string) {
            JButton jButton = new JButton();
            if ("up".equals(string)) {
                jButton.setIcon(ImageProvider.get("dialogs", "up"));
            } else if ("down".equals(string)) {
                jButton.setIcon(ImageProvider.get("dialogs", "down"));
            } else {
                jButton.setText(string);
            }
            jButton.addActionListener(this.moveAction);
            jButton.setActionCommand(string);
            return jButton;
        }

        private void updateEnabledState() {
            int n = this.selectedList.getSelectedIndex();
            this.upButton.setEnabled(n > 0);
            this.downButton.setEnabled(n != -1 && n < this.selectedList.getModel().getSize() - 1);
            this.removeButton.setEnabled(n != -1);
            this.addButton.setEnabled(this.actionsTree.getSelectionCount() > 0);
        }

        @Override
        public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
            this.actionsTree.setCellRenderer(new DefaultTreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                    JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                    if (defaultMutableTreeNode.getUserObject() == null) {
                        jLabel.setText(I18n.tr("Separator", new Object[0]));
                        jLabel.setIcon(ImageProvider.get("preferences/separator"));
                    } else if (defaultMutableTreeNode.getUserObject() instanceof Action) {
                        Action action = (Action)defaultMutableTreeNode.getUserObject();
                        jLabel.setText((String)action.getValue("Name"));
                        jLabel.setIcon((Icon)action.getValue("SmallIcon"));
                    }
                    return jLabel;
                }
            });
            ListCellRenderer<ActionDefinition> listCellRenderer = new ListCellRenderer<ActionDefinition>(){
                private final DefaultListCellRenderer def = new DefaultListCellRenderer();

                @Override
                public Component getListCellRendererComponent(JList<? extends ActionDefinition> jList, ActionDefinition actionDefinition, int n, boolean bl, boolean bl2) {
                    Icon icon;
                    String string;
                    if (!actionDefinition.isSeparator()) {
                        string = actionDefinition.getDisplayName();
                        icon = actionDefinition.getDisplayIcon();
                    } else {
                        icon = ImageProvider.get("preferences/separator");
                        string = I18n.tr("Separator", new Object[0]);
                    }
                    JLabel jLabel = (JLabel)this.def.getListCellRendererComponent(jList, string, n, bl, bl2);
                    jLabel.setIcon(icon);
                    return jLabel;
                }
            };
            this.selectedList.setCellRenderer(listCellRenderer);
            this.selectedList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    boolean bl;
                    boolean bl2 = bl = Settings.this.selectedList.getSelectedIndex() != -1;
                    if (bl) {
                        Settings.this.actionsTree.clearSelection();
                        ActionDefinition actionDefinition = (ActionDefinition)Settings.this.selected.get(Settings.this.selectedList.getSelectedIndex());
                        Settings.this.actionParametersModel.setCurrentAction(actionDefinition);
                        Settings.this.actionParametersPanel.setVisible(Settings.this.actionParametersModel.getRowCount() > 0);
                    }
                    Settings.this.updateEnabledState();
                }
            });
            this.selectedList.setDragEnabled(true);
            this.selectedList.setTransferHandler(new SelectedListTransferHandler());
            this.actionsTree.setTransferHandler(new TransferHandler(){
                private static final long serialVersionUID = 1L;

                @Override
                public int getSourceActions(JComponent jComponent) {
                    return 2;
                }

                @Override
                protected Transferable createTransferable(JComponent jComponent) {
                    TreePath[] treePathArray = Settings.this.actionsTree.getSelectionPaths();
                    ArrayList<ActionDefinition> arrayList = new ArrayList<ActionDefinition>();
                    for (TreePath treePath : treePathArray) {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                        Object object = defaultMutableTreeNode.getUserObject();
                        if (object == null) {
                            arrayList.add(ActionDefinition.getSeparator());
                            continue;
                        }
                        if (!(object instanceof Action)) continue;
                        arrayList.add(new ActionDefinition((Action)object));
                    }
                    return new ActionTransferable(arrayList);
                }
            });
            this.actionsTree.setDragEnabled(true);
            this.actionsTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    Settings.this.updateEnabledState();
                }
            });
            final JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)new JLabel(I18n.tr("Toolbar", new Object[0])), GBC.eol());
            jPanel.add((Component)new JScrollPane(this.selectedList), GBC.std().fill(1));
            final JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.add((Component)new JLabel(I18n.tr("Available", new Object[0])), GBC.eol());
            jPanel2.add((Component)new JScrollPane(this.actionsTree), GBC.eol().fill(1));
            final JPanel jPanel3 = new JPanel(new GridLayout(6, 1));
            this.upButton = this.createButton("up");
            jPanel3.add(this.upButton);
            this.addButton = this.createButton("<");
            jPanel3.add(this.addButton);
            this.removeButton = this.createButton(">");
            jPanel3.add(this.removeButton);
            this.downButton = this.createButton("down");
            jPanel3.add(this.downButton);
            this.updateEnabledState();
            final JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new LayoutManager(){

                @Override
                public void addLayoutComponent(String string, Component component) {
                }

                @Override
                public void removeLayoutComponent(Component component) {
                }

                @Override
                public Dimension minimumLayoutSize(Container container) {
                    Dimension dimension = jPanel.getMinimumSize();
                    Dimension dimension2 = jPanel2.getMinimumSize();
                    Dimension dimension3 = jPanel3.getMinimumSize();
                    return new Dimension(dimension.width + dimension3.width + 10 + dimension2.width, dimension.height + dimension3.height + 10 + dimension2.height);
                }

                @Override
                public Dimension preferredLayoutSize(Container container) {
                    Dimension dimension = new Dimension(200, 200);
                    Dimension dimension2 = new Dimension(200, 200);
                    return new Dimension(dimension.width + dimension2.width + 10 + jPanel3.getPreferredSize().width, Math.max(dimension.height, dimension2.height));
                }

                @Override
                public void layoutContainer(Container container) {
                    Dimension dimension = jPanel4.getSize();
                    Dimension dimension2 = jPanel3.getPreferredSize();
                    int n = (dimension.width - 10 - dimension2.width) / 2;
                    jPanel.setBounds(new Rectangle(0, 0, n, dimension.height));
                    jPanel2.setBounds(new Rectangle(n + 10 + dimension2.width, 0, n, dimension.height));
                    jPanel3.setBounds(new Rectangle(n + 5, dimension.height / 2 - dimension2.height / 2, dimension2.width, dimension2.height));
                }
            });
            jPanel4.add(jPanel);
            jPanel4.add(jPanel3);
            jPanel4.add(jPanel2);
            this.actionParametersPanel = new JPanel(new GridBagLayout());
            this.actionParametersPanel.add((Component)new JLabel(I18n.tr("Action parameters", new Object[0])), GBC.eol().insets(0, 10, 0, 20));
            this.actionParametersTable.getColumnModel().getColumn(0).setHeaderValue(I18n.tr("Parameter name", new Object[0]));
            this.actionParametersTable.getColumnModel().getColumn(1).setHeaderValue(I18n.tr("Parameter value", new Object[0]));
            this.actionParametersPanel.add((Component)this.actionParametersTable.getTableHeader(), GBC.eol().fill(2));
            this.actionParametersPanel.add((Component)this.actionParametersTable, GBC.eol().fill(1).insets(0, 0, 0, 10));
            this.actionParametersPanel.setVisible(false);
            PreferenceTabbedPane.PreferencePanel preferencePanel = preferenceTabbedPane.createPreferenceTab(this);
            preferencePanel.add((Component)jPanel4, GBC.eol().fill(1));
            preferencePanel.add((Component)this.actionParametersPanel, GBC.eol().fill(2));
            this.selected.removeAllElements();
            for (ActionDefinition actionDefinition : ToolbarPreferences.this.getDefinedActions()) {
                this.selected.addElement(actionDefinition);
            }
        }

        @Override
        public boolean ok() {
            LinkedList<String> linkedList = new LinkedList();
            ActionParser actionParser = new ActionParser(null);
            for (int i = 0; i < this.selected.size(); ++i) {
                ActionDefinition actionDefinition = this.selected.get(i);
                if (actionDefinition.isSeparator()) {
                    linkedList.add("|");
                    continue;
                }
                String string = actionParser.saveAction(actionDefinition);
                if (string == null) continue;
                linkedList.add(string);
            }
            if (linkedList.isEmpty()) {
                linkedList = Collections.singletonList(ToolbarPreferences.EMPTY_TOOLBAR_MARKER);
            }
            Main.pref.putCollection("toolbar", linkedList);
            Main.toolbar.refreshToolbarControl();
            return false;
        }

        private class ActionTransferable
        implements Transferable {
            private final DataFlavor[] flavors = new DataFlavor[]{ToolbarPreferences.access$400()};
            private final List<ActionDefinition> actions;

            ActionTransferable(List<ActionDefinition> list) {
                this.actions = list;
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                return this.actions;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return this.flavors;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return this.flavors[0] == dataFlavor;
            }
        }

        private final class Move
        implements ActionListener {
            private Move() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if ("<".equals(actionEvent.getActionCommand()) && Settings.this.actionsTree.getSelectionCount() > 0) {
                    int n = Settings.this.selected.getSize();
                    if (Settings.this.selectedList.getSelectedIndex() != -1) {
                        int[] objectArray = Settings.this.selectedList.getSelectedIndices();
                        n = objectArray[objectArray.length - 1];
                    }
                    for (TreePath treePath : Settings.this.actionsTree.getSelectionPaths()) {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                        if (defaultMutableTreeNode.getUserObject() == null) {
                            Settings.this.selected.add(n++, ActionDefinition.getSeparator());
                            continue;
                        }
                        if (!(defaultMutableTreeNode.getUserObject() instanceof Action)) continue;
                        Settings.this.selected.add(n++, new ActionDefinition((Action)defaultMutableTreeNode.getUserObject()));
                    }
                } else if (">".equals(actionEvent.getActionCommand()) && Settings.this.selectedList.getSelectedIndex() != -1) {
                    while (Settings.this.selectedList.getSelectedIndex() != -1) {
                        Settings.this.selected.remove(Settings.this.selectedList.getSelectedIndex());
                    }
                } else if ("up".equals(actionEvent.getActionCommand())) {
                    int n = Settings.this.selectedList.getSelectedIndex();
                    ActionDefinition actionDefinition = (ActionDefinition)Settings.this.selected.get(n);
                    if (n != 0) {
                        Settings.this.selected.remove(n);
                        Settings.this.selected.add(n - 1, actionDefinition);
                        Settings.this.selectedList.setSelectedIndex(n - 1);
                    }
                } else if ("down".equals(actionEvent.getActionCommand())) {
                    int n = Settings.this.selectedList.getSelectedIndex();
                    ActionDefinition actionDefinition = (ActionDefinition)Settings.this.selected.get(n);
                    if (n != Settings.this.selected.size() - 1) {
                        Settings.this.selected.remove(n);
                        Settings.this.selected.add(n + 1, actionDefinition);
                        Settings.this.selectedList.setSelectedIndex(n + 1);
                    }
                }
            }
        }

        private final class SelectedListTransferHandler
        extends TransferHandler {
            private SelectedListTransferHandler() {
            }

            @Override
            protected Transferable createTransferable(JComponent jComponent) {
                ArrayList<ActionDefinition> arrayList = new ArrayList<ActionDefinition>();
                for (ActionDefinition actionDefinition : ((JList)jComponent).getSelectedValuesList()) {
                    arrayList.add(actionDefinition);
                }
                return new ActionTransferable(arrayList);
            }

            @Override
            public int getSourceActions(JComponent jComponent) {
                return 2;
            }

            @Override
            public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                for (DataFlavor dataFlavor : dataFlavorArray) {
                    if (!ACTION_FLAVOR.equals(dataFlavor)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
                super.exportAsDrag(jComponent, inputEvent, n);
                Settings.this.movingComponent = "list";
            }

            @Override
            public boolean importData(JComponent jComponent, Transferable transferable) {
                try {
                    Object object;
                    int n = Settings.this.selectedList.locationToIndex(Settings.this.selectedList.getMousePosition(true));
                    List list = (List)transferable.getTransferData(ACTION_FLAVOR);
                    ActionDefinition actionDefinition = n >= 0 ? (ActionDefinition)Settings.this.selected.elementAt(n) : null;
                    int n2 = list.size();
                    if (actionDefinition != null) {
                        for (Object e : list) {
                            if (!actionDefinition.equals(e)) continue;
                            return false;
                        }
                    }
                    int n3 = -1;
                    boolean bl = "list".equals(Settings.this.movingComponent);
                    if (bl) {
                        n3 = Settings.this.selected.indexOf(list.get(0));
                        object = list.iterator();
                        while (object.hasNext()) {
                            Object e = object.next();
                            Settings.this.selected.removeElement(e);
                        }
                    }
                    object = new int[n2];
                    if (bl) {
                        int n4 = Settings.this.selected.indexOf(actionDefinition);
                        int n5 = n3 <= n4 ? 1 : 0;
                        for (int i = 0; i < n2; ++i) {
                            Settings.this.selected.insertElementAt(list.get(i), n4 + n5 + i);
                            object[i] = n4 + n5 + i;
                        }
                    } else {
                        for (int i = 0; i < n2; ++i) {
                            Settings.this.selected.add(n, list.get(i));
                            object[i] = n + i;
                        }
                    }
                    Settings.this.selectedList.clearSelection();
                    Settings.this.selectedList.setSelectedIndices((int[])object);
                    Settings.this.movingComponent = "";
                    return true;
                }
                catch (Exception exception) {
                    Main.error(exception);
                    return false;
                }
            }

            @Override
            protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
                if ("list".equals(Settings.this.movingComponent)) {
                    try {
                        List list = (List)transferable.getTransferData(ACTION_FLAVOR);
                        boolean bl = Settings.this.selected.contains(list.get(0));
                        if (bl) {
                            int[] nArray = Settings.this.selectedList.getSelectedIndices();
                            Arrays.sort(nArray);
                            for (int i = nArray.length - 1; i >= 0; --i) {
                                Settings.this.selected.remove(nArray[i]);
                            }
                        }
                    }
                    catch (Exception exception) {
                        Main.error(exception);
                    }
                    Settings.this.movingComponent = "";
                }
            }
        }
    }

    private class ToolbarPopupMenu
    extends JPopupMenu {
        private transient ActionDefinition act;
        private final JMenuItem remove = new JMenuItem(new AbstractAction(I18n.tr("Remove from toolbar", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinkedList<String> linkedList = new LinkedList<String>(ToolbarPreferences.getToolString());
                ActionParser actionParser = new ActionParser(null);
                String string = actionParser.saveAction(ToolbarPopupMenu.this.act);
                linkedList.remove(string);
                Main.pref.putCollection("toolbar", linkedList);
                Main.toolbar.refreshToolbarControl();
            }
        });
        private final JMenuItem configure = new JMenuItem(new AbstractAction(I18n.tr("Configure toolbar", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferenceDialog preferenceDialog = new PreferenceDialog(Main.parent);
                preferenceDialog.selectPreferencesTabByName("toolbar");
                preferenceDialog.setVisible(true);
            }
        });
        private final JMenuItem shortcutEdit = new JMenuItem(new AbstractAction(I18n.tr("Edit shortcut", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferenceDialog preferenceDialog = new PreferenceDialog(Main.parent);
                preferenceDialog.getTabbedPane().getShortcutPreference().setDefaultFilter(ToolbarPopupMenu.this.act.getDisplayName());
                preferenceDialog.selectPreferencesTabByName("shortcuts");
                preferenceDialog.setVisible(true);
                Main.toolbar.refreshToolbarControl();
            }
        });
        private final JCheckBoxMenuItem doNotHide = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Do not hide toolbar and menu", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ((JCheckBoxMenuItem)actionEvent.getSource()).getState();
                Main.pref.put("toolbar.always-visible", bl);
                Main.pref.put("menu.always-visible", bl);
            }
        });

        private ToolbarPopupMenu() {
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    ToolbarPopupMenu.this.setActionAndAdapt((ActionDefinition)ToolbarPreferences.this.buttonActions.get(((JPopupMenu)popupMenuEvent.getSource()).getInvoker()));
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            });
            this.add(this.remove);
            this.add(this.configure);
            this.add(this.shortcutEdit);
            this.add(this.doNotHide);
        }

        private void setActionAndAdapt(ActionDefinition actionDefinition) {
            this.act = actionDefinition;
            this.doNotHide.setSelected(Main.pref.getBoolean("toolbar.always-visible", true));
            this.remove.setVisible(this.act != null);
            this.shortcutEdit.setVisible(this.act != null);
        }
    }

    private static class ActionParametersTableModel
    extends AbstractTableModel {
        private transient ActionDefinition currentAction = ActionDefinition.getSeparator();

        private ActionParametersTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            int n;
            int n2 = n = this.currentAction.getAction() instanceof AdaptableAction ? 2 : 0;
            if (this.currentAction.isSeparator() || !(this.currentAction.getAction() instanceof ParameterizedAction)) {
                return n;
            }
            ParameterizedAction parameterizedAction = (ParameterizedAction)this.currentAction.getAction();
            return parameterizedAction.getActionParameters().size() + n;
        }

        private ActionParameter<Object> getParam(int n) {
            ParameterizedAction parameterizedAction = (ParameterizedAction)this.currentAction.getAction();
            return parameterizedAction.getActionParameters().get(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.currentAction.getAction() instanceof AdaptableAction) {
                if (n < 2) {
                    switch (n2) {
                        case 0: {
                            return n == 0 ? I18n.tr("Tooltip", new Object[0]) : I18n.tr("Icon", new Object[0]);
                        }
                        case 1: {
                            return n == 0 ? this.currentAction.getName() : this.currentAction.getIcon();
                        }
                    }
                    return null;
                }
                n -= 2;
            }
            ActionParameter<Object> actionParameter = this.getParam(n);
            switch (n2) {
                case 0: {
                    return actionParameter.getName();
                }
                case 1: {
                    return actionParameter.writeToString(this.currentAction.getParameters().get(actionParameter.getName()));
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ActionParameter<Object> actionParameter;
            String string = (String)object;
            int n3 = n;
            if (this.currentAction.getAction() instanceof AdaptableAction) {
                if (n == 0) {
                    this.currentAction.setName(string);
                    return;
                }
                if (n == 1) {
                    this.currentAction.setIcon(string);
                    return;
                }
                n3 -= 2;
            }
            if ((actionParameter = this.getParam(n3)) != null && !string.isEmpty()) {
                this.currentAction.getParameters().put(actionParameter.getName(), actionParameter.readFromString((String)object));
            }
        }

        public void setCurrentAction(ActionDefinition actionDefinition) {
            this.currentAction = actionDefinition;
            this.fireTableDataChanged();
        }
    }

    public static class ActionParser {
        private final Map<String, Action> actions;
        private final StringBuilder result = new StringBuilder();
        private int index;
        private char[] s;

        public ActionParser(Map<String, Action> map) {
            this.actions = map;
        }

        private String readTillChar(char c, char c2) {
            this.result.setLength(0);
            while (this.index < this.s.length && this.s[this.index] != c && this.s[this.index] != c2) {
                if (this.s[this.index] == '\\') {
                    ++this.index;
                    if (this.index >= this.s.length) break;
                }
                this.result.append(this.s[this.index]);
                ++this.index;
            }
            return this.result.toString();
        }

        private void skip(char c) {
            if (this.index < this.s.length && this.s[this.index] == c) {
                ++this.index;
            }
        }

        public ActionDefinition loadAction(String string) {
            Object object;
            Object object2;
            this.index = 0;
            this.s = string.toCharArray();
            String string2 = this.readTillChar('(', '{');
            Action action = this.actions.get(string2);
            if (action == null) {
                return null;
            }
            ActionDefinition actionDefinition = new ActionDefinition(action);
            if (action instanceof ParameterizedAction) {
                this.skip('(');
                object2 = (ParameterizedAction)action;
                object = new ConcurrentHashMap();
                for (ActionParameter<?> object3 : object2.getActionParameters()) {
                    object.put(object3.getName(), object3);
                }
                while (this.index < this.s.length && this.s[this.index] != ')') {
                    ActionParameter actionParameter;
                    String string3 = this.readTillChar('=', '=');
                    this.skip('=');
                    String string4 = this.readTillChar(',', ')');
                    if (!string3.isEmpty() && !string4.isEmpty() && (actionParameter = (ActionParameter)object.get(string3)) != null) {
                        actionDefinition.getParameters().put(string3, actionParameter.readFromString(string4));
                    }
                    this.skip(',');
                }
                this.skip(')');
            }
            if (action instanceof AdaptableAction) {
                this.skip('{');
                while (this.index < this.s.length && this.s[this.index] != '}') {
                    object2 = this.readTillChar('=', '=');
                    this.skip('=');
                    object = this.readTillChar(',', '}');
                    if ("icon".equals(object2) && !((String)object).isEmpty()) {
                        actionDefinition.setIcon((String)object);
                    } else if ("name".equals(object2) && !((String)object).isEmpty()) {
                        actionDefinition.setName((String)object);
                    }
                    this.skip(',');
                }
                this.skip('}');
            }
            return actionDefinition;
        }

        private void escape(String string) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\\' || c == '(' || c == '{' || c == ',' || c == ')' || c == '}' || c == '=') {
                    this.result.append('\\');
                    this.result.append(c);
                    continue;
                }
                this.result.append(c);
            }
        }

        public String saveAction(ActionDefinition actionDefinition) {
            this.result.setLength(0);
            String string = (String)actionDefinition.getAction().getValue("toolbar");
            if (string == null) {
                return null;
            }
            this.escape(string);
            if (actionDefinition.getAction() instanceof ParameterizedAction) {
                this.result.append('(');
                List<ActionParameter<?>> list = ((ParameterizedAction)actionDefinition.getAction()).getActionParameters();
                for (int i = 0; i < list.size(); ++i) {
                    ActionParameter<?> actionParameter = list.get(i);
                    this.escape(actionParameter.getName());
                    this.result.append('=');
                    Object object = actionDefinition.getParameters().get(actionParameter.getName());
                    if (object != null) {
                        this.escape(actionParameter.writeToString(object));
                    }
                    if (i < list.size() - 1) {
                        this.result.append(',');
                        continue;
                    }
                    this.result.append(')');
                }
            }
            if (actionDefinition.getAction() instanceof AdaptableAction) {
                boolean bl = true;
                String string2 = actionDefinition.getName();
                if (!string2.isEmpty()) {
                    this.result.append(bl ? "{" : ",");
                    this.result.append("name=");
                    this.escape(string2);
                    bl = false;
                }
                if (!(string2 = actionDefinition.getIcon()).isEmpty()) {
                    this.result.append(bl ? "{" : ",");
                    this.result.append("icon=");
                    this.escape(string2);
                    bl = false;
                }
                if (!bl) {
                    this.result.append('}');
                }
            }
            return this.result.toString();
        }
    }

    public static class ActionDefinition {
        private final Action action;
        private String name = "";
        private String icon = "";
        private ImageIcon ico;
        private final Map<String, Object> parameters = new ConcurrentHashMap<String, Object>();

        public ActionDefinition(Action action) {
            this.action = action;
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        public Action getParametrizedAction() {
            if (this.getAction() instanceof ParameterizedAction) {
                return new ParameterizedActionDecorator((ParameterizedAction)this.getAction(), this.parameters);
            }
            return this.getAction();
        }

        public Action getAction() {
            return this.action;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.name.isEmpty() ? (String)this.action.getValue("Name") : this.name;
        }

        public String getDisplayTooltip() {
            if (!this.name.isEmpty()) {
                return this.name;
            }
            Object object = this.action.getValue("Optional tooltip text");
            if (object != null) {
                return (String)object;
            }
            return (String)this.action.getValue("ShortDescription");
        }

        public Icon getDisplayIcon() {
            if (this.ico != null) {
                return this.ico;
            }
            Object object = this.action.getValue("SwingLargeIconKey");
            if (object == null) {
                object = this.action.getValue("SmallIcon");
            }
            return (Icon)object;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String string) {
            this.icon = string;
            this.ico = ImageProvider.getIfAvailable("", string);
        }

        public boolean isSeparator() {
            return this.action == null;
        }

        public static ActionDefinition getSeparator() {
            return new ActionDefinition(null);
        }

        public boolean hasParameters() {
            if (!(this.getAction() instanceof ParameterizedAction)) {
                return false;
            }
            for (Object object : this.parameters.values()) {
                if (object == null) continue;
                return true;
            }
            return false;
        }
    }
}

