/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public final class CertificateAmendment {
    private static final String[] CERT_AMEND = new String[]{"resource://data/security/DST_Root_CA_X3.pem", "resource://data/security/StartCom_Certification_Authority.pem"};
    private static final String[] SHA_HASHES = new String[]{"0687260331a72403d909f105e69bcf0d32e1bd2493ffc6d9206d11bcd6770739", "c766a9bef2d4071c863a31aa4920e813b2d198608cb7b7cfe21143b836df09ea"};

    private CertificateAmendment() {
    }

    public static void addMissingCertificates() throws IOException {
        Object object;
        Object object2;
        KeyStore keyStore;
        if (!Main.pref.getBoolean("tls.add-missing-certificates", true)) {
            return;
        }
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        }
        catch (KeyStoreException keyStoreException) {
            throw new IOException(keyStoreException);
        }
        Path path = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
        try {
            object2 = Files.newInputStream(path, new OpenOption[0]);
            Throwable throwable = null;
            try {
                keyStore.load((InputStream)object2, "changeit".toCharArray());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object2 != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)object2).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStream)object2).close();
                    }
                }
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw new IOException(certificateException);
        }
        try {
            object2 = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException(certificateException);
        }
        boolean bl = false;
        for (int i = 0; i < CERT_AMEND.length; ++i) {
            Object object3;
            X509Certificate x509Certificate;
            object = new CachedFile(CERT_AMEND[i]);
            byte[] byArray = ((CachedFile)object).getByteContent();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                x509Certificate = (X509Certificate)((CertificateFactory)object2).generateCertificate(byteArrayInputStream);
                object3 = MessageDigest.getInstance("SHA-256");
                String string = Utils.toHexString(((MessageDigest)object3).digest(x509Certificate.getEncoded()));
                if (!SHA_HASHES[i].equals(string)) {
                    throw new RuntimeException(I18n.tr("Error adding certificate {0} - certificate fingerprint mismatch. Expected {1}, was {2}", CERT_AMEND[i], SHA_HASHES[i], string));
                }
            }
            catch (CertificateException certificateException) {
                throw new IOException(certificateException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException(noSuchAlgorithmException);
            }
            if (!CertificateAmendment.certificateIsMissing(keyStore, x509Certificate)) continue;
            if (Main.isDebugEnabled()) {
                Main.debug(I18n.tr("Adding certificate for TLS connections: {0}", x509Certificate.getSubjectX500Principal().getName()));
            }
            object3 = "josm:" + new File(CERT_AMEND[i]).getName();
            try {
                keyStore.setCertificateEntry((String)object3, x509Certificate);
            }
            catch (KeyStoreException keyStoreException) {
                throw new AssertionError((Object)keyStoreException);
            }
            bl = true;
        }
        if (bl) {
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(keyStore);
                object = SSLContext.getInstance("TLS");
                ((SSLContext)object).init(null, trustManagerFactory.getTrustManagers(), null);
                SSLContext.setDefault((SSLContext)object);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
                throw new RuntimeException(generalSecurityException);
            }
        }
    }

    private static boolean certificateIsMissing(KeyStore keyStore, X509Certificate x509Certificate) {
        PKIXParameters pKIXParameters;
        try {
            pKIXParameters = new PKIXParameters(keyStore);
        }
        catch (KeyStoreException keyStoreException) {
            throw new AssertionError((Object)keyStoreException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException(invalidAlgorithmParameterException);
        }
        String string = x509Certificate.getSubjectX500Principal().getName();
        for (TrustAnchor trustAnchor : pKIXParameters.getTrustAnchors()) {
            X509Certificate x509Certificate2 = trustAnchor.getTrustedCert();
            if (!Objects.equals(string, x509Certificate2.getSubjectX500Principal().getName())) continue;
            return false;
        }
        return true;
    }
}

